/*
 * Decompiled with CFR 0.152.
 */
package rene.lister;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.Global;
import rene.gui.MyPanel;
import rene.lister.Element;
import rene.lister.Lister;
import rene.lister.ListerMouseEvent;
import rene.lister.Wheel;
import rene.lister.WheelListener;
import rene.util.MyVector;

public class ListerPanel
extends MyPanel
implements WheelListener {
    private MyVector V;
    int Top;
    Image I;
    int W;
    int H;
    Graphics IG;
    Font F;
    FontMetrics FM;
    int Leading;
    int Height;
    int Ascent;
    int Descent;
    int PageSize;
    int HOffset;
    boolean ShowLast;
    Lister LD;
    String Name;
    public Color ListingBackground = null;
    public boolean MultipleSelection = true;
    public boolean EasyMultipleSelection = false;
    public boolean ReportSingleClick = false;
    public boolean RightMouseClick = false;
    int State = 0;
    Vector VAL = new Vector();
    MyVector Selected = new MyVector();

    public ListerPanel(Lister lister, String string) {
        this.LD = lister;
        this.Name = string;
        this.V = new MyVector();
        this.Top = 0;
        Wheel wheel = new Wheel(this);
        this.addMouseWheelListener(wheel);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ListerPanel.this.clicked(mouseEvent);
            }
        });
    }

    public ListerPanel(Lister lister) {
        this(lister, "");
    }

    public synchronized void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.I == null || this.I.getWidth(this) != dimension.width || this.I.getHeight(this) != dimension.height) {
            this.W = dimension.width;
            this.H = dimension.height;
            this.I = this.createImage(this.W, this.H);
            if (this.I == null) {
                return;
            }
            this.IG = this.I.getGraphics();
            this.init();
        }
        this.dopaint(this.IG);
        graphics.drawImage(this.I, 0, 0, this.W, this.H, this);
        double d2 = this.V.size() > 1 ? (double)this.Top / (double)this.V.size() : 0.0;
        double d3 = this.V.size() > 2 * this.PageSize ? (double)this.PageSize / (double)this.V.size() : 0.5;
        double d4 = this.HOffset < 10 * this.W ? (double)this.HOffset / (double)(10 * this.W) : 0.9;
        double d5 = 0.1;
        this.LD.setScrollbars(d2, d3, d4, d5);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    synchronized void init() {
        this.F = this.getFont();
        this.FM = this.getFontMetrics(this.F);
        this.Leading = this.FM.getLeading() + Global.getParameter("fixedfont.spacing", -1);
        this.Height = this.FM.getHeight();
        this.Ascent = this.FM.getAscent();
        this.Descent = this.FM.getDescent();
        if (Global.Background != null) {
            this.setBackground(Global.Background);
        }
        this.PageSize = this.Height + this.Leading > 0 ? this.H / (this.Height + this.Leading) : 10;
        this.antialias(true);
        this.Top = 0;
    }

    public void antialias(boolean bl) {
        if (Global.getParameter("font.smooth", true)) {
            this.IG = (Graphics2D)this.IG;
            ((Graphics2D)this.IG).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public synchronized void dopaint(Graphics graphics) {
        int n;
        if (this.ShowLast) {
            this.Top = this.V.size() - this.PageSize + 1;
            if (this.Top < 0) {
                this.Top = 0;
            }
            this.ShowLast = false;
        }
        if (this.ListingBackground != null) {
            graphics.setColor(this.ListingBackground);
        } else {
            graphics.setColor(this.getBackground());
        }
        graphics.fillRect(0, 0, this.W, this.H);
        graphics.setColor(Color.black);
        int n2 = this.Leading + this.Ascent;
        int n3 = this.getSize().height - this.Descent;
        if (n < 0) {
            return;
        }
        for (n = this.Top; n - this.Top < this.PageSize && n < this.V.size(); ++n) {
            Color color;
            Element element = (Element)this.V.elementAt(n);
            if (this.isSelected(n)) {
                graphics.setColor(this.getBackground().darker());
                graphics.fillRect(0, n2 - this.Ascent, this.W, this.Height);
                graphics.setColor(Color.black);
            }
            if ((color = element.getElementColor()) != null) {
                graphics.setColor(color);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawString(element.getElementString(this.State), 2 - this.HOffset, n2);
            n2 += this.Leading + this.Height;
        }
    }

    public void setState(int n) {
        this.State = n;
    }

    public synchronized void add(Element element) {
        this.V.addElement(element);
    }

    public synchronized void up(int n) {
        this.Top += n;
        if (this.Top >= this.V.size()) {
            this.Top = this.V.size() - 1;
        }
        if (this.Top < 0) {
            this.Top = 0;
        }
        this.repaint();
    }

    public synchronized void down(int n) {
        this.Top -= n;
        if (this.Top < 0) {
            this.Top = 0;
        }
        this.repaint();
    }

    public synchronized void pageUp() {
        this.up(this.PageSize - 1);
        this.repaint();
    }

    public synchronized void pageDown() {
        this.down(this.PageSize - 1);
        this.repaint();
    }

    public synchronized void setVerticalPos(double d2) {
        this.Top = (int)(d2 * (double)this.V.size());
        if (this.Top >= this.V.size()) {
            this.Top = this.V.size() - 1;
        }
        this.repaint();
    }

    public synchronized void setHorizontalPos(double d2) {
        this.HOffset = (int)(d2 * 10.0 * (double)this.W);
        this.repaint();
    }

    public synchronized void clear() {
        this.Selected.removeAllElements();
        this.V.removeAllElements();
        this.Top = 0;
    }

    public synchronized void showLast() {
        this.ShowLast = true;
    }

    public synchronized boolean isSelected(int n) {
        Enumeration enumeration = this.Selected.elements();
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public synchronized void toggleSelect(int n) {
        Enumeration enumeration = this.Selected.elements();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (n2 != n) continue;
            this.Selected.removeElement(n2);
            return;
        }
        this.Selected.addElement(new Integer(n));
    }

    public synchronized void expandSelect(int n) {
        int n2;
        int n3;
        int n4 = -1;
        Enumeration enumeration = this.Selected.elements();
        while (enumeration.hasMoreElements()) {
            n3 = (Integer)enumeration.nextElement();
            if (n3 <= n4 || n3 >= n) continue;
            n4 = n3;
        }
        if (n4 >= 0) {
            for (n3 = n4 + 1; n3 <= n; ++n3) {
                this.select(n3);
            }
            return;
        }
        n3 = this.V.size();
        enumeration = this.Selected.elements();
        while (enumeration.hasMoreElements()) {
            n2 = (Integer)enumeration.nextElement();
            if (n2 >= n3 || n2 <= n) continue;
            n3 = n2;
        }
        if (n3 < this.V.size()) {
            for (n2 = n; n2 <= n3; ++n2) {
                this.select(n2);
            }
        }
    }

    public synchronized void select(int n) {
        if (!this.isSelected(n)) {
            this.Selected.addElement(new Integer(n));
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.VAL.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.VAL.removeElement(actionListener);
    }

    public void clicked(MouseEvent mouseEvent) {
        block12: {
            int n;
            block11: {
                n = mouseEvent.getY() / (this.Leading + this.Height);
                if (!mouseEvent.isMetaDown() || !this.RightMouseClick) break block11;
                Enumeration enumeration = this.VAL.elements();
                while (enumeration.hasMoreElements()) {
                    ((ActionListener)enumeration.nextElement()).actionPerformed(new ListerMouseEvent((Object)this.LD, this.Name, mouseEvent));
                }
                break block12;
            }
            if (this.Top + n >= this.V.size()) {
                return;
            }
            int n2 = n + this.Top;
            if (mouseEvent.getClickCount() >= 2) {
                if (!this.MultipleSelection) {
                    this.Selected.removeAllElements();
                }
                this.select(n2);
            } else if (this.MultipleSelection && (mouseEvent.isControlDown() || this.EasyMultipleSelection || mouseEvent.isShiftDown())) {
                if (mouseEvent.isControlDown() || this.EasyMultipleSelection) {
                    this.toggleSelect(n2);
                } else if (mouseEvent.isShiftDown()) {
                    this.expandSelect(n2);
                }
            } else {
                this.Selected.removeAllElements();
                this.Selected.addElement(new Integer(n2));
            }
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            graphics.dispose();
            if (mouseEvent.getClickCount() < 2 && !this.ReportSingleClick) break block12;
            Enumeration enumeration = this.VAL.elements();
            while (enumeration.hasMoreElements()) {
                ((ActionListener)enumeration.nextElement()).actionPerformed(new ListerMouseEvent((Object)this.LD, this.Name, mouseEvent));
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 300);
    }

    public synchronized Element getElementAt(int n) {
        return (Element)this.V.elementAt(n);
    }

    public synchronized void save(PrintWriter printWriter) {
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)enumeration.nextElement();
            printWriter.println(element.getElementString());
        }
    }

    public void setListingBackground(Color color) {
        this.ListingBackground = color;
    }
}

