# 2025-04-08 Triage Log

A busy week with lots of performance improvements. The largest performance improvement was from a revert of a previous week's regression just in time for the beta release. Another large improvement came to small tweaks in the query system showing that there still are opportunities for small, targeted performance improvements in the compiler.

Triage done by **@rylev**.
Revision range: [2ea33b59..e643f59f](https://perf.rust-lang.org/?start=2ea33b591050c4ca1a3752830b29112638faecf6&end=e643f59f6da3a84f43e75dea99afaa5b041ea6bf&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.2%, 1.9%]    | 11    |
| Regressions ❌ <br /> (secondary)  | 8.4%  | [0.2%, 38.5%]   | 16    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-35.1%, -0.2%] | 206   |
| Improvements ✅ <br /> (secondary) | -1.8% | [-8.6%, -0.1%]  | 155   |
| All ❌✅ (primary)                 | -0.9% | [-35.1%, 1.9%]  | 217   |


2 Regressions, 9 Improvements, 5 Mixed; 4 of them in rollups
48 artifact comparisons made in total

#### Regressions

Initial support for auto traits with default bounds [#120706](https://github.com/rust-lang/rust/pull/120706) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4fd8c04da0674af2c51310c9982370bfadfa1b98&end=9e14530c7c27123484658c88c2148a552b01e73b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.2%, 1.3%] | 7     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.2%, 1.1%] | 21    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.2%, 1.3%] | 7     |
- A potential perf fix was tried in https://github.com/rust-lang/rust/pull/139365, but it did not work.
- Asked the author and reviewer if there was anything else to try.


Do not visit whole crate to compute `lints_that_dont_need_to_run`. [#133781](https://github.com/rust-lang/rust/pull/133781) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e643f59f6da3a84f43e75dea99afaa5b041ea6bf&end=c6c179662d5a6fc0520e05b5c0682dcfc7333f77&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 7     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.1%, 0.6%] | 25    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 7     |
- Seems like the perf regressions are a revert back to the mean after https://github.com/rust-lang/rust/pull/139482 which looks like a fluke run.


#### Improvements

Revert "Rollup merge of #136127 - WaffleLapkin:dyn_ptr_unwrap_cast, r=compiler-errors" [#138892](https://github.com/rust-lang/rust/pull/138892) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=10a76d634781180b4f5402c519f0c237d3be6ee6&end=ab5b1be771e63ea3736d8830e7b661decc6b1abc&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.0%, 0.2%]    | 2     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.5%, -0.2%]  | 99    |
| Improvements ✅ <br /> (secondary) | -3.0% | [-11.3%, -0.1%] | 105   |
| All ❌✅ (primary)                 | -0.7% | [-1.5%, -0.2%]  | 99    |


Move `ast::Item::ident` into `ast::ItemKind` [#138740](https://github.com/rust-lang/rust/pull/138740) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=97ea17b71aba0badfe9c8295f57a434bf79bdb72&end=ed201574c5d6117fb4a491db545c96fa4289ea9c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.8%, -0.3%] | 2     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.1%] | 3     |


Misc query tweaks [#139234](https://github.com/rust-lang/rust/pull/139234) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d5b4c2e4f19b6d7037371cdaecc3cc2c701c68df&end=365806089020f60a50391133a1430c40bc86963c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.4%, -0.2%] | 71    |
| Improvements ✅ <br /> (secondary) | -1.3% | [-2.2%, -0.6%] | 9     |
| All ❌✅ (primary)                 | -0.6% | [-1.4%, -0.2%] | 71    |


Rollup of 7 pull requests [#139301](https://github.com/rust-lang/rust/pull/139301) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=946aea0b3d9f43e57953ce5094d8e4a2a244ce71&end=82eb03ec6220ee435e0e07fdaf3f0a68a79aab17&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.1%] | 35    |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 8     |


Rollup of 9 pull requests [#139336](https://github.com/rust-lang/rust/pull/139336) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=00095b3da4f23d9b3e7a809ac6a4e2b2530df84c&end=4fd8c04da0674af2c51310c9982370bfadfa1b98&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.1%] | 21    |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 6     |


Folder experiment: Monomorphize region resolver [#139287](https://github.com/rust-lang/rust/pull/139287) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9e14530c7c27123484658c88c2148a552b01e73b&end=f174fd716a429fa17eb1e98ba4e382f09312f8ad&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.7%, -0.2%] | 34    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.6%, -0.2%] | 19    |
| All ❌✅ (primary)                 | -0.3% | [-0.7%, -0.2%] | 34    |


hygiene: Avoid recursion in syntax context decoding [#139281](https://github.com/rust-lang/rust/pull/139281) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1e008dd5d83e782ad37fc9cf6824733f824cc8cd&end=da8321773a5c3306e1ff159cf0560c9f89f016b9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.7%, -0.4%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.7%, -0.3%] | 14    |
| All ❌✅ (primary)                 | -0.5% | [-0.7%, -0.4%] | 3     |


Folder experiment: Micro-optimize RegionEraserVisitor [#139292](https://github.com/rust-lang/rust/pull/139292) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0e9c3e52e492c9edacae96feb8deeb1695731273&end=0c478fdfe138a8b09744798c85fe2be657768b00&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -4.7% | [-34.9%, -0.4%] | 9     |
| Improvements ✅ <br /> (secondary) | -     | -               | 0     |
| All ❌✅ (primary)                 | -4.7% | [-34.9%, -0.4%] | 9     |


Rollup of 9 pull requests [#139482](https://github.com/rust-lang/rust/pull/139482) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8fb32ab8e563124fe0968a2878b7f5b5d0e8d722&end=e643f59f6da3a84f43e75dea99afaa5b041ea6bf&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.7%, -0.2%] | 22    |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 8     |


#### Mixed

Remove `NtExpr` and `NtLiteral` [#138478](https://github.com/rust-lang/rust/pull/138478) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9b7d5ac8180f70110e94f92ccbf8fa2263d24c73&end=70dab5a27c03a5637cc1d4ba36a5139760d25e38&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.1%, 2.6%]   | 80    |
| Regressions ❌ <br /> (secondary)  | 6.8%  | [0.2%, 38.2%]  | 41    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.2%] | 9     |
| All ❌✅ (primary)                 | 0.5%  | [0.1%, 2.6%]   | 80    |
- Performance impact was expected by the [author](https://github.com/rust-lang/rust/pull/138478#issuecomment-2771495885).


Update dependencies [#138848](https://github.com/rust-lang/rust/pull/138848) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c9cd7078450abc15f6b8c969b1021934fb36c2a6&end=79de6c0bbe76904ac7086b05327ee5756fb302b1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.5%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.4%, -0.1%] | 14    |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 15    |
| All ❌✅ (primary)                 | -0.2% | [-0.4%, 0.4%]  | 15    |
- Improvements outweigh the regressions and the number of regressions is small.


Various local trait item iteration cleanups [#139018](https://github.com/rust-lang/rust/pull/139018) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=79de6c0bbe76904ac7086b05327ee5756fb302b1&end=ae9173d7dd4a31806c950c90dcc331f1508b4d17&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.6%, -0.1%] | 40    |
| All ❌✅ (primary)                 | -0.1% | [-0.3%, 0.2%]  | 8     |
- Perf regressions outweighed by the perf improvements.


Rollup of 5 pull requests [#139257](https://github.com/rust-lang/rust/pull/139257) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ae9173d7dd4a31806c950c90dcc331f1508b4d17&end=4f0de4c81d80121ac7b576bc68d8016064f4d261&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 13    |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.6%]   | 32    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.7%, -0.6%] | 4     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.0%, -1.0%] | 1     |
| All ❌✅ (primary)                 | 0.1%  | [-0.7%, 0.4%]  | 17    |
- Found the cause in https://github.com/rust-lang/rust/pull/139232#issuecomment-2774701657


gvn: Invalid dereferences for all non-local mutations [#132527](https://github.com/rust-lang/rust/pull/132527) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=82eb03ec6220ee435e0e07fdaf3f0a68a79aab17&end=00095b3da4f23d9b3e7a809ac6a4e2b2530df84c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 0.9%]   | 37    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.1%, 1.3%]   | 29    |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.7%, -0.6%] | 6     |
| Improvements ✅ <br /> (secondary) | -1.7% | [-1.8%, -1.5%] | 6     |
| All ❌✅ (primary)                 | 0.2%  | [-1.7%, 0.9%]  | 43    |
- This PR seems to have brought about a decent number of perf regressions. 
- Asked the author and reviewer

