// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::ffi;
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "ShumateDataSourceRequest")]
    pub struct DataSourceRequest(Object<ffi::ShumateDataSourceRequest, ffi::ShumateDataSourceRequestClass>);

    match fn {
        type_ => || ffi::shumate_data_source_request_get_type(),
    }
}

impl DataSourceRequest {
    pub const NONE: Option<&'static DataSourceRequest> = None;

    #[doc(alias = "shumate_data_source_request_new")]
    pub fn new(x: i32, y: i32, zoom_level: i32) -> DataSourceRequest {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::shumate_data_source_request_new(x, y, zoom_level)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`DataSourceRequest`] objects.
    ///
    /// This method returns an instance of [`DataSourceRequestBuilder`](crate::builders::DataSourceRequestBuilder) which can be used to create [`DataSourceRequest`] objects.
    pub fn builder() -> DataSourceRequestBuilder {
        DataSourceRequestBuilder::new()
    }
}

#[cfg(feature = "v1_1")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
impl Default for DataSourceRequest {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`DataSourceRequest`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct DataSourceRequestBuilder {
    builder: glib::object::ObjectBuilder<'static, DataSourceRequest>,
}

impl DataSourceRequestBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    pub fn x(self, x: i32) -> Self {
        Self {
            builder: self.builder.property("x", x),
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    pub fn y(self, y: i32) -> Self {
        Self {
            builder: self.builder.property("y", y),
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    pub fn zoom_level(self, zoom_level: i32) -> Self {
        Self {
            builder: self.builder.property("zoom-level", zoom_level),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`DataSourceRequest`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> DataSourceRequest {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

pub trait DataSourceRequestExt: IsA<DataSourceRequest> + 'static {
    #[doc(alias = "shumate_data_source_request_complete")]
    fn complete(&self) {
        unsafe {
            ffi::shumate_data_source_request_complete(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_data_source_request_emit_data")]
    fn emit_data(&self, data: &glib::Bytes, complete: bool) {
        unsafe {
            ffi::shumate_data_source_request_emit_data(
                self.as_ref().to_glib_none().0,
                data.to_glib_none().0,
                complete.into_glib(),
            );
        }
    }

    #[doc(alias = "shumate_data_source_request_emit_error")]
    fn emit_error(&self, error: &glib::Error) {
        unsafe {
            ffi::shumate_data_source_request_emit_error(
                self.as_ref().to_glib_none().0,
                error.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_data_source_request_get_data")]
    #[doc(alias = "get_data")]
    fn data(&self) -> Option<glib::Bytes> {
        unsafe {
            from_glib_none(ffi::shumate_data_source_request_get_data(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_data_source_request_get_error")]
    #[doc(alias = "get_error")]
    fn error(&self) -> Option<glib::Error> {
        unsafe {
            from_glib_none(ffi::shumate_data_source_request_get_error(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_data_source_request_get_x")]
    #[doc(alias = "get_x")]
    fn x(&self) -> i32 {
        unsafe { ffi::shumate_data_source_request_get_x(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "shumate_data_source_request_get_y")]
    #[doc(alias = "get_y")]
    fn y(&self) -> i32 {
        unsafe { ffi::shumate_data_source_request_get_y(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "shumate_data_source_request_get_zoom_level")]
    #[doc(alias = "get_zoom_level")]
    #[doc(alias = "zoom-level")]
    fn zoom_level(&self) -> i32 {
        unsafe { ffi::shumate_data_source_request_get_zoom_level(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "shumate_data_source_request_is_completed")]
    #[doc(alias = "completed")]
    fn is_completed(&self) -> bool {
        unsafe {
            from_glib(ffi::shumate_data_source_request_is_completed(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "completed")]
    fn connect_completed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_completed_trampoline<
            P: IsA<DataSourceRequest>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateDataSourceRequest,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(DataSourceRequest::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::completed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_completed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "data")]
    fn connect_data_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_data_trampoline<
            P: IsA<DataSourceRequest>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateDataSourceRequest,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(DataSourceRequest::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::data".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_data_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "error")]
    fn connect_error_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_error_trampoline<
            P: IsA<DataSourceRequest>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateDataSourceRequest,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(DataSourceRequest::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::error".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_error_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<DataSourceRequest>> DataSourceRequestExt for O {}
