// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetAPI5GatewayParams creates a new GetAPI5GatewayParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAPI5GatewayParams() *GetAPI5GatewayParams {
	return &GetAPI5GatewayParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAPI5GatewayParamsWithTimeout creates a new GetAPI5GatewayParams object
// with the ability to set a timeout on a request.
func NewGetAPI5GatewayParamsWithTimeout(timeout time.Duration) *GetAPI5GatewayParams {
	return &GetAPI5GatewayParams{
		timeout: timeout,
	}
}

// NewGetAPI5GatewayParamsWithContext creates a new GetAPI5GatewayParams object
// with the ability to set a context for a request.
func NewGetAPI5GatewayParamsWithContext(ctx context.Context) *GetAPI5GatewayParams {
	return &GetAPI5GatewayParams{
		Context: ctx,
	}
}

// NewGetAPI5GatewayParamsWithHTTPClient creates a new GetAPI5GatewayParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAPI5GatewayParamsWithHTTPClient(client *http.Client) *GetAPI5GatewayParams {
	return &GetAPI5GatewayParams{
		HTTPClient: client,
	}
}

/*
GetAPI5GatewayParams contains all the parameters to send to the API endpoint

	for the get API 5 gateway operation.

	Typically these are written to a http.Request.
*/
type GetAPI5GatewayParams struct {

	/* Cc.

	   Country code (ISO-2)
	*/
	Cc *string

	/* Loc.

	   location
	*/
	Loc *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get API 5 gateway params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAPI5GatewayParams) WithDefaults() *GetAPI5GatewayParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get API 5 gateway params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAPI5GatewayParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get API 5 gateway params
func (o *GetAPI5GatewayParams) WithTimeout(timeout time.Duration) *GetAPI5GatewayParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get API 5 gateway params
func (o *GetAPI5GatewayParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get API 5 gateway params
func (o *GetAPI5GatewayParams) WithContext(ctx context.Context) *GetAPI5GatewayParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get API 5 gateway params
func (o *GetAPI5GatewayParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get API 5 gateway params
func (o *GetAPI5GatewayParams) WithHTTPClient(client *http.Client) *GetAPI5GatewayParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get API 5 gateway params
func (o *GetAPI5GatewayParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCc adds the cc to the get API 5 gateway params
func (o *GetAPI5GatewayParams) WithCc(cc *string) *GetAPI5GatewayParams {
	o.SetCc(cc)
	return o
}

// SetCc adds the cc to the get API 5 gateway params
func (o *GetAPI5GatewayParams) SetCc(cc *string) {
	o.Cc = cc
}

// WithLoc adds the loc to the get API 5 gateway params
func (o *GetAPI5GatewayParams) WithLoc(loc *string) *GetAPI5GatewayParams {
	o.SetLoc(loc)
	return o
}

// SetLoc adds the loc to the get API 5 gateway params
func (o *GetAPI5GatewayParams) SetLoc(loc *string) {
	o.Loc = loc
}

// WriteToRequest writes these params to a swagger request
func (o *GetAPI5GatewayParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Cc != nil {

		// query param cc
		var qrCc string

		if o.Cc != nil {
			qrCc = *o.Cc
		}
		qCc := qrCc
		if qCc != "" {

			if err := r.SetQueryParam("cc", qCc); err != nil {
				return err
			}
		}
	}

	if o.Loc != nil {

		// query param loc
		var qrLoc string

		if o.Loc != nil {
			qrLoc = *o.Loc
		}
		qLoc := qrLoc
		if qLoc != "" {

			if err := r.SetQueryParam("loc", qLoc); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
