% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilbert.R
\name{dwt.hilbert}
\alias{dwt.hilbert}
\alias{dwt.hilbert.nondyadic}
\alias{idwt.hilbert}
\alias{modwt.hilbert}
\alias{imodwt.hilbert}
\alias{modwpt.hilbert}
\title{Discrete Hilbert Wavelet Transforms}
\usage{
dwt.hilbert(x, wf, n.levels = 4, boundary = "periodic", ...)

dwt.hilbert.nondyadic(x, ...)

idwt.hilbert(y)

modwt.hilbert(x, wf, n.levels = 4, boundary = "periodic", ...)

imodwt.hilbert(y)

modwpt.hilbert(x, wf, n.levels = 4, boundary = "periodic")
}
\arguments{
\item{x}{Real-valued time series or vector of observations.}

\item{wf}{Hilbert wavelet pair}

\item{n.levels}{Number of levels (depth) of the wavelet transform.}

\item{boundary}{Boundary treatment, currently only \code{periodic} and
\code{reflection}.}

\item{\ldots}{Additional parametes to be passed on.}

\item{y}{An object of S3 class \code{dwt.hilbert}.}
}
\value{
Hilbert wavelet transform object (list).
}
\description{
The discrete Hilbert wavelet transforms (DHWTs) for seasonal and
time-varying time series analysis.  Transforms include the usual orthogonal
(decimated), maximal-overlap (non-decimated) and maximal-overlap packet
transforms.
}
\references{
Selesnick, I. (200X). \emph{IEEE Signal Processing Magazine}

Selesnick, I. (200X). \emph{IEEE Transactions in Signal Processing}

Whither, B. and P.F. Craigmile (2004). Multivariate Spectral Analysis Using
Hilbert Wavelet Pairs, \emph{International Journal of Wavelets,
Multiresolution and Information Processing}, \bold{2}(4), 567--587.
}
\seealso{
\code{\link{hilbert.filter}}
}
\author{
B. Whitcher
}
\keyword{ts}
