% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_D.R
\name{dwpt.2d}
\alias{dwpt.2d}
\alias{idwpt.2d}
\title{(Inverse) Discrete Wavelet Packet Transforms in Two Dimensions}
\usage{
dwpt.2d(x, wf = "la8", J = 4, boundary = "periodic")

idwpt.2d(y, y.basis)
}
\arguments{
\item{x}{a matrix or image containing the data be to decomposed.  This
ojbect must be dyadic (power of 2) in length in each dimension.}

\item{wf}{Name of the wavelet filter to use in the decomposition.  By
default this is set to \code{"la8"}, the Daubechies orthonormal compactly
supported wavelet of length \eqn{L=8} (Daubechies, 1992), least asymmetric
family.}

\item{J}{Specifies the depth of the decomposition.  This must be a number
less than or equal to \eqn{\log(\mbox{length}(x),2)}.}

\item{boundary}{Character string specifying the boundary condition.  If
\code{boundary=="periodic"} the default, then the vector you decompose is
assumed to be periodic on its defined interval,\cr if
\code{boundary=="reflection"}, the vector beyond its boundaries is assumed
to be a symmetric reflection of itself.}

\item{y}{\code{dwpt.2d} object (list-based structure of matrices)}

\item{y.basis}{Boolean vector, the same length as \eqn{y}, where \code{TRUE}
means the basis tensor should be used in the reconstruction.}
}
\value{
Basically, a list with the following components
\item{w?.?-w?.?}{Wavelet coefficient matrices (images).  The first index is
associated with the scale of the decomposition while the second is
associated with the frequency partition within that level.  The left and
right strings, separated by the dash `-', correspond to the first \eqn{(x)}
and second \eqn{(y)} dimensions.} \item{wavelet}{Name of the wavelet filter
used.} \item{boundary}{How the boundaries were handled.}
}
\description{
All possible filtering combinations (low- and high-pass) are performed to
decompose a matrix or image.  The resulting coefficients are associated with
a quad-tree structure corresponding to a partitioning of the two-dimensional
frequency plane.
}
\details{
The code implements the two-dimensional DWPT using the pyramid algorithm of
Mallat (1989).
}
\references{
Mallat, S. G. (1989) A theory for multiresolution signal
decomposition: the wavelet representation, \emph{IEEE Transactions on
Pattern Analysis and Machine Intelligence}, \bold{11}, No. 7, 674-693.

Wickerhauser, M. V. (1994) \emph{Adapted Wavelet Analysis from Theory to
Software}, A K Peters.
}
\seealso{
\code{\link{dwt.2d}}, \code{\link{modwt.2d}},
\code{\link{wave.filter}}.
}
\author{
B. Whitcher
}
\keyword{ts}
