% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{auth_as}
\alias{auth_as}
\title{Set default authentication for the current session}
\usage{
auth_as(auth = NULL)
}
\arguments{
\item{auth}{One of the following options:
\itemize{
\item \code{NULL}, the default, will look for rtweet's "default" authentication
which uses your personal Twitter account. If it's not found, it will
call \code{\link[=auth_setup_default]{auth_setup_default()}} to set it up.
\item A string giving the name of a saved auth file made by \code{\link[=auth_save]{auth_save()}}.
\item An auth object created by \code{\link[=rtweet_app]{rtweet_app()}}, \code{\link[=rtweet_bot]{rtweet_bot()}}, or
\code{\link[=rtweet_user]{rtweet_user()}}.
}}
}
\value{
Invisibly returns the previous authentication mechanism.
}
\description{
\code{auth_as()} sets up the default authentication mechanism used by all
rtweet API calls. See \code{\link[=rtweet_user]{rtweet_user()}} to learn more about the three
available authentication options.
}
\examples{
\dontrun{
# Use app auth for the remainder of this session:
my_app <- rtweet_app()
auth_as(my_app)

# Switch back to the default user based auth
auth_as()

# Load auth saved by auth_save()
auth_as("my-saved-app")
}
}
\seealso{
\code{\link[=auth_sitrep]{auth_sitrep()}} to help finding and managing authentications.

Other authentication: 
\code{\link{auth_get}()},
\code{\link{auth_save}()},
\code{\link{auth_setup_default}()},
\code{\link{rtweet_user}()}
}
\concept{authentication}
