% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanotime.R, R/nanoduration.R
\docType{class}
\name{nanotime-class}
\alias{nanotime-class}
\alias{nanotime}
\alias{as.nanotime}
\alias{nanotime,character-method}
\alias{as.nanotime,character-method}
\alias{nanotime.matrix}
\alias{nanotime,POSIXct-method}
\alias{as.nanotime,POSIXct-method}
\alias{nanotime,POSIXlt-method}
\alias{as.nanotime,POSIXlt-method}
\alias{nanotime,Date-method}
\alias{as.nanotime,Date-method}
\alias{print,nanotime-method}
\alias{show,nanotime-method}
\alias{unique,nanotime-method}
\alias{format.nanotime}
\alias{index2char.nanotime}
\alias{as.POSIXct.nanotime}
\alias{as.POSIXlt.nanotime}
\alias{as.Date.nanotime}
\alias{as.data.frame.nanotime}
\alias{as.integer64.nanotime}
\alias{-,nanotime,character-method}
\alias{-,nanotime,nanotime-method}
\alias{-,nanotime,integer64-method}
\alias{-,nanotime,numeric-method}
\alias{-,ANY,nanotime-method}
\alias{-,nanotime,ANY-method}
\alias{+,nanotime,ANY-method}
\alias{+,nanotime,integer64-method}
\alias{+,nanotime,numeric-method}
\alias{+,ANY,nanotime-method}
\alias{+,integer64,nanotime-method}
\alias{+,numeric,nanotime-method}
\alias{+,nanotime,nanotime-method}
\alias{Arith,nanotime,nanotime-method}
\alias{Arith,nanotime,ANY-method}
\alias{Arith,ANY,nanotime-method}
\alias{Compare,nanotime,character-method}
\alias{Compare,character,nanotime-method}
\alias{Compare,nanotime,POSIXt-method}
\alias{Compare,POSIXt,nanotime-method}
\alias{Compare,nanotime,ANY-method}
\alias{Logic,nanotime,ANY-method}
\alias{Logic,ANY,nanotime-method}
\alias{Math,nanotime-method}
\alias{Math2,nanotime-method}
\alias{Summary,nanotime-method}
\alias{min,nanotime-method}
\alias{max,nanotime-method}
\alias{range,nanotime-method}
\alias{Complex,nanotime-method}
\alias{[[,nanotime-method}
\alias{[,nanotime,numeric-method}
\alias{[,nanotime,logical-method}
\alias{[,nanotime,character-method}
\alias{[,nanotime,ANY-method}
\alias{[<-,nanotime,ANY,ANY,ANY-method}
\alias{c.nanotime}
\alias{nanotime-package}
\alias{names<-,nanotime-method}
\alias{is.na,nanotime-method}
\alias{NA_nanotime_}
\alias{as.character.nanotime}
\alias{as.data.frame.nanoduration}
\title{Nanosecond resolution datetime functionality}
\format{
An object of class \code{nanotime} of length 1.
}
\usage{
nanotime(from, ...)

as.nanotime(from, ...)

\S4method{nanotime}{character}(from, format = "", tz = "")

\S4method{as.nanotime}{character}(from, format = "", tz = "")

nanotime.matrix(x)

\S4method{nanotime}{POSIXct}(from, accurate = TRUE)

\S4method{as.nanotime}{POSIXct}(from, accurate = TRUE)

\S4method{nanotime}{POSIXlt}(from)

\S4method{as.nanotime}{POSIXlt}(from)

\S4method{nanotime}{Date}(from)

\S4method{as.nanotime}{Date}(from)

\S4method{print}{nanotime}(x, format = "", tz = "", quote = FALSE, ...)

\S4method{show}{nanotime}(object)

\method{format}{nanotime}(x, format = "", tz = "", ...)

\method{index2char}{nanotime}(x, ...)

\method{as.POSIXct}{nanotime}(x, tz = "", ...)

\method{as.POSIXlt}{nanotime}(x, tz = "", ...)

\method{as.Date}{nanotime}(x, ...)

\method{as.data.frame}{nanotime}(x, ...)

\method{as.integer64}{nanotime}(x, ...)

\S4method{-}{nanotime,character}(e1, e2)

\S4method{-}{nanotime,nanotime}(e1, e2)

\S4method{-}{nanotime,integer64}(e1, e2)

\S4method{-}{nanotime,numeric}(e1, e2)

\S4method{-}{ANY,nanotime}(e1, e2)

\S4method{-}{nanotime,ANY}(e1, e2)

\S4method{+}{nanotime,ANY}(e1, e2)

\S4method{+}{nanotime,integer64}(e1, e2)

\S4method{+}{nanotime,numeric}(e1, e2)

\S4method{+}{ANY,nanotime}(e1, e2)

\S4method{+}{integer64,nanotime}(e1, e2)

\S4method{+}{numeric,nanotime}(e1, e2)

\S4method{+}{nanotime,nanotime}(e1, e2)

\S4method{Arith}{nanotime,nanotime}(e1, e2)

\S4method{Arith}{nanotime,ANY}(e1, e2)

\S4method{Arith}{ANY,nanotime}(e1, e2)

\S4method{Compare}{nanotime,character}(e1, e2)

\S4method{Compare}{character,nanotime}(e1, e2)

\S4method{Compare}{nanotime,POSIXt}(e1, e2)

\S4method{Compare}{POSIXt,nanotime}(e1, e2)

\S4method{Compare}{nanotime,ANY}(e1, e2)

\S4method{Logic}{nanotime,ANY}(e1, e2)

\S4method{Logic}{ANY,nanotime}(e1, e2)

\S4method{Math}{nanotime}(x)

\S4method{Math2}{nanotime}(x, digits)

\S4method{Summary}{nanotime}(x, ..., na.rm = FALSE)

\S4method{min}{nanotime}(x, ..., na.rm = FALSE)

\S4method{max}{nanotime}(x, ..., na.rm = FALSE)

\S4method{range}{nanotime}(x, ..., na.rm = FALSE)

\S4method{Complex}{nanotime}(z)

\S4method{[[}{nanotime}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanotime,numeric}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanotime,logical}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanotime,character}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanotime,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanotime,ANY,ANY,ANY}(x, i, j, ...) <- value

\method{c}{nanotime}(...)

\S4method{names}{nanotime}(x) <- value

\S4method{is.na}{nanotime}(x)

NA_nanotime_

\method{as.character}{nanotime}(x, ...)

\method{as.data.frame}{nanoduration}(x, ...)
}
\arguments{
\item{...}{further arguments passed to or from methods.}

\item{format}{A character string. Can also be set via
\code{options("nanotimeFormat")} and uses
\sQuote{\%Y-\%m-\%dT\%H:\%M:\%E9S\%Ez} as a default and
fallback}

\item{tz}{character specifying a timezone which is required for
\code{as.POSIXct}, \code{as.POSIXlt} and can be specified for
\code{as.nanotime}, \code{format} and \code{print}; it can
also be set via \code{options("nanotimeTz")} and uses
\sQuote{UTC} as a default and fallback}

\item{x, from}{\code{nanotime} objects}

\item{accurate}{in the conversion from \code{POSIXct} to
\code{nanotime}, indicates if one wants to preserve the
maximum precision possible; the default is \code{TRUE}, but in
most situations the loss of precision is negligible, and
setting this parameter to \code{TRUE} will make the conversion
nearly an order of magnitude faster}

\item{quote}{indicates if the output of \code{print} should be
quoted}

\item{object}{argument for method \code{show}}

\item{e1}{Operand of class \code{nanotime}}

\item{e2}{Operand of class \code{nanotime}}

\item{digits}{Required for \code{Math2} signature but ignored here}

\item{na.rm}{a logical indicating whether missing values should be
removed.}

\item{z}{Required for \code{Complex} signature but ignored here}

\item{i}{index specifying elements to extract or replace.}

\item{j}{Required for \code{[} signature but ignored here}

\item{drop}{Required for \code{[} signature but ignored here}

\item{value}{argument for \code{nanotime-class}}
}
\value{
A nanotime object
}
\description{
Functions to operate on nanosecond time resolution using integer64
bit representation. Conversion functions for several standard R
types are provided, and more will be added as needed.
}
\details{
Notice that the conversion from POSIXct explicitly sets the last
three digits to zero. Nanosecond time stored in a 64-bit integer
has nineteen digits precision where doubles (which are used
internally for POSIXct as well) only have sixteen digits.  So
rather than showing three more (essentially \emph{random}) digits
it is constructed such that these three additional digits are
zeros.
}
\section{Caveats}{


Working with dates and times is \emph{difficult}. One needs a
representation of both \emph{time points} and \emph{time
duration}. In R, think of \code{Date} or \code{POSIXct} objects
for the former, and \code{difftime} for the later. Here we have
time points \code{nanotime}, an interval type \code{nanoival} and
two flavors of duration which are a simple count of nanoseconds
\code{nanoduration} and a calendar duration that is able to track
concepts such as months and days \code{nanoperiod}. Point in time
and intervals are all based on durations relative to the epoch of
January 1, 1970.
}

\section{Input and Output Format}{


Formatting and character conversion for \code{nanotime} objects is
done by functions from the \pkg{RcppCCTZ} package relying
on code from its embedded \code{CCTZ} library. The default format
is ISO3339 compliant: \code{\%Y-\%m-\%dT\%H:\%M:\%E9S\%Ez}. It
specifies a standard ISO 8601 part for date and time --- as well
as nine digits of precision for fractional seconds (down to
nanoseconds) and on offset (typically zero as we default to UTC).
It can be overriden by using \code{options()} with the key of
\code{nanotimeFormat} and a suitable value. Similarly,
\code{nanotimeTz} can be used to select a different timezone.

For input, some slack it cut, and various shortened formats are
accepted by default such as \code{2020-03-10} or \code{2020-03-10
18:16:00}, or \code{2020-03-10 18:16:00.001} (and the \sQuote{T}
separator is optional.
}

\section{\code{tz} parameter usage in constructors}{


The \code{tz} parameter is allowed only when constructing a
\code{nanotime} from a \code{character}. This is because any
\code{numeric}, \code{Date} and \code{POSIXct} is de facto
considered an offset since the epoch. On the contrary, a
\code{character} is considered interpretable and hence if it does
not contain a timezone in its representation, it is possible to
specify the \code{tz} argument to specify in which timezone it
should be interpreted. This is useful in particular if one wants
to convert a \code{Date} to be aligned to the beginning of the day
in a specific timezone; in this case one should convert the
\code{Date} to a \code{character} before calling the
\code{nanotime} constructor with the desired timezone.
}

\examples{
\dontrun{
x <- nanotime(1)
print(x)
as.nanotime("1970-01-01T00:00:00.000000001+00:00")
as.nanotime("2020-03-10 Europe/Berlin")
as.nanotime("2020-03-10 18:31:23.001", tz="America/New_York")
as.nanotime("2020-03-10T040947190301440", format="\%Y-\%m-\%dT\%H\%M\%S\%E*f")
x <- x + 1
print(x)
format(x)
x <- x + 10
print(x)
format(x)
nanotime(Sys.time()) + 1:3  # three elements each 1 ns apart
seq(x, by=as.nanoperiod("1d"), length.out=5, tz="Asia/Tokyo")
}
}
\seealso{
\code{\link{nanoival}}, \code{\link{nanoduration}},
\code{\link{nanoperiod}}, \code{\link{seq.nanotime}} as well as
the documentation in package \pkg{RcppCCTZ}.
}
\author{
Dirk Eddelbuettel

Leonardo Silvestri
}
\keyword{datasets}
