\name{seq2aln}
\alias{seq2aln}
\title{ Add a Sequence to an Existing Alignmnet }
\description{
  Add one or more sequences to an existing multiple alignment that you
  wish to keep intact.
}
\usage{
seq2aln(seq2add, aln, id = "seq", file = "aln.fa", \dots)
}
\arguments{
  \item{seq2add}{ an sequence character vector or an alignment list
    object with \code{id} and \code{ali} components, similar to that
    generated by \code{\link{read.fasta}} and \code{\link{seqaln}}. }
  \item{aln}{ an alignment list object with \code{id} and \code{ali}
    components, similar to that generated by \code{\link{read.fasta}}
    and \code{\link{seqaln}}. }
  \item{id}{ a vector of sequence names to serve as sequence
    identifers. }
  \item{file}{ name of \sQuote{FASTA} output file to which alignment
    should be written. }
  \item{\dots}{ additional arguments passed to \code{\link{seqaln}}. }
}
\details{
  This function calls the \sQuote{MUSCLE} program, to perform a profile
  profile alignment, which MUST BE INSTALLED on your system and in the
  search path for executables.
}
\value{
  A list with two components:
  \item{ali}{ an alignment character matrix with a row per sequence and
    a column per equivalent aminoacid/nucleotide. }
  \item{id}{ sequence names as identifers.}
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
  
  \sQuote{MUSCLE} is the work of Edgar:
  Edgar (2004) \emph{Nuc. Acid. Res.} \bold{32}, 1792--1797.
  
  Full details of the \sQuote{MUSCLE} algorithm, along with download and
  installation instructions can be obtained from:\cr
  \url{http://www.drive5.com/muscle/}.
}
\author{ Barry Grant }
\note{
  A system call is made to the \sQuote{MUSCLE} program, which must be
  installed on your system and in the search path for executables.
}
\seealso{ \code{\link{seqaln}}, \code{\link{read.fasta}},
  \code{\link{read.fasta.pdb}}, \code{\link{seqbind}}
}
\examples{

\dontrun{
aa.1 <- pdbseq( read.pdb("1bg2") )
aa.2 <- pdbseq( read.pdb("3dc4") )
aa.3 <- pdbseq( read.pdb("1mkj") )

aln <- seqaln( seqbind(aa.1,aa.2) )

seq2aln(aa.3, aln)
}

}
\keyword{ utilities }
