# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class NatGatewayLanProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'gateway_ips': 'list[str]',

        'id': 'int',
    }

    attribute_map = {

        'gateway_ips': 'gatewayIps',

        'id': 'id',
    }

    def __init__(self, gateway_ips=None, id=None, local_vars_configuration=None):  # noqa: E501
        """NatGatewayLanProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._gateway_ips = None
        self._id = None
        self.discriminator = None

        if gateway_ips is not None:
            self.gateway_ips = gateway_ips
        self.id = id


    @property
    def gateway_ips(self):
        """Gets the gateway_ips of this NatGatewayLanProperties.  # noqa: E501

        Collection of gateway IP addresses of the NAT Gateway. Will be auto-generated if not provided. Should ideally be an IP belonging to the same subnet as the LAN  # noqa: E501

        :return: The gateway_ips of this NatGatewayLanProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._gateway_ips

    @gateway_ips.setter
    def gateway_ips(self, gateway_ips):
        """Sets the gateway_ips of this NatGatewayLanProperties.

        Collection of gateway IP addresses of the NAT Gateway. Will be auto-generated if not provided. Should ideally be an IP belonging to the same subnet as the LAN  # noqa: E501

        :param gateway_ips: The gateway_ips of this NatGatewayLanProperties.  # noqa: E501
        :type gateway_ips: list[str]
        """

        self._gateway_ips = gateway_ips

    @property
    def id(self):
        """Gets the id of this NatGatewayLanProperties.  # noqa: E501

        Id for the LAN connected to the NAT Gateway  # noqa: E501

        :return: The id of this NatGatewayLanProperties.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NatGatewayLanProperties.

        Id for the LAN connected to the NAT Gateway  # noqa: E501

        :param id: The id of this NatGatewayLanProperties.  # noqa: E501
        :type id: int
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NatGatewayLanProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NatGatewayLanProperties):
            return True

        return self.to_dict() != other.to_dict()
