%define PERSALYS_Analysis_doc
"Analysis base class."
%enddef
%feature("docstring") PERSALYS::AnalysisImplementation
PERSALYS_Analysis_doc

// ---------------------------------------------------------------------

%define PERSALYS_Analysis_getErrorMessage_doc
"Error message accessor.

Returns
-------
message : str
    Error message if the analysis failed"
%enddef
%feature("docstring") PERSALYS::AnalysisImplementation::getErrorMessage
PERSALYS_Analysis_getErrorMessage_doc

// ---------------------------------------------------------------------

%define PERSALYS_Analysis_getWarningMessage_doc
"Warning message accessor.

Returns
-------
message : str
    Warning message which can appear during the analysis computation"
%enddef
%feature("docstring") PERSALYS::AnalysisImplementation::getWarningMessage
PERSALYS_Analysis_getWarningMessage_doc

// ---------------------------------------------------------------------

%define PERSALYS_Analysis_getPythonScript_doc
"Physical model accessor.

Returns
-------
script : str
    Python script to replay the analysis"
%enddef
%feature("docstring") PERSALYS::AnalysisImplementation::getPythonScript
PERSALYS_Analysis_getPythonScript_doc

// ---------------------------------------------------------------------

%define PERSALYS_Analysis_isReliabilityAnalysis_doc
"Whether the analysis involves reliability.

Returns
-------
isReliabilityAnalysis : bool
    Whether the analysis involves a reliability analysis"
%enddef
%feature("docstring") PERSALYS::AnalysisImplementation::isReliabilityAnalysis
PERSALYS_Analysis_isReliabilityAnalysis_doc

// ---------------------------------------------------------------------

%define PERSALYS_Analysis_isRunning_doc
"Whether the analysis is running.

Returns
-------
isRunning : bool
    Whether the analysis is running"
%enddef
%feature("docstring") PERSALYS::AnalysisImplementation::isRunning
PERSALYS_Analysis_isRunning_doc

// ---------------------------------------------------------------------

%define PERSALYS_Analysis_run_doc
"Launch the analysis."
%enddef
%feature("docstring") PERSALYS::AnalysisImplementation::run
PERSALYS_Analysis_run_doc

// ---------------------------------------------------------------------

%define PERSALYS_Analysis_hasValidResult_doc
"Whether the analysis has been run.

Returns
-------
hasValidResult : bool
    Whether the analysis has already been run"
%enddef
%feature("docstring") PERSALYS::AnalysisImplementation::hasValidResult
PERSALYS_Analysis_hasValidResult_doc

// ---------------------------------------------------------------------

%define PERSALYS_Analysis_getInterestVariables_doc
"Get the variables to analyse.

Returns
-------
variablesNames : sequence of str
    Names of the variables to analyse"
%enddef
%feature("docstring") PERSALYS::AnalysisImplementation::getInterestVariables
PERSALYS_Analysis_getInterestVariables_doc

// ---------------------------------------------------------------------

%define PERSALYS_Analysis_setInterestVariables_doc
"Set the variables to analyse.

Parameters
----------
variablesNames : sequence of str
    Names of the variables to analyse"
%enddef
%feature("docstring") PERSALYS::AnalysisImplementation::setInterestVariables
PERSALYS_Analysis_setInterestVariables_doc
