# 11/19/2020

### Attending:

* Cary Phillips
* Christina Tempelaar-Lietz
* Joseph Goldstone
* Kimball Thurston
* Larry Gritz
* Nick Porcino
* Owen Thompson
* Peter Hillman

### Discussion:

* Imath PR #66: Use likely/unlikely to improve certain vector
  ops.

  * This applies the builtin_expect to if statements to assist with
    optimization. This is the result of engineers at Intel going over
    things with a fine-tooth comb.

  * The general rule is that the directive is appropriate when you’re
    detecting an error that is truly exceptional.

  * Does MSVC have the same feature? Maybe, someone should check. But
    at least now all we have to do is extend the macro.

  * #66 also includes a change to a line to invoke std::abs(),
    technically shouldn't go in the same PR, but fine as is.

* Imath #65 Deprecate Math<T> in favor of std:: 

  * In the name of portability, std:: is better.

  * Kimball: There are some cases where I didn’t want to call the std
    version because it does extra error checking. But you can tell the
    compiler to use the unsafe function

  * Should we get rid of the Math<T> class entirely? This PR removes all uses of the class but leaves it in the code.

  * Nick: Every line that goes is less debt.

  * Kimball: IlmThread in OpenEXR has the deprecation stiff, for mutex and lock.

  * Larry will port that over to this class.

* #60 Make Matrix implementation more SIMD friendly 

  * Unrolled assignments are faster than memset/memcpy.

  * These came about by an attempt to autofectorize the code.

  * Also included: a fix to Matrix33::setScale(), which attempted to
    mimic Matrix44::setScale() by not affecting the final row, which
    for M44 is the translation. But that doesn't ake sense for a 3x3
    matrix. Nick wrote the original code at ILM years ago, an
    abandoned effort. All agree to regard the current behavior as a
    bug and fix it to conform to the most logical behavior and affect
    all rows.

* Imath #59 Hide Vec and Matrix exceptions from Cuda

  * This PR #ifdef's out the throw calls under CUDA.

  * Would it be better to #ifdef out the entire function?

  * Or alternatively, remove the HOST_DEVICE decorator, which will
    prevent them from bei ng compiled under CUDA altogether.

  * Nick: A little churn in CUDA code doesn’t set off alarm bells,
    it’s expected to be a bit volitile, so this shouldn't cause a
    problem.

  * One gotcha: M44::inverse(bool singExc) if invoked explicitly via
    inverse(false). But the argument-less version is available.
  
# Imath PR #58 Make separate test calls for each test

  * Not sure why the CLA test failed. Cary will fix it and merge.

* openexr PR #865: Add a conditional to prevent analysis on forks 

  * Larry: GitHub says they’re disabling actions on all forks, which
    should address this.

  * Kimball: this was the suggested fix, although it wasn't the most
    thorough of investigations.

* openexr PR #862 E2K: added initial support of MCST Elbrus 2000 CPU architecture 

  * Elbrus 2000 is a Russian supercomputer. It has all the same
    registers, but not the same assembly syntax.
  
  * Nick: I was hoping that the directives could be specified at cmake
    time. The code in question is a part of highly nested bits at
    compile-time. Can those pathways be selected at cmake time?  I
    couldn’t tell.

  * It’s only used in the test of the DWA compressor.

  * It's minimal extra debt, so fine to accept, subject to the CLA.

* Larry: We haven’t yet marked things as noexcept.

  * Ideally, we do it across the board everywhere that's
    applicable. Comprehensive.

  * Certainly, in the cases of dual functions, it helps with
    documentation.

  * The compiler ought to be able to tell you if a function throws,
    but it doesn't.
  
  * In C++21(?) noexcept becomes a part of the name of the function,
    so it would be an ABI break.

  * Larry will pick something and do it, then that can be used as an
    example.

* Larry: OIIO builds and supports OpenEXR back to version 2.x.

  * Every downstream project is going to need to change. At source and build.

  * Nick: USD ws doing detection on OpenEXR version, to fix dependency
    on OIIO.

  * Larry will write up a short guide for how downstream projects will
    need to adjust to 3.0
  