# Vazirmatn Font Builder

The script tool for building files for [vazirmatn](https://github.com/rastikerdar/vazirmatn). By default this tool clones the repository of Roboto-Classic Variable font into the folder `latin` and then merge it into Vazirmatn. However, You can use the `--no-latin` option to skip this step.

## Requirements

- fontforge https://fontforge.org/
- python3
- python3-fontforge
- fontmake https://github.com/googlefonts/fontmake
- fonttools (pyftsubset) https://github.com/fonttools/fonttools
- gftools
- git (access to fetch Roboto Variable repository https://github.com/googlefonts/Roboto-Classic)
- sed
- zip

## How it works

Make sure you have installed all the requirements. For Debian distro you can use this command:

```
$ sudo apt install fontforge python3-fontforge fontmake fonttools gftools zip sed git
```

Next:

```
$ git clone https://github.com/rastikerdar/vazirmatn.git
$ cd vazirmatn/
$ make all
```

`make all` means in order:

```
make fonts
make rd-fonts
make zip
```

You can use command `bash scripts/make-fonts.sh` to customize the build process.
Options for `make-fonts.sh`:

```
--repo-dir=    # default is current directory
--temp-dir=     # default is "/tmp/vazirmatn-font-output-temp"
--output-dir=  # default is current directory
--rd-font
--only-ttf
--no-misc
--no-latin
--no-hinting
--no-temp-clean
--no-variable
--no-css
```

Tip: I usually use an in-Ram location for `--temp-dir=` option.

During the development I usually use this command from the root of the repository:

```
$ ./scripts/make-fonts.sh --temp-dir="/ramdisk/tmp/" --output-dir="path/to/test_folder/" --no-latin --no-misc --no-hinting --only-ttf --no-css --no-temp-clean
```

By using the option `--repo-dir` the script can be run from anywhere. If you only want to see the main report messages generated by the script itself, append `2> /dev/null` to the end of your command. Note that this will prevent errors from being displayed.

### Notes

- Maybe it is better to convert all these scripts into a unified Python script (module) to make the build process platform-independent. 

- The build process depends on `fontforge` and `python3-fontforge` which are not in PyPI. Because of this we cannot run all scripts in a Python virtual environment (venv).

License: MIT
