#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stellaris expansions (story packs):
# - Leviathans
# - Synthetic Dawn
# - Distant Stars
# - Ancient Relics
# - First Contact
# - Grand Archive
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251120.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='stellaris'
GAME_NAME='Stellaris'

EXPANSION_ID_LEVIATHANS='leviathans'
EXPANSION_NAME_LEVIATHANS='Leviathans Story Pack'

EXPANSION_ID_DAWN='synthetic-dawn'
EXPANSION_NAME_DAWN='Synthetic Dawn Story Pack'

EXPANSION_ID_STARS='distant-stars'
EXPANSION_NAME_STARS='Distant Stars Story Pack'

EXPANSION_ID_RELICS='ancient-relics'
EXPANSION_NAME_RELICS='Ancient Relics Story Pack'

EXPANSION_ID_CONTACT='first-contact'
EXPANSION_NAME_CONTACT='First Contact Story Pack'

EXPANSION_ID_ARCHIVE='grand-archive'
EXPANSION_NAME_ARCHIVE='Grand Archive Story Pack'

## Leviathans

ARCHIVE_BASE_LEVIATHANS_63_NAME='stellaris_leviathans_story_pack_4_1_7_86266.sh'
ARCHIVE_BASE_LEVIATHANS_63_MD5='d5ded91911ba0894b5b901be43181de8'
ARCHIVE_BASE_LEVIATHANS_63_SIZE='58426'
ARCHIVE_BASE_LEVIATHANS_63_VERSION='4.1.7-gog86266'
ARCHIVE_BASE_LEVIATHANS_63_URL='https://www.gog.com/game/stellaris_leviathans_story_pack'

ARCHIVE_BASE_LEVIATHANS_62_NAME='stellaris_leviathans_story_pack_4_0_23_84679.sh'
ARCHIVE_BASE_LEVIATHANS_62_MD5='f715aa00eb279dcdfe9124ac6312dce1'
ARCHIVE_BASE_LEVIATHANS_62_SIZE='58426'
ARCHIVE_BASE_LEVIATHANS_62_VERSION='4.0.23-gog84679'

ARCHIVE_BASE_LEVIATHANS_61_NAME='stellaris_leviathans_story_pack_3_14_1592653_81105.sh'
ARCHIVE_BASE_LEVIATHANS_61_MD5='9c18773594ff2456258e6b6716311b20'
ARCHIVE_BASE_LEVIATHANS_61_SIZE='58426'
ARCHIVE_BASE_LEVIATHANS_61_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_LEVIATHANS_59_NAME='stellaris_leviathans_story_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_LEVIATHANS_59_MD5='07773ecc28478515fc25fd000941fd38'
ARCHIVE_BASE_LEVIATHANS_59_SIZE='58426'
ARCHIVE_BASE_LEVIATHANS_59_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_LEVIATHANS_56_NAME='stellaris_leviathans_story_pack_3_12_5_74193.sh'
ARCHIVE_BASE_LEVIATHANS_56_MD5='8ab8f647d2405c443ee699b1ec3e17b4'
ARCHIVE_BASE_LEVIATHANS_56_SIZE='58426'
ARCHIVE_BASE_LEVIATHANS_56_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_LEVIATHANS_52_NAME='stellaris_leviathans_story_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_LEVIATHANS_52_MD5='bbdede0f81d260b3225f671518d6f135'
ARCHIVE_BASE_LEVIATHANS_52_SIZE='58426'
ARCHIVE_BASE_LEVIATHANS_52_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_LEVIATHANS_49_NAME='stellaris_leviathans_story_pack_3_10_4_70670.sh'
ARCHIVE_BASE_LEVIATHANS_49_MD5='ca7bd55fd1121dff315cf4bdc748ce5c'
ARCHIVE_BASE_LEVIATHANS_49_SIZE='58426'
ARCHIVE_BASE_LEVIATHANS_49_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_LEVIATHANS_43_NAME='stellaris_leviathans_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_LEVIATHANS_43_MD5='12ed6b4e72c61d7d5a2223acfe3dec45'
ARCHIVE_BASE_LEVIATHANS_43_SIZE='58744'
ARCHIVE_BASE_LEVIATHANS_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_LEVIATHANS_40_NAME='stellaris_leviathans_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_LEVIATHANS_40_MD5='575490fe9da72c0211e65e42e2667544'
ARCHIVE_BASE_LEVIATHANS_40_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_LEVIATHANS_36_NAME='stellaris_leviathans_story_pack_3_7_4_63489.sh'
ARCHIVE_BASE_LEVIATHANS_36_MD5='e9bc3c4a49159663d905892a0f7f5a75'
ARCHIVE_BASE_LEVIATHANS_36_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_LEVIATHANS_33_NAME='stellaris_leviathans_story_pack_3_6_1_60754.sh'
ARCHIVE_BASE_LEVIATHANS_33_MD5='9ef91ba3bb1633cf4cb907f5de892817'
ARCHIVE_BASE_LEVIATHANS_33_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_LEVIATHANS_31_NAME='stellaris_leviathans_story_pack_3_5_3_59410.sh'
ARCHIVE_BASE_LEVIATHANS_31_MD5='46f80e45435155c5c94aa1f3bbabf797'
ARCHIVE_BASE_LEVIATHANS_31_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_LEVIATHANS_29_NAME='stellaris_leviathans_story_pack_3_4_5_56913.sh'
ARCHIVE_BASE_LEVIATHANS_29_MD5='514ca47c97e6edf951697ba361df53bd'
ARCHIVE_BASE_LEVIATHANS_29_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_LEVIATHANS_25_NAME='stellaris_leviathans_story_pack_3_3_4_54421.sh'
ARCHIVE_BASE_LEVIATHANS_25_MD5='367a1abfe37c32461302cf84c9bdd551'
ARCHIVE_BASE_LEVIATHANS_25_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_LEVIATHANS_21_NAME='stellaris_leviathans_story_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_LEVIATHANS_21_MD5='33a7db46efae680eb6718ccd6c386e53'
ARCHIVE_BASE_LEVIATHANS_21_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_LEVIATHANS_20_NAME='stellaris_leviathans_story_pack_3_1_1_50008.sh'
ARCHIVE_BASE_LEVIATHANS_20_MD5='162521d883f491fcb4e397b9a60c46fd'
ARCHIVE_BASE_LEVIATHANS_20_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_LEVIATHANS_19_NAME='stellaris_leviathans_story_pack_3_0_3_47193.sh'
ARCHIVE_BASE_LEVIATHANS_19_MD5='70f70d4656a3b3069bec4b138b1c27d5'
ARCHIVE_BASE_LEVIATHANS_19_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_19_VERSION='3.0.3-gog47193'

## Synthetic Dawn

ARCHIVE_BASE_DAWN_62_NAME='stellaris_synthetic_dawn_story_pack_4_1_7_86266.sh'
ARCHIVE_BASE_DAWN_62_MD5='611270eb8c53629460682cdf7c4741a2'
ARCHIVE_BASE_DAWN_62_SIZE='48245'
ARCHIVE_BASE_DAWN_62_VERSION='4.1.7-gog86266'
ARCHIVE_BASE_DAWN_62_URL='https://www.gog.com/game/stellaris_synthetic_dawn_story_pack'

ARCHIVE_BASE_DAWN_61_NAME='stellaris_synthetic_dawn_story_pack_4_0_23_84679.sh'
ARCHIVE_BASE_DAWN_61_MD5='5aa0d16a6e0e0a0f022fa4b9e820150f'
ARCHIVE_BASE_DAWN_61_SIZE='48245'
ARCHIVE_BASE_DAWN_61_VERSION='4.0.23-gog84679'

ARCHIVE_BASE_DAWN_60_NAME='stellaris_synthetic_dawn_story_pack_3_14_1592653_81105.sh'
ARCHIVE_BASE_DAWN_60_MD5='8da0b258eb5e670ecc758dc938e97878'
ARCHIVE_BASE_DAWN_60_SIZE='48245'
ARCHIVE_BASE_DAWN_60_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_DAWN_58_NAME='stellaris_synthetic_dawn_story_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_DAWN_58_MD5='2d9bc46f1afe830229ac56b7800a1aba'
ARCHIVE_BASE_DAWN_58_SIZE='48245'
ARCHIVE_BASE_DAWN_58_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_DAWN_55_NAME='stellaris_synthetic_dawn_story_pack_3_12_5_74193.sh'
ARCHIVE_BASE_DAWN_55_MD5='28f5282f2422cce01ca868a906eb499c'
ARCHIVE_BASE_DAWN_55_SIZE='48244'
ARCHIVE_BASE_DAWN_55_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_DAWN_51_NAME='stellaris_synthetic_dawn_story_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_DAWN_51_MD5='dacbf32f6358906934c4168ad06fff0d'
ARCHIVE_BASE_DAWN_51_SIZE='48244'
ARCHIVE_BASE_DAWN_51_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_DAWN_48_NAME='stellaris_synthetic_dawn_story_pack_3_10_4_70670.sh'
ARCHIVE_BASE_DAWN_48_MD5='4b16f920acc6b2257386f020192aafce'
ARCHIVE_BASE_DAWN_48_SIZE='48244'
ARCHIVE_BASE_DAWN_48_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_DAWN_42_NAME='stellaris_synthetic_dawn_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_DAWN_42_MD5='b2f35b4c887634e98fbce5e737dd78d1'
ARCHIVE_BASE_DAWN_42_SIZE='48564'
ARCHIVE_BASE_DAWN_42_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_DAWN_39_NAME='stellaris_synthetic_dawn_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_DAWN_39_MD5='8752ebda6f3ff2a6f1f3ae38ee50e3e8'
ARCHIVE_BASE_DAWN_39_SIZE='49000'
ARCHIVE_BASE_DAWN_39_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_DAWN_35_NAME='stellaris_synthetic_dawn_story_pack_3_7_4_63489.sh'
ARCHIVE_BASE_DAWN_35_MD5='09458636f871c76f7e22cc468a7a9f41'
ARCHIVE_BASE_DAWN_35_SIZE='49000'
ARCHIVE_BASE_DAWN_35_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_DAWN_32_NAME='stellaris_synthetic_dawn_story_pack_3_6_1_60754.sh'
ARCHIVE_BASE_DAWN_32_MD5='1e203e5c19fe5c63400cf566fea62164'
ARCHIVE_BASE_DAWN_32_SIZE='49000'
ARCHIVE_BASE_DAWN_32_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_DAWN_30_NAME='stellaris_synthetic_dawn_story_pack_3_5_3_59410.sh'
ARCHIVE_BASE_DAWN_30_MD5='8f6b7a85ca65572e15f61d724ea99317'
ARCHIVE_BASE_DAWN_30_SIZE='49000'
ARCHIVE_BASE_DAWN_30_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_DAWN_28_NAME='stellaris_synthetic_dawn_story_pack_3_4_5_56913.sh'
ARCHIVE_BASE_DAWN_28_MD5='cbcd2a2c6d1b088b634842b9d4abb941'
ARCHIVE_BASE_DAWN_28_SIZE='49000'
ARCHIVE_BASE_DAWN_28_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_DAWN_24_NAME='stellaris_synthetic_dawn_story_pack_3_3_4_54421.sh'
ARCHIVE_BASE_DAWN_24_MD5='b89665cf745898060051099d606a889d'
ARCHIVE_BASE_DAWN_24_SIZE='49000'
ARCHIVE_BASE_DAWN_24_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_DAWN_20_NAME='stellaris_synthetic_dawn_story_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_DAWN_20_MD5='9b00445bf6b381832f6de06e2f5b7827'
ARCHIVE_BASE_DAWN_20_SIZE='49000'
ARCHIVE_BASE_DAWN_20_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_DAWN_19_NAME='stellaris_synthetic_dawn_story_pack_3_1_1_50008.sh'
ARCHIVE_BASE_DAWN_19_MD5='69ba65596bc537841adc7c70ff0778a9'
ARCHIVE_BASE_DAWN_19_SIZE='49000'
ARCHIVE_BASE_DAWN_19_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_DAWN_18_NAME='stellaris_synthetic_dawn_story_pack_3_0_3_47193.sh'
ARCHIVE_BASE_DAWN_18_MD5='b4231ca3b95b4bdb9e9a2e33c747d8c5'
ARCHIVE_BASE_DAWN_18_SIZE='49000'
ARCHIVE_BASE_DAWN_18_VERSION='3.0.3-gog47193'

## Distant Stars

ARCHIVE_BASE_STARS_62_NAME='stellaris_distant_stars_story_pack_4_1_7_86266.sh'
ARCHIVE_BASE_STARS_62_MD5='385958d8febeed27983d44b7f9818d82'
ARCHIVE_BASE_STARS_62_SIZE='20832'
ARCHIVE_BASE_STARS_62_VERSION='4.1.7-gog86266'
ARCHIVE_BASE_STARS_62_URL='https://www.gog.com/game/stellaris_distant_stars_story_pack'

ARCHIVE_BASE_STARS_61_NAME='stellaris_distant_stars_story_pack_4_0_23_84679.sh'
ARCHIVE_BASE_STARS_61_MD5='1bc7353d68bdf3590f2e709956ed088d'
ARCHIVE_BASE_STARS_61_SIZE='20832'
ARCHIVE_BASE_STARS_61_VERSION='4.0.23-gog84679'

ARCHIVE_BASE_STARS_60_NAME='stellaris_distant_stars_story_pack_3_14_1592653_81105.sh'
ARCHIVE_BASE_STARS_60_MD5='eb6a9ad65dd727662706598256581265'
ARCHIVE_BASE_STARS_60_SIZE='20832'
ARCHIVE_BASE_STARS_60_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_STARS_58_NAME='stellaris_distant_stars_story_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_STARS_58_MD5='ee7f70b07d50956b05d0eb64ae752222'
ARCHIVE_BASE_STARS_58_SIZE='20832'
ARCHIVE_BASE_STARS_58_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_STARS_55_NAME='stellaris_distant_stars_story_pack_3_12_5_74193.sh'
ARCHIVE_BASE_STARS_55_MD5='be7d046f1e0165f607e0d19cf28eddc9'
ARCHIVE_BASE_STARS_55_SIZE='20832'
ARCHIVE_BASE_STARS_55_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_STARS_51_NAME='stellaris_distant_stars_story_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_STARS_51_MD5='1c05d748caac4118b22b1e7524936427'
ARCHIVE_BASE_STARS_51_SIZE='20832'
ARCHIVE_BASE_STARS_51_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_STARS_48_NAME='stellaris_distant_stars_story_pack_3_10_4_70670.sh'
ARCHIVE_BASE_STARS_48_MD5='35b7b4c4e536fdefae1668c74e3932cc'
ARCHIVE_BASE_STARS_48_SIZE='20832'
ARCHIVE_BASE_STARS_48_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_STARS_42_NAME='stellaris_distant_stars_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_STARS_42_MD5='9a03b641cc29f77008530d21e64f5232'
ARCHIVE_BASE_STARS_42_SIZE='21148'
ARCHIVE_BASE_STARS_42_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_STARS_39_NAME='stellaris_distant_stars_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_STARS_39_MD5='dcbb606208a16bc8f5f413239bfe69a4'
ARCHIVE_BASE_STARS_39_SIZE='22000'
ARCHIVE_BASE_STARS_39_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_STARS_35_NAME='stellaris_distant_stars_story_pack_3_7_4_63489.sh'
ARCHIVE_BASE_STARS_35_MD5='d2989715cc656a73c1e2ca922bba10aa'
ARCHIVE_BASE_STARS_35_SIZE='22000'
ARCHIVE_BASE_STARS_35_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_STARS_32_NAME='stellaris_distant_stars_story_pack_3_6_1_60754.sh'
ARCHIVE_BASE_STARS_32_MD5='1581145f5d4f4dbb491f3d3e1624577d'
ARCHIVE_BASE_STARS_32_SIZE='22000'
ARCHIVE_BASE_STARS_32_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_STARS_30_NAME='stellaris_distant_stars_story_pack_3_5_3_59410.sh'
ARCHIVE_BASE_STARS_30_MD5='5ca6cc0d7554484af76e491211d75233'
ARCHIVE_BASE_STARS_30_SIZE='22000'
ARCHIVE_BASE_STARS_30_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_STARS_28_NAME='stellaris_distant_stars_story_pack_3_4_5_56913.sh'
ARCHIVE_BASE_STARS_28_MD5='b2e6d53683346c48d44a058abd18eff9'
ARCHIVE_BASE_STARS_28_SIZE='22000'
ARCHIVE_BASE_STARS_28_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_STARS_24_NAME='stellaris_distant_stars_story_pack_3_3_4_54421.sh'
ARCHIVE_BASE_STARS_24_MD5='1ca0abfacce33943685ad442ebf9d81a'
ARCHIVE_BASE_STARS_24_SIZE='22000'
ARCHIVE_BASE_STARS_24_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_STARS_20_NAME='stellaris_distant_stars_story_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_STARS_20_MD5='a24264507765c470fa5d579b02fc8e32'
ARCHIVE_BASE_STARS_20_SIZE='22000'
ARCHIVE_BASE_STARS_20_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_STARS_19_NAME='stellaris_distant_stars_story_pack_3_1_1_50008.sh'
ARCHIVE_BASE_STARS_19_MD5='31eeae1be998363fec20a8a09affd7b4'
ARCHIVE_BASE_STARS_19_SIZE='22000'
ARCHIVE_BASE_STARS_19_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_STARS_18_NAME='stellaris_distant_stars_story_pack_3_0_3_47193.sh'
ARCHIVE_BASE_STARS_18_MD5='a19db33750977b3334a553f8c4259bf4'
ARCHIVE_BASE_STARS_18_SIZE='22000'
ARCHIVE_BASE_STARS_18_VERSION='3.0.3-gog47193'

## Ancient Relics

ARCHIVE_BASE_RELICS_51_NAME='stellaris_ancient_relics_4_1_7_86266.sh'
ARCHIVE_BASE_RELICS_51_MD5='28340a7bb369c1ff13f17d6eb92684ea'
ARCHIVE_BASE_RELICS_51_SIZE='32739'
ARCHIVE_BASE_RELICS_51_VERSION='4.1.7-gog86266'
ARCHIVE_BASE_RELICS_51_URL='https://www.gog.com/game/stellaris_ancient_relics_story_pack'

ARCHIVE_BASE_RELICS_50_NAME='stellaris_ancient_relics_4_0_23_84679.sh'
ARCHIVE_BASE_RELICS_50_MD5='164757e6b58f2f1ad756d173be445e42'
ARCHIVE_BASE_RELICS_50_SIZE='32739'
ARCHIVE_BASE_RELICS_50_VERSION='4.0.23-gog84679'

ARCHIVE_BASE_RELICS_49_NAME='stellaris_ancient_relics_3_14_1592653_81105.sh'
ARCHIVE_BASE_RELICS_49_MD5='2ee7c8d5cb9e6d14af6ea68e269960e6'
ARCHIVE_BASE_RELICS_49_SIZE='32739'
ARCHIVE_BASE_RELICS_49_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_RELICS_47_NAME='stellaris_ancient_relics_3_13_2_0_76713.sh'
ARCHIVE_BASE_RELICS_47_MD5='a5154d3b51af853b0c45eeb0685a7f7d'
ARCHIVE_BASE_RELICS_47_SIZE='32739'
ARCHIVE_BASE_RELICS_47_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_RELICS_44_NAME='stellaris_ancient_relics_3_12_5_74193.sh'
ARCHIVE_BASE_RELICS_44_MD5='35a896e2d8a9044a15898e9f55a39d47'
ARCHIVE_BASE_RELICS_44_SIZE='32739'
ARCHIVE_BASE_RELICS_44_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_RELICS_40_NAME='stellaris_ancient_relics_3_11_3_0_72561.sh'
ARCHIVE_BASE_RELICS_40_MD5='a1468916582d7e7ad9c73ad58d2a37ec'
ARCHIVE_BASE_RELICS_40_SIZE='32739'
ARCHIVE_BASE_RELICS_40_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_RELICS_37_NAME='stellaris_ancient_relics_3_10_4_70670.sh'
ARCHIVE_BASE_RELICS_37_MD5='dacebe45d724aa535d28dc73fd2b78ab'
ARCHIVE_BASE_RELICS_37_SIZE='32739'
ARCHIVE_BASE_RELICS_37_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_RELICS_31_NAME='stellaris_ancient_relics_3_9_3_68314.sh'
ARCHIVE_BASE_RELICS_31_MD5='19909812633ca0d83ad774683f60451f'
ARCHIVE_BASE_RELICS_31_SIZE='33060'
ARCHIVE_BASE_RELICS_31_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_RELICS_28_NAME='stellaris_ancient_relics_3_8_4_1_65337.sh'
ARCHIVE_BASE_RELICS_28_MD5='491929cb272a6a866020c69a94f3e01b'
ARCHIVE_BASE_RELICS_28_SIZE='34000'
ARCHIVE_BASE_RELICS_28_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_RELICS_24_NAME='stellaris_ancient_relics_3_7_4_63489.sh'
ARCHIVE_BASE_RELICS_24_MD5='51f5bc20188137581737a446b1b7498b'
ARCHIVE_BASE_RELICS_24_SIZE='34000'
ARCHIVE_BASE_RELICS_24_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_RELICS_21_NAME='stellaris_ancient_relics_3_6_1_60754.sh'
ARCHIVE_BASE_RELICS_21_MD5='40806c04f94d933aa555bc9d9605396c'
ARCHIVE_BASE_RELICS_21_SIZE='34000'
ARCHIVE_BASE_RELICS_21_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_RELICS_19_NAME='stellaris_ancient_relics_3_5_3_59410.sh'
ARCHIVE_BASE_RELICS_19_MD5='1052a7d2b77ba0ebbd8af19767952b47'
ARCHIVE_BASE_RELICS_19_SIZE='34000'
ARCHIVE_BASE_RELICS_19_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_RELICS_17_NAME='stellaris_ancient_relics_3_4_5_56913.sh'
ARCHIVE_BASE_RELICS_17_MD5='b7536ac852bebe9b12a359c4c0a6ca5e'
ARCHIVE_BASE_RELICS_17_SIZE='34000'
ARCHIVE_BASE_RELICS_17_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_RELICS_13_NAME='stellaris_ancient_relics_3_3_4_54421.sh'
ARCHIVE_BASE_RELICS_13_MD5='c09ef087df7e271758b4b8a47a1353bd'
ARCHIVE_BASE_RELICS_13_SIZE='34000'
ARCHIVE_BASE_RELICS_13_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_RELICS_9_NAME='stellaris_ancient_relics_3_2_1_1_51520.sh'
ARCHIVE_BASE_RELICS_9_MD5='45de001d3d2b3999d6c4c8948fc22458'
ARCHIVE_BASE_RELICS_9_SIZE='34000'
ARCHIVE_BASE_RELICS_9_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_RELICS_8_NAME='stellaris_ancient_relics_3_1_1_50008.sh'
ARCHIVE_BASE_RELICS_8_MD5='ec441d202f321a3d8b23af35fed33531'
ARCHIVE_BASE_RELICS_8_SIZE='34000'
ARCHIVE_BASE_RELICS_8_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_RELICS_7_NAME='stellaris_ancient_relics_3_0_3_47193.sh'
ARCHIVE_BASE_RELICS_7_MD5='d98a169dca98257b3944517d98cd17a0'
ARCHIVE_BASE_RELICS_7_SIZE='34000'
ARCHIVE_BASE_RELICS_7_VERSION='3.0.3-gog47193'

## First Contact

ARCHIVE_BASE_CONTACT_25_NAME='stellaris_first_contact_story_pack_4_1_7_86266.sh'
ARCHIVE_BASE_CONTACT_25_MD5='4667442592b03564cf65722636ae7dff'
ARCHIVE_BASE_CONTACT_25_SIZE='832'
ARCHIVE_BASE_CONTACT_25_VERSION='4.1.7-gog86266'
ARCHIVE_BASE_CONTACT_25_URL='https://www.gog.com/game/stellaris_first_contact_story_pack'

ARCHIVE_BASE_CONTACT_24_NAME='stellaris_first_contact_story_pack_4_0_23_84679.sh'
ARCHIVE_BASE_CONTACT_24_MD5='8138329a8b9d21f5208ea28fb6fc3390'
ARCHIVE_BASE_CONTACT_24_SIZE='832'
ARCHIVE_BASE_CONTACT_24_VERSION='4.0.23-gog84679'

ARCHIVE_BASE_CONTACT_23_NAME='stellaris_first_contact_story_pack_3_14_1592653_81105.sh'
ARCHIVE_BASE_CONTACT_23_MD5='08a96e2468e6bf4530ea0a9dc966efe4'
ARCHIVE_BASE_CONTACT_23_SIZE='832'
ARCHIVE_BASE_CONTACT_23_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_CONTACT_21_NAME='stellaris_first_contact_story_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_CONTACT_21_MD5='12877f96dc523f3328a8f8231ebb2d84'
ARCHIVE_BASE_CONTACT_21_SIZE='832'
ARCHIVE_BASE_CONTACT_21_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_CONTACT_18_NAME='stellaris_first_contact_story_pack_3_12_5_74193.sh'
ARCHIVE_BASE_CONTACT_18_MD5='d3e6622881abe21c5883e5fa61988f6b'
ARCHIVE_BASE_CONTACT_18_SIZE='832'
ARCHIVE_BASE_CONTACT_18_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_CONTACT_14_NAME='stellaris_first_contact_story_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_CONTACT_14_MD5='946d0530c559cc4275177143f808a4e6'
ARCHIVE_BASE_CONTACT_14_SIZE='832'
ARCHIVE_BASE_CONTACT_14_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_CONTACT_11_NAME='stellaris_first_contact_story_pack_3_10_4_70670.sh'
ARCHIVE_BASE_CONTACT_11_MD5='aa77a6af433d0ed023357b1af69876ce'
ARCHIVE_BASE_CONTACT_11_SIZE='832'
ARCHIVE_BASE_CONTACT_11_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_CONTACT_5_NAME='stellaris_first_contact_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_CONTACT_5_MD5='870a8a53a98f020d9cb55e2b962b6172'
ARCHIVE_BASE_CONTACT_5_SIZE='1152'
ARCHIVE_BASE_CONTACT_5_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_CONTACT_2_NAME='stellaris_first_contact_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_CONTACT_2_MD5='dd862bf0d12f5bf0a7a7c116a57f2bbb'
ARCHIVE_BASE_CONTACT_2_SIZE='1200'
ARCHIVE_BASE_CONTACT_2_VERSION='3.8.4.1-gog65337'

## Grand Archive

ARCHIVE_BASE_ARCHIVE_0_NAME='stellaris_grand_archive_4_1_3_85354.sh'
ARCHIVE_BASE_ARCHIVE_0_MD5='72882f69a388d7fbf66e384878004514'
ARCHIVE_BASE_ARCHIVE_0_SIZE='33060'
ARCHIVE_BASE_ARCHIVE_0_VERSION='4.1.3-gog85354'
ARCHIVE_BASE_ARCHIVE_0_URL='https://www.gog.com/game/stellaris_grand_archive'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
dlc'

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_default

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
