#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Arrow
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241217.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='arrow'
GAME_NAME='Arrow'

ARCHIVE_BASE_1_NAME='setup_arrow_1.4_(72714).exe'
ARCHIVE_BASE_1_MD5='0ef643cae5b5ed1c4eb945878bb286f4'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='19128'
ARCHIVE_BASE_1_VERSION='1.4-gog72714'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/arrow'

ARCHIVE_BASE_0_NAME='setup_arrow_1.3_(70348).exe'
ARCHIVE_BASE_0_MD5='8a697981bef580f95f8aa6cf13a7ccf2'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='18955'
ARCHIVE_BASE_0_VERSION='1.3-gog70348'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
almixer.dll
coronalabs.corona.native.dll
lua.dll
openal32.dll
plugin_hwcursor.dll
pthreads.dll
arrow.exe'
CONTENT_GAME_DATA_FILES='
resources'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/AleC Games/Arrow
users/${USER}/AppData/Local/AleC Games/Arrow'

APP_MAIN_EXE='arrow.exe'
APP_MAIN_ICON='resources/icon-win32.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
