##############################################################################
# 
# Zope Public License (ZPL) Version 1.0
# -------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# This license has been certified as Open Source(tm).
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Digital Creations requests that attribution be given to Zope
#    in any manner possible. Zope includes a "Powered by Zope"
#    button that is installed by default. While it is not a license
#    violation to remove this button, it is requested that the
#    attribution remain. A significant investment has been put
#    into Zope, and this effort will continue if the Zope community
#    continues to grow. This is one way to assure that growth.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# 
# This software consists of contributions made by Digital Creations and
# many individuals on behalf of Digital Creations.  Specific
# attributions are listed in the accompanying credits file.
# 
##############################################################################

__doc__ = '''K Interbase Adapter Product Module

$Id: db.py,v 1.3 2002/04/29 08:43:54 mw Exp $
'''
import sys
import string

try:
    import kinterbasdb
except:
    for n in sys.exc_info():
        print n
    raise 'The kinterbase module is not installed!'

from Shared.DC.ZRDB.TM import TM
from exceptions import StandardError, TypeError


def isProcedure(stmt):
    """
    isProcedure - Determine if the SQL statement is EXECUTE PROCEDURE.
    """

    tokens = string.split(stmt)
    word1  = string.lower(tokens[0])
    word2  = string.lower(tokens[1])

    if word1 == 'execute' and word2 == 'procedure':
        return 1

    return 0


class DB(TM):
    """
    DB Class -
    """

    def __init__(self, connection_string = ''):
        """
	__init__ - Instantiate a database connection.
	"""
        db, usr, passw = string.split(connection_string)


        self.connection = kinterbasdb.connect(dsn=db, user=usr, password=passw)

        self.cursor  = self.connection.cursor()


    def _begin(self):
        """
	_begin - Start a transaction. 
	"""

	# This is a NOP because the underlying Python/Interbase code
	# starts a transaction when a connection is made.

	pass


    def _finish(self):
        """
	_finish - Issue a commit against the database.
	"""
	self.connection.commit()


    def _abort(self):
        """
	_abort - Issue a rollback against the database.
	"""
	self.connection.rollback()


    def reInitCursor(self):
    	# on error the KInterbasDB Cursor
    	# is in a bad state an the cursor
    	# has to be reinitialized
    	try:
    		self.cursor.close()
    	except:
    		pass
    	
    	self.cursor  = self.connection.cursor()
    	
    	
    def query(self, src=None, max_rows=99999999):
        """
	query - Execute a SQL statement.
	"""

	self._register()
	if src == None or src == '':
	   raise RuntimeError, "Empty SQL statement passed to the query method."

        rows    = []
	columns = []

        # If the SQL statement is EXECUTE PROCEDURE then invoke callproc,
	# otherwise invoke execute.

        if isProcedure(src):
            try:
            	    tmp = self.cursor.callproc(src)
            except:
            	self.reInitCursor()
            	raise
            	
	    rows.append(tmp)
        else:
            try:
	    	self.cursor.execute(src)
	    except:
	    	self.reInitCursor()
	    	raise
	    	
	    if self.cursor.description:
                rows = self.cursor.fetchmany(max_rows)

	if self.cursor.description:
	    for n in self.cursor.description:
                current = { 'name' : '', 'type' : '', 'width' : 0, 'null' : 0 }

	        name, type, dsize, isize, prec, scale, nulls = n

	        current['name'] = name
	        current['null'] = nulls
	        
	        if type == kinterbasdb.STRING:
	            current['type'] = 's'
	        if type == kinterbasdb.BINARY:
	            current['type'] = 's'
	            current['width'] = isize
	        if type == kinterbasdb.NUMBER:
	            current['type'] = 'n'
	        if type == kinterbasdb.DATETIME:
	            current['type'] = 'd'


	        if type == kinterbasdb.STRING:
		    current['width'] = isize

                columns.append(current)

	return (columns, rows)


