#!/usr/bin/python
import sys
import os.path
import glob
from string import strip, replace
import re

if not sys.argv[1:]:
    print """
Usage: appendix_a.py <path>

Builds 'AppendixA.stx' by locating DTML reference information in a
Zope home directory. The argument should be the path to a Zope home
directory.

"""
    sys.exit(1)
dir=sys.argv[1]
if not os.path.isdir(dir):
    print "Path should be a path to your Zope directory"
    sys.exit(1)

# AppendixA
f=open('AppendixA.stx', 'wb')
f.write("""\
Appendix A: DTML Reference

  DTML is the *Document Template Markup Language*, a handy presentation and
  templating language that comes with Zope.  This Appendix is a reference to
  all of DTMLs markup tags and how they work.

""")

link=re.compile(r'"([^"]+)":\S+\.(stx|py)([\s\.,:;\n])')

files=glob.glob(os.path.join(dir, 'lib/python/Products/OFSP/help/dtml-*.stx'))
files.sort()
for file in files:
    s=open(file, 'rb').read()
    # fix intra-tag links
    while 1:
        m=link.search(s)
        if m is None:
            break
        s=s[:m.start()] + m.group(1) + m.group(3) + s[m.end():]
    s=strip(s)
    s=replace(s, '\n', '\n  ')
    f.write('  ')
    f.write(s)
    f.write('\n\n')
f.close()
print "Wrote AppendixA.stx"





