// file      : xsd-frontend/transformations/schema-per-type.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2006-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSD_FRONTEND_TRANSFORMATIONS_SCHEMA_PER_TYPE_HXX
#define XSD_FRONTEND_TRANSFORMATIONS_SCHEMA_PER_TYPE_HXX

#include <cult/types.hxx>
#include <cult/containers/vector.hxx>

#include <xsd-frontend/semantic-graph/elements.hxx> // Path
#include <xsd-frontend/semantic-graph/schema.hxx>

namespace XSDFrontend
{
  namespace Transformations
  {
    using namespace Cult::Types;

    class TypeSchemaTranslator
    {
    public:
      virtual
      ~TypeSchemaTranslator ();

      virtual WideString
      translate (WideString const& ns, WideString const& name) = 0;
    };

    // This transformation restructures the semantic graph to have
    // each type definition in a seperate schema file.
    //
    class SchemaPerType
    {
    public:
      struct Failed {};

      SchemaPerType (TypeSchemaTranslator&);

      Cult::Containers::Vector<SemanticGraph::Schema*>
      transform (SemanticGraph::Schema&);

    private:
      TypeSchemaTranslator& trans_;
    };
  }
}

#endif // XSD_FRONTEND_TRANSFORMATIONS_SCHEMA_PER_TYPE_HXX
