#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <dirent.h>
#include <sys/time.h>

#include "globals.h"
#include "filetype.h"
#include "graphics.h"
#include "interface-xmms.h"

gint counter;
gchar* gettitle(struct fileinfo *info,gint pos);
gint compare(gchar *string1,gchar *string2);

gboolean newstream=FALSE,hidden=FALSE;

gint timeout_func(void)
{
  gchar *text,*temp,*skin;
  gint cur;
  char *pos;
  struct image_name_buffer *imbuff,*tempbuf;
  long timerslide;

  skin=coview_skin();
  if (!skin)
	{skin=malloc(1); skin[0]=0;	}
  if ((redrawskin || strcmp(curskin,skin)!=0) && skinned)
  	{
	free(curskin);
	curskin=skin;
	coview_load_skin(curskin);
	redrawskin=FALSE;
	}

  if (coview_playlist_length()!=0)
        {
		cur = coview_playlist_pos ();
    	text = coview_playlist_filename(cur);
		temp=strdup(curdir);
		free(curtitle);
		curtitle=gettitle(curfile,cur);	
		if (strcmp(text,curfile->filename)!=0 || (stream_play && counter++>20))
			{
			stream_play=FALSE;
			newstream=FALSE;
			counter=0;
			purge_temp();
			get_file_info(text);
			if (!(stream_play)) 
				{ net_search=FALSE; lock_file=FALSE; album_search=FALSE; }
			if (stream_play)
				{
				from_dir=2;
				if 	(strcmp(curstream,curtitle)!=0)
					{
					free(curstream);
					curstream=strdup(curtitle);
					scroll=0;
					scrolldir=5;
					newstream=TRUE;
					net_search=FALSE; lock_file=FALSE; album_search=FALSE;
					}
				}
			else
				{
				scroll=0;
				scrolldir=5;
				}
			if (from_dir==1) from_dir=2;
			pos=strrchr(text,'/');
			if (pos)
				{
				temp=(char *) malloc (pos-text+2);
	       		strncpy(temp,text,pos-text+1);
    	   		temp[pos-text+1]=0;
				}
			}
		else free(text);
        if (strcmp(curdir,temp)!=0 || (from_dir==2 && (!stream_play || newstream))|| net_search || album_search)
            {
//			if (net_search) printf("Searching\n");
//			if (strcmp(curdir,temp)!=0) printf("New directory\n");
//			if (from_dir==2 && (!stream_play || newstream)) printf("New file Or New stream\n");
			
	    	im_found=0; //managing=FALSE;
	    	if (!net_search && !album_search) // To avoid flickering while searching...
				imcount=0;
	    	from_dir=1;
	    	free(curdir);
            curdir=temp;
	    	im_found=find_cover(curdir,curfile,&first);		// look for images
	    	if (im_found>0)
				{
				if (hidden)													// popup window in case it was hidden
				{
					coview_show_yourself(TRUE);
					hidden=FALSE;
				}
				net_search=FALSE;
				imcount=0;
				imbuff=first;
				while (imbuff->next)								// Sort images "alphabetically"
					{
					curimage=first;
					while (curimage!=imbuff)
						{
						if (compare(curimage->next->imagename,imbuff->next->imagename))
							{
							tempbuf=malloc(sizeof(image_name_buffer)); // swap the two images
							tempbuf->next=imbuff->next->next;
							imbuff->next->next=curimage->next;
							curimage->next=imbuff->next;
							imbuff->next=tempbuf->next;
							free(tempbuf);
							break;
							}
						else curimage=curimage->next;
						}
					if (curimage==imbuff) imbuff=curimage->next;
						else curimage=first;
					}
				curimage=first->next;
				imcount=0;
				slide_pause=1;
				}
	      	else
				{
				curimage=first;
				slide_pause=0;
				if (auto_hide && !hidden)
					{coview_show_yourself(FALSE);
					hidden=TRUE;
					}
				}
	     	}
        else free(temp);
		coview_draw_title(curtitle);
		if (shuffle!=coview_test_shuffle() || repeat!=coview_test_repeat())
			{
			shuffle=coview_test_shuffle();
			repeat=coview_test_repeat();
			if (skinned) coview_load_skin(curskin);
			}
		if (imcount==0)
			{
			coview_load_image(curimage->imagename);
			if (imcount==666)
				{
				/* invalid image */
				printf("This image is invalid, you should check it : %s\n",curimage->imagename);
				imbuff=first;
				while (imbuff->next!=curimage)
					imbuff=imbuff->next;
				imbuff->next=curimage->next;
				curimage=curimage->next;
				if (!curimage)
					curimage=first->next;
				if (!curimage)
					{ curimage=first;
					curimage->imagename=NULL; }
				imcount=-1;
				}
			gettimeofday(&slide_start,NULL);
			imcount++;
			}
//		if (moving==0) imcount=imcount+slide_pause;
		gettimeofday(&time_now,NULL);
		timerslide=(time_now.tv_sec-slide_start.tv_sec)*1000+((time_now.tv_usec-slide_start.tv_usec))/1000;
		if (timerslide>slide_speed && slide && !managing)
			{
			imcount=0;
			curimage=curimage->next;
			if (!curimage) curimage=first->next;
			if (!curimage) curimage=first;
			if (((first->next) && !(first->next->next)) || !(first->next))
				 {imcount=1;}
			}
        }
	return TRUE;
}

gchar *gettitle(struct fileinfo *info,gint pos)
	{
	gchar *title=NULL;
	
	if (info)
		{
		title=gentitle(info);
		if (title) return title;
		}
	title=coview_title(pos);
	return title;
	}

gint compare(gchar *string1,gchar *string2) // returns 0 if string1 comes before string2
	{ gchar *s1,*s2,*keyword,*words,*offset;
	gint n,breaking;
	gint answer=0;
	s1=up(string1);
	s2=up(string2);
	words=up(image_keywords);
	words=replace(words,"  "," ");
	if (strlen(words)==0)
		words=strdup(" ");
	offset=words;
	breaking=0;
	while(offset-words<strlen(words))	//get keywords
	{
		n=0;
		while( (offset[n]!=32) && (offset+n<words+strlen(words)))
			n++;
		keyword=strndup(offset,n);
		if (strstr(s1,keyword))
			{ breaking=1; free(keyword); break; }
		if (strstr(s2,keyword))
			{ breaking=1; answer=1; free(keyword); break; }
		free(keyword);
		offset+=n+1;
	}
	if (breaking==0 && strcmp(s1,s2)>0)
		answer=1;

	free(words);	free(s1); free(s2);
	return answer;
	}
