/* wdefines.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: wdefines.h,v 1.18 2002/02/21 00:11:49 ralf Exp $ */

#ifndef WDEFINES_H
#define WDEFINES_H

#include <time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <sys/param.h>  /* for MAXPATHLEN ... */
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <sys/time.h>
#include <errno.h>
#include <grp.h>
#include <pwd.h>
#include <fnmatch.h>
#include <ctype.h>
#include <utime.h>

#ifdef HAVE_CONFIG_H
  #ifndef CONFIG_H_INCLUDED
    #include "../config.h"
    #define CONFIG_H_INCLUDED
  #endif
#endif

#if defined(HAVE_SYS_STATVFS_H)
  #include <sys/statvfs.h>
#elif ( defined(BSD) && (BSD >= 199506) )
  /* statfs on FreeBSD-2.2.2, BSD is defined in sys/param.h */
  #include <sys/mount.h>
#endif
#ifdef HAVE_SYS_VFS_H
  #include <sys/vfs.h>
#endif
#ifdef HAVE_SYS_SYSINFO_H
  #include <sys/sysinfo.h>
#endif

#if 0  // for filetype checking with file
#include <regex.h>
#endif

#include <aguix/aguixdefs.h>

#ifdef HAVE_LIBZ
  #include <zlib.h>
#endif

#define CP_COMMAND "cp -a %s %s"
#define CP_COMMAND_FORCE "cp -a -f %s %s"
#define OUTPUT_BIN "xmessage -file %s"
#define TERMINAL_BIN "xterm -e %s"

#if 0  // for filetype checking with file
#define FILE_COMMAND "file -b %s"
#endif

#ifndef LINUX
  #ifndef ARG_MAX
    #ifdef _POSIX_ARG_MAX
      #define ARG_MAX _POSIX_ARG_MAX
    #else
      #define ARG_MAX MAXPATHLEN
    #endif
  #endif
#endif

#define EXE_STRING_LEN ARG_MAX

#ifdef DEVELOPER
  #define USEOWNCONFIGFILES
#endif

#ifndef PREFIX
  #define GLOBALDATADIR "/usr/local/share/worker"
#else
  #define GLOBALDATADIR PREFIX"/share/worker"
#endif

#define max(a,b) (((a)>(b))?(a):(b))
#define w_max(a,b) (((a)>(b))?(a):(b))
#define w_min(a,b) (((a)<(b))?(a):(b))

#endif
