/* aguix.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: aguix.h,v 1.21 2002/03/18 01:12:41 ralf Exp $ */

#ifndef AGUIX_H
#define AGUIX_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <X11/Xatom.h>

#include "aguixdefs.h"
#include "lowlevelfunc.h"
#include "message.h"
#include "util.h"

class AWindow;
class AGUIXFont;

enum {MES_WAIT,MES_GET};
enum {NON_GADGET,CLOSE_GADGET,BUTTON_GADGET,SHADOW_GADGET,CHOOSE_GADGET,LISTVIEW,ONELVC,MORELVC,STRING_GADGET};

struct aguix_windowlist {
  AWindow *window;
  struct aguix_windowlist *next;
  struct aguix_windowlist *prev;
};

class AGUIX {
public:
  AGUIX();
  ~AGUIX();
  int initX(int argc,char **argv,char *classname);
  int checkX();
  void closeX();
  int getDepth();
  Colormap getColormap();
  Display *getDisplay();
  int getScreen();
  void panic(const char *);
  void setFG(int color);
  void setBG(int color);
  void setFG(GC gc,int color);
  void setBG(GC gc,int color);
  int getCharHeight();
  int getCharWidth();
  void FillRectangle(Drawable buffer,int x,int y,int w,int h);
  void DrawText(Drawable buffer,const char *text,int x,int y);
  void DrawLine(Drawable buffer,int x1,int y1,int x2,int y2);
  void DrawPoint(Drawable buffer,int x,int y);
  void FillRectangle(Drawable buffer,GC gc,int x,int y,int w,int h);
  void DrawText(Drawable buffer,AGUIXFont *,const char *text,int x,int y);
  void DrawLine(Drawable buffer,GC gc,int x1,int y1,int x2,int y2);
  void DrawPoint(Drawable buffer,GC gc,int x,int y);

  void DrawTriangleFilled(Drawable buffer, int x1, int y1, int x2, int y2, int x3, int y3);
  void DrawTriangleFilled(Drawable buffer, GC tgc, int x1, int y1, int x2, int y2, int x3, int y3);

  void ClearWin(Window win);
  void SetWindowBG(Window win,int color);
  int getFontBaseline();
  int AddColor(int red,int green,int blue);
  void removeLastColor();
  int changeColor(int,int,int,int);
  int getMaxCols();
  unsigned long getPixel(int color);
  char *getClassname();
  Atom *getCloseAtom();
  void insertWindow(AWindow *win);
  void removeWindow(AWindow *win);
  AGMessage *GetMessage(AWindow *parent);
  AGMessage *WaitMessage(AWindow *parent);
  void ReplyMessage(AGMessage *);
  Message *wait4mess(int mode,bool);
  Message *wait4messReact(int mode,bool);
  void copyArea(Drawable source,Drawable dest,int s_x,int s_y,int width,int height,int d_x,int d_y);
  void Flush();
  int getargc();
  char **getargv();
  void putAGMsg(AGMessage *msg);
  AGMessage *getAGMsg();
  void WindowtoFront(Window);
  void WindowtoBack(Window);
  AGUIXFont *getFont(char*);
  int setFont(char*);
  void ExposeHandler(Message*);
  AWindow *findAWindow(Window);
  char *getNameOfKey(KeySym,unsigned int);
  Window getGroupWin();
  int queryPointer(Window win,int *x,int *y);
  int queryRootPointer(int *x,int *y);
  int queryPointer(Window win,int *x,int *y,unsigned int *buttons);
  void setCursor(Window win,int type);
  void unsetCursor(Window win);

  enum {WAIT_CURSOR=0,SCROLLH_CURSOR,SCROLLV_CURSOR,MAXCURSORS};
  int startCut(GUIElement *elem,const char *buffer);
  void cancelCut();
  int startPaste(GUIElement *elem);
  bool amiOwner();
  const char *getCutBuffer();
  void requestCut(Window win);
  void cancelCutPaste(GUIElement *elem);
  bool isDoubleClick(struct timeval *t1,struct timeval *t2);
  bool isDoubleClick( Time t1, Time t2 );

  static int scaleElementsW( int wantedWidth,
			     int borderwidth,
			     int minSpace,
			     int maxSpace,
			     bool allowShrink,
			     bool allowStretch,
			     GUIElement **elem,
			     int nr );
  static int centerElementsY( GUIElement *element,
			      GUIElement *center2element );
  int getRootWindowWidth();
  int getRootWindowHeight();
private:
  Display *dsp;
  int scr;
  Colormap cmap;
  GC gc;
  Atom WM_delete_window;
  char *classname;
  struct aguix_windowlist *firstwin;
  unsigned long white,black;
  XFontStruct *myfont;
  AGUIXFont *mainfont;
  int initOK;
  int argc;
  char **argv;
  int CharHeight;
  int CharWidth;
  unsigned long ColBuf[256];
  int colors;
  XEvent LastEvent;
  List *wins;
  List *messages;
  List *fonts;
  Window groupwin;
  void createGroupWin();
  void destroyGroupWin();
  
  bool ReactMessage(Message*,AWindow*);
  void buildAGMessage();
  
  bool privatecmap;
  void changeColormap();

  Cursor cursors[MAXCURSORS];
  GUIElement *cutstart,*pastestart;
  char *cutbuffer;

  unsigned int rootWindowWidth, rootWindowHeight;
};

class AGUIXFont
{
public:
  AGUIXFont(AGUIX*);
  ~AGUIXFont();
  int setFont(char*);
  void removeFont();
  GC getGC();
  const char *getName();
  int getCharHeight();
  int getCharWidth();
  int getBaseline();
  XFontStruct *getFontStruct();
private:
  char *name;
  GC gc;
  AGUIX *aguix;
  XFontStruct *font;
  int charWidth,charHeight;
};

#endif

