#
# This script establishes list of transitive groups.
# You should run it when you update GAP to new version whose transtive
# groups database changes.

if [ ! -d trans ]; then exit; fi
cd trans
ulimit -d 30000
rm -f * &>/dev/null

gap.sh <<@
IsDihedralGroup:=function(dgrp)
 local siz, gens, ords;
 siz:=Size(dgrp);
 if Gcd(siz,2)<>2 then return false; else siz:=siz/2; fi;
 gens:=SmallGeneratingSet(dgrp); ords:=List(gens,Order);
 if (ords=[2,siz] or ords=[siz,2]) and Order((gens[1]*gens[2])^2)=1 then 
  return true; else return false;
 fi;
end;
naturecode:=function(grp)
local a; a:=0;
 if IsCyclic(grp) then a:=1; elif
    IsAbelian(grp) then a:=2; elif
    IsNilpotentGroup(grp) then a:=3; elif
    IsDihedralGroup(grp) then a:=5; elif
    IsSolvableGroup(grp) then a:=4; elif
    IsSimpleGroup(grp) then a:=11; elif
    IsPerfectGroup(grp) then a:=12; fi;
 return a; end;

 for s in [3..23] do
  n:=NrTransitiveGroups(s);
  for i in [1..n] do
   G:=TransitiveGroup(s,i);
   a:=naturecode(G);
   AppendTo(String(s),":",i,",",Size(G),",",a,",",G,"\n");
  od;
 od;
@

for i in [0-9]*
do
 cat $i | sed 's/</\&lt;/g;s/ = /=/g' >$i..
 mv $i.. $i
 t=`grep -c '\:' $i`
 echo "!set transtot_$i=$t" >>index
done

