/*
    vlad - an LDAP visualisation tool
    Copyright (C) 1999-2001 Robert Norris <rob@nauseum.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>

#include "vlad.h"

struct attr *create_attr_struct(void) {
	struct attr *attr;

	if(!(attr = (struct attr *) malloc(sizeof(struct attr)))) return NULL;

	attr->name = NULL;
	attr->value = NULL;

	return attr;
	}

void free_attr_struct(struct attr *attr) {
	if(attr->name) free(attr->name);
	if(attr->value) free(attr->value);

	free(attr);
	}

void free_attr_set(struct attr **attrs) {
	struct attr *attr;

	for(attr = *attrs; attr; attr++)
		free_attr_struct(attr);
	
	free(attrs);
	}
