/****************************************************************************
    Copyright (C) 1987-2005 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Mon Dec  8 13:44:21 2003
****************************************************************************/
#include "tkgate.h"

static iconDimensions reg_iconDims[] = {
  {0,  0, 75, 20, 36, 9},
  {97, 0, 20, 75, 10, 37},
  {0, 21, 75, 20, 36, 9},
  {76, 0, 20, 75, 10, 37},
};
static int reg_iconBoldOffset = 76;

struct locate register_in_loc[] = {
	{0,-10,0,-10,D_UP},
	{-11,0,-11,0,D_LEFT},
	{0,11,0,11,D_DOWN},
	{10,0,10,0,D_RIGHT}};

struct locate register_out_loc[] = {
	{0,11,0,11,D_DOWN},
	{10,0,10,0,D_RIGHT},
	{0,-10,0,-10,D_UP},
	{-11,0,-11,0,D_LEFT}};

struct locate register_ck_loc[] = {
	{-37,0,-37,0,D_LEFT},
	{0,38,0,38,D_DOWN},
	{39,0,39,0,D_RIGHT},
	{0,-38,0,-38,D_UP}};

struct locate register_en_loc[] = {
	{39,5,39,5,D_RIGHT},
	{5,-38,5,-38,D_UP},
	{-37,-5,-37,-5,D_LEFT},
	{-5,38,-5,38,D_DOWN}};

struct locate register_clr_loc[] = {
	{39,-5,39,-5,D_RIGHT},
	{-5,-38,-5,-38,D_UP},
	{-37,5,-37,5,D_LEFT},
	{5,38,5,38,D_DOWN}};


static char *psRegister[] = {
  "%",
  "% A Register",
  "/register {",
  "  [[0 0][-1 1][2 1][0 -1]] adjstartgate",
  "  -36.5 -10.5 moveto",
  "  -36.5 9.5 lineto",
  "  38.5 9.5 lineto",
  "  38.5 -10.5 lineto",
  "  closepath stroke",
  "  -36.5 -7 moveto",
  "  -30 0 lineto",
  "  -36.5 7 lineto stroke",
  "  7 rfont",
  "  (_CLR) dup stringwidth pop neg 36 add 0 prshow",
  "  (_EN) dup stringwidth pop neg 36 add -9 prshow",
  "  grestore",
  "} def",
  0
};

GGateInfo gate_register_info = {
  REGISTER,
  "Register",
  "register",0x0,
  "register",psRegister,

  {{"r",	{"gmmem",5},		{"gmreg",0,0,100},	"gat_make register"},
   {0}},


  reg_iconDims,

  5,{{"Q",OUT,8,1,register_out_loc},
     {"D",IN,8,1,register_in_loc},
     {"EN",IN,1,1,register_en_loc},
     {"CLR",IN,1,1,register_clr_loc},
     {"CK",IN,1,1,register_ck_loc}},
  {{0,3,CT},{13,-5,LJ},{0,3,CT},{13,-5,LJ}},
  {1},

  {"setup","hold","CK-Q",0},
  
  Generic_Make,
  Generic_Init,
  Generic_Delete,
  Generic_GetExtents,
  Generic_HitDistance,
  Generic_Draw,
  Generic_Move,
  Generic_Replicate,
  Err_AddInput,
  Err_AddOutput,
  Err_AddInOut,
  Err_ChangePin,
  Nop_SimStateFunc,
  Nop_SimHitFunc,
  Generic_PSWrite,
  Generic_EditProps,
  Generic_VerSave
};


void init_register()
{
  Pixmap P;

  P = Pixmap_registerFromFile("reg","reg.b");
  gateinfo_iconInit(&gate_register_info,P,reg_iconDims,reg_iconBoldOffset);
  RegisterGate(&gate_register_info);
}
