/* The help messages for TeX & MF family of programs.

Copyright (C) 1995, 96 Karl Berry, 2001 O.Weber.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef TEXMFMP_HELP
#define TEXMFMP_HELP

#ifdef eTeX
const_string ETEXHELP[] = {
    "Usage: etex [OPTION]... [TEXNAME[.tex]] [COMMANDS]",
    "   or: etex [OPTION]... \\FIRST-LINE",
    "   or: etex [OPTION]... &FMT ARGS",
    "  Run e-TeX on TEXNAME, usually creating TEXNAME.dvi.",
    "  Any remaining COMMANDS are processed as e-TeX input, after TEXNAME is read.",
    "  If the first line of TEXNAME is %&FMT, and FMT is an existing .efmt file,",
    "  use it.  Else use `NAME.efmt', where NAME is the program invocation name,",
    "  most commonly `etex'.",
    "",
    "  Alternatively, if the first non-option argument begins with a backslash,",
    "  interpret all non-option arguments as a line of e-TeX input.",
    "",
    "  Alternatively, if the first non-option argument begins with a &, the",
    "  next word is taken as the FMT to read, overriding all else.  Any",
    "  remaining arguments are processed as above.",
    "",
    "  If no arguments or options are specified, prompt for input.",
    "",
    "-efmt=FMTNAME            use FMTNAME instead of program name or a %& line",
    "-file-line-error-style   print file:line:error style messages",
    "-ini                     be einitex, for dumping formats; this is implicitly",
    "                          true if the program name is `einitex'",
    "-interaction=STRING      set interaction mode (STRING=batchmode/nonstopmode/",
    "                          scrollmode/errorstopmode)",
#ifdef IPC
    "-ipc                     send DVI output to a socket as well as the usual",
    "                          output file",
    "-ipc-start               as -ipc, and also start the server at the other end",
#endif /* IPC */
    "-jobname=STRING          set the job name to STRING",
    "-kpathsea-debug=NUMBER   set path searching debugging flags according to",
    "                          the bits of NUMBER",
    "[-no]-mktex=FMT          disable/enable mktexFMT generation (FMT=tex/tfm)",
    "-mltex                   enable MLTeX extensions such as \\charsubdef",
    "-output-comment=STRING   use STRING for DVI file comment instead of date",
    "-parse-first-line        parse of the first line of the input file",
    "-progname=STRING         set program (and fmt) name to STRING",
    "-recorder                enable filename recorder",
    "-shell-escape            enable \\write18{SHELL COMMAND}",
    "-src-specials            insert source specials into the DVI file",
    "-src-specials=WHERE      insert source specials in certain places of",
    "                          the DVI file. WHERE is a comma-separated value",
    "                          list: cr display hbox math par parend vbox",
    "-translate-file=TCXNAME  use the TCX file TCXNAME",
    "-help                    display this help and exit",
    "-version                 output version information and exit",
    NULL
};
#endif /* eTeX */

#ifdef MF
const_string MFHELP[] = {
    "Usage: mf [OPTION]... [MFNAME[.mf]] [COMMANDS]",
    "   or: mf [OPTION]... \\FIRST-LINE",
    "   or: mf [OPTION]... &BASE ARGS",
    "  Run Metafont on MFNAME, usually creating MFNAME.tfm and MFNAME.NNNNgf,",
    "  where NNNN is the resolution of the specified mode (2602 by default).",
    "  Any following COMMANDS are processed as Metafont input,",
    "  after MFNAME is read.",
    "  If the first line of MFNAME is %&BASE, and BASE is an existing .base file,",
    "  use it.  Else use `NAME.base', where NAME is the program invocation name,",
    "  most commonly `mf'.",
    "",
    "  Alternatively, if the first non-option argument begins with a backslash,",
    "  interpret all non-option arguments as a line of Metafont input.",
    "",
    "  Alternatively, if the first non-option argument begins with a &, the",
    "  next word is taken as the BASE to read, overriding all else. Any",
    "  remaining arguments are processed as above.",
    "",
    "  If no arguments or options are specified, prompt for input.",
    "",
    "-base=BASENAME           use BASENAME instead of program name or a %& line",
    "-file-line-error-style   print file:line:error style messages",
    "-ini                     be inimf, for dumping bases; this is implicitly",
    "                          true if the program name is `inimf'",
    "-interaction=STRING      set interaction mode (STRING=batchmode/nonstopmode/",
    "                          scrollmode/errorstopmode)",
    "-jobname=STRING          set the job name to STRING",
    "-kpathsea-debug=NUMBER   set path searching debugging flags according to",
    "                          the bits of NUMBER",
    "[-no]-mktex=FMT          disable/enable mktexFMT generation (FMT=mf)",
    "-parse-first-line        parse of the first line of the input file",
    "-progname=STRING         set program (and base) name to STRING",
    "-recorder                enable filename recorder",
    "-translate-file=TCXNAME  use the TCX file TCXNAME",
    "-help                    display this help and exit",
    "-version                 output version information and exit",
    NULL
};
#endif /* MF */

#ifdef MP
const_string MPHELP[] = {
    "Usage: mpost [OPTION]... [MPNAME[.mp]] [COMMANDS]",
    "   or: mpost [OPTION]... \\FIRST-LINE",
    "   or: mpost [OPTION]... &MEM ARGS",
    "  Run MetaPost on MPNAME, usually creating MPNAME.NNN (and perhaps",
    "  MPNAME.tfm), where NNN are the character numbers generated.",
    "  Any remaining COMMANDS are processed as MetaPost input,",
    "  after MPNAME is read.",
    "  If the first line of MPNAME is %&MEM, and MEM is an existing .mem file,",
    "  use it.  Else use `NAME.mem', where NAME is the program invocation name,",
    "  most commonly `mp'.",
    "",
    "  Alternatively, if the first non-option argument begins with a backslash,",
    "  interpret all non-option arguments as a line of MetaPost input.",
    "",
    "  Alternatively, if the first non-option argument begins with a &, the",
    "  next word is taken as the MEM to read, overriding all else.  Any",
    "  remaining arguments are processed as above.",
    "",
    "  If no arguments or options are specified, prompt for input.",
    "",
    "-file-line-error-style   print file:line:error style messages",
    "-ini                     be inimpost, for dumping mems; this is implicitly",
    "                          true if the program name is `inimpost'",
    "-interaction=STRING      set interaction mode (STRING=batchmode/nonstopmode/",
    "                          scrollmode/errorstopmode)",
    "-jobname=STRING          set the job name to STRING",
    "-kpathsea-debug=NUMBER   set path searching debugging flags according to",
    "                          the bits of NUMBER",
    "-mem=MEMNAME             use MEMNAME instead of program name or a %& line",
    "-parse-first-line        parse of the first line of the input file",
    "-progname=STRING         set program (and mem) name to STRING",
    "-recorder                enable filename recorder",
    "-tex=TEXPROGRAM          use TEXPROGRAM for text labels.",
    "-translate-file=TCXNAME  use the TCX file TCXNAME",
    "-T, -troff               set the prologues variable, use `makempx -troff'",
    "-help                    display this help and exit",
    "-version                 output version information and exit",
    NULL
};
#endif /* MP */

#ifdef Omega
const_string OMEGAHELP[] = {
    "Usage: omega [OPTION]... [TEXNAME[.tex]] [COMMANDS]",
    "   or: omega [OPTION]... \\FIRST-LINE",
    "   or: omega [OPTION]... &FMT ARGS",
    "  Run Omega on TEXNAME, usually creating TEXNAME.dvi.",
    "  Any remaining COMMANDS are processed as Omega input, after TEXNAME is read.",
    "  If the first line of TEXNAME is %&FMT, and FMT is an existing .fmt file,",
    "  use it.  Else use `NAME.fmt', where NAME is the program invocation name,",
    "  most commonly `omega'.",
    "",
    "  Alternatively, if the first non-option argument begins with a backslash,",
    "  interpret all non-option arguments as a line of Omega input.",
    "",
    "  Alternatively, if the first non-option argument begins with a &, the",
    "  next word is taken as the FMT to read, overriding all else.  Any",
    "  remaining arguments are processed as above.",
    "",
    "  If no arguments or options are specified, prompt for input.",
    "",
    "-file-line-error-style   print file:line:error style messages",
    "-ini                     be iniomega, for dumping formats; this is implicitly",
    "                          true if the program name is `iniomega'",
    "-interaction=STRING      set interaction mode (STRING=batchmode/nonstopmode/",
    "                          scrollmode/errorstopmode)",
#ifdef IPC
    "-ipc                     send DVI output to a socket as well as the usual",
    "                          output file",
    "-ipc-start               as -ipc, and also start the server at the other end",
#endif /* IPC */
    "-jobname=STRING          set the job name to STRING",
    "-kpathsea-debug=NUMBER   set path searching debugging flags according to",
    "                          the bits of NUMBER",
    "[-no]-mktex=FMT          disable/enable mktexFMT generation (FMT=tex/tfm)",
    "-oft=FMTNAME             use FMTNAME instead of program name or a %& line",
    "-output-comment=STRING   use STRING for DVI file comment instead of date",
    "-parse-first-line        parse of the first line of the input file",
    "-progname=STRING         set program (and fmt) name to STRING",
    "-recorder                enable filename recorder (always on)",
    "-shell-escape            enable \\write18{SHELL COMMAND}",
    "-src-specials            insert source specials into the DVI file",
    "-src-specials=WHERE      insert source specials in certain places of",
    "                          the DVI file. WHERE is a comma-separated value",
    "                          list: cr display hbox math par parend vbox",
    "-help                    display this help and exit",
    "-version                 output version information and exit",
    NULL
};
#endif /* Omega */

#ifdef pdfTeX
const_string PDFTEXHELP[] = {
    "Usage: pdftex [OPTION]... [TEXNAME[.tex]] [COMMANDS]",
    "   or: pdftex [OPTION]... \\FIRST-LINE",
    "   or: pdftex [OPTION]... &FMT ARGS",
    "  Run pdfTeX on TEXNAME, usually creating TEXNAME.pdf.",
    "  Any remaining COMMANDS are processed as pdfTeX input, after TEXNAME is read.",
    "  If the first line of TEXNAME is %&FMT, and FMT is an existing .fmt file,",
    "  use it.  Else use `NAME.fmt', where NAME is the program invocation name,",
    "  most commonly `pdftex'.",
    "",
    "  Alternatively, if the first non-option argument begins with a backslash,",
    "  interpret all non-option arguments as a line of pdfTeX input.",
    "",
    "  Alternatively, if the first non-option argument begins with a &, the",
    "  next word is taken as the FMT to read, overriding all else.  Any",
    "  remaining arguments are processed as above.",
    "",
    "  If no arguments or options are specified, prompt for input.",
    "",
    "-file-line-error-style   print file:line:error style messages",
    "-fmt=FMTNAME             use FMTNAME instead of program name or a %& line",
    "-ini                     be pdfinitex, for dumping formats; this is implicitly",
    "                          true if the program name is `pdfinitex'",
    "-interaction=STRING      set interaction mode (STRING=batchmode/nonstopmode/",
    "                          scrollmode/errorstopmode)",
#ifdef IPC
    "-ipc                     send DVI output to a socket as well as the usual",
    "                          output file",
    "-ipc-start               as -ipc, and also start the server at the other end",
#endif /* IPC */
    "-jobname=STRING          set the job name to STRING",
    "-kpathsea-debug=NUMBER   set path searching debugging flags according to",
    "                          the bits of NUMBER",
    "[-no]-mktex=FMT          disable/enable mktexFMT generation (FMT=tex/tfm)",
    "-output-comment=STRING   use STRING for PDF file comment instead of date",
    "-parse-first-line        parse of the first line of the input file",
    "-progname=STRING         set program (and fmt) name to STRING",
    "-recorder                enable filename recorder",
    "-shell-escape            enable \\write18{SHELL COMMAND}",
    "-src-specials            insert source specials into the DVI file",
    "-src-specials=WHERE      insert source specials in certain places of",
    "                          the DVI file. WHERE is a comma-separated value",
    "                          list: cr display hbox math par parend vbox",
    "-translate-file=TCXNAME  use the TCX file TCXNAME",
    "-help                    display this help and exit",
    "-version                 output version information and exit",
    NULL
};
#endif /* pdfTeX */

#ifdef pdfeTeX
const_string PDFETEXHELP[] = {
    "Usage: pdfetex [OPTION]... [TEXNAME[.tex]] [COMMANDS]",
    "   or: pdfetex [OPTION]... \\FIRST-LINE",
    "   or: pdfetex [OPTION]... &FMT ARGS",
    "  Run pdfeTeX on TEXNAME, usually creating TEXNAME.pdf.",
    "  Any remaining COMMANDS are processed as pdfeTeX input, after TEXNAME is read.",
    "  If the first line of TEXNAME is %&FMT, and FMT is an existing .fmt file,",
    "  use it.  Else use `NAME.efmt', where NAME is the program invocation name,",
    "  most commonly `pdfetex'.",
    "",
    "  Alternatively, if the first non-option argument begins with a backslash,",
    "  interpret all non-option arguments as a line of pdfeTeX input.",
    "",
    "  Alternatively, if the first non-option argument begins with a &, the",
    "  next word is taken as the FMT to read, overriding all else.  Any",
    "  remaining arguments are processed as above.",
    "",
    "  If no arguments or options are specified, prompt for input.",
    "",
    "-efmt=FMTNAME             use FMTNAME instead of program name or a %& line",
    "-file-line-error-style   print file:line:error style messages",
    "-ini                     be pdfeinitex, for dumping formats; this is implicitly",
    "                          true if the program name is `pdfeinitex'",
    "-interaction=STRING      set interaction mode (STRING=batchmode/nonstopmode/",
    "                          scrollmode/errorstopmode)",
#ifdef IPC
    "-ipc                     send DVI output to a socket as well as the usual",
    "                          output file",
    "-ipc-start               as -ipc, and also start the server at the other end",
#endif /* IPC */
    "-jobname=STRING          set the job name to STRING",
    "-kpathsea-debug=NUMBER   set path searching debugging flags according to",
    "                          the bits of NUMBER",
    "[-no]-mktex=FMT          disable/enable mktexFMT generation (FMT=tex/tfm)",
    "-output-comment=STRING   use STRING for PDF file comment instead of date",
    "-parse-first-line        parse of the first line of the input file",
    "-progname=STRING         set program (and fmt) name to STRING",
    "-recorder                enable filename recorder",
    "-shell-escape            enable \\write18{SHELL COMMAND}",
    "-src-specials            insert source specials into the DVI file",
    "-src-specials=WHERE      insert source specials in certain places of",
    "                          the DVI file. WHERE is a comma-separated value",
    "                          list: cr display hbox math par parend vbox",
    "-translate-file=TCXNAME  use the TCX file TCXNAME",
    "-help                    display this help and exit",
    "-version                 output version information and exit",
    NULL
};
#endif /* pdfeTeX */

#ifdef TeX
const_string TEXHELP[] = {
    "Usage: tex [OPTION]... [TEXNAME[.tex]] [COMMANDS]",
    "   or: tex [OPTION]... \\FIRST-LINE",
    "   or: tex [OPTION]... &FMT ARGS",
    "  Run TeX on TEXNAME, usually creating TEXNAME.dvi.",
    "  Any remaining COMMANDS are processed as TeX input, after TEXNAME is read.",
    "  If the first line of TEXNAME is %&FMT, and FMT is an existing .fmt file,",
    "  use it.  Else use `NAME.fmt', where NAME is the program invocation name,",
    "  most commonly `tex'.",
    "",
    "  Alternatively, if the first non-option argument begins with a backslash,",
    "  interpret all non-option arguments as a line of TeX input.",
    "",
    "  Alternatively, if the first non-option argument begins with a &, the",
    "  next word is taken as the FMT to read, overriding all else.  Any",
    "  remaining arguments are processed as above.",
    "",
    "  If no arguments or options are specified, prompt for input.",
    "",
    "-file-line-error-style   print file:line:error style messages",
    "-fmt=FMTNAME             use FMTNAME instead of program name or a %& line",
    "-ini                     be initex, for dumping formats; this is implicitly",
    "                          true if the program name is `initex'",
    "-interaction=STRING      set interaction mode (STRING=batchmode/nonstopmode/",
    "                          scrollmode/errorstopmode)",
#ifdef IPC
    "-ipc                     send DVI output to a socket as well as the usual",
    "                          output file",
    "-ipc-start               as -ipc, and also start the server at the other end",
#endif /* IPC */
    "-jobname=STRING          set the job name to STRING",
    "-kpathsea-debug=NUMBER   set path searching debugging flags according to",
    "                          the bits of NUMBER",
    "[-no]-mktex=FMT          disable/enable mktexFMT generation (FMT=tex/tfm)",
    "-mltex                   enable MLTeX extensions such as \\charsubdef",
    "-output-comment=STRING   use STRING for DVI file comment instead of date",
    "-parse-first-line        parse of the first line of the input file",
    "-progname=STRING         set program (and fmt) name to STRING",
    "-recorder                enable filename recorder",
    "-shell-escape            enable \\write18{SHELL COMMAND}",
    "-src-specials            insert source specials into the DVI file",
    "-src-specials=WHERE      insert source specials in certain places of",
    "                          the DVI file. WHERE is a comma-separated value",
    "                          list: cr display hbox math par parend vbox",
    "-translate-file=TCXNAME  use the TCX file TCXNAME",
    "-help                    display this help and exit",
    "-version                 output version information and exit",
    NULL
};
#endif /* TeX */
#endif /* TEXMFMP_HELP */
