C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       ****************
                        SUBROUTINE RESSOL
C                       *****************
C
C     -------------------------------------------------------------
     * (NDIM,NDIELE,NBCOUF,NELESF,NDMASF,NBFACE,
     *  NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL,NPOINS,NELEMS,NDMATS,
     *  NELESS,NDMASS,NELEUS,NELERC,NELEPR,NBRESS,NBRAYS,NBRAIS,
     *  NBPRIO,NBMOBS,
     *  NBCOPR,NBPHYS,NPPEL,NPOUE,NCOEMA,NBICOR,
     *  NODESF,NCOUPF,VCOUPF,
     *  NCOUPS,NFLUSS,NDIRS,NECHS,NFLUVS,NRESCS,NRAYTS,NRAYIS,
     *  NPRIOS,NMOBIL,
     *  VCOUPS,VFLUSS,VDIRS,VECHS,VFLUVS,VRESCS,VRAYTS,VRAYIS,
     *  NREFAC,NREFAL,
     *  NREFS,NREFE,COORDS,NODES,NODESS,NODEUS,NODERC,NODEPR,
     *  NANGLE,NFFLUS,VFFLUS,NBFFLU,NFECHS,VFECHS,NBFECH, 
     *  NFRESC,VFRESC,
     *  NFRAYS,VFRAYS,NELERA,
     *  NFRAIS,VFRAIS,NBFRAI,
     *  NFCOUS,VFCOUS, 
     *  NCBORS,NCBORF,BARYS,BARYF,COORDF,
     *  PHYSOL,TMPSA,TMPS,TMPSC1,TMPSC2,TMPSC3,
     *  VOLUME,SURFUS,
     *  B,DMAT,XMAT,DIAG,
     *  TRAVF,TRAV1,TRAV2,TRAV3,TRAV4,WCT,TMPMAX,TMPMIN)
C
C     ---------------------------------------------
C 
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C
C       RESOLUTION DE LA THERMIQUE DANS LE SOLIDE
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELTS DU PB (2 OU 3)            !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  NELESF   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE SURF COUPLE FLUIDE !
C !  NDMASF   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS FLUIDES SURF       !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NBCOUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NBFLUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DE TYPE FLUX!
C !  NBDIRS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DIRICHLET   !
C !  NBECHS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC CL COEF ECH    !
C !  NBFLVS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC FLUX VOLUMIQUE !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NELESS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE SURF SOLIDE        !
C !  NDMASS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS SURF SOLIDES       !
C !  NELEUS   !  E ! D  ! NBRE D'ELTS DU MAILLAGE SURF SOLIDE AVEC FLUX!
C !  NELEPR   !  E ! D  ! NBRE D'ELTS DU MAIL VOL SOLIDE PERIODIQUE    !
C !  NBRESS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC CL RESI CONTACT!
C !  NBRAYS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC RAYONNEMENT    !
C !  NBPRIO   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES PERIODIQUES         !
C !  NBMOBS   !  E ! D  ! NOMBRE DE NOEUDS EN MOUVEMENT                !
C !  NBPHYS   !  E ! D  ! NOMBRE DE VARIABLES PHYSIQUES SUR LE SOLIDE  !
C !  NCOEMA   !  E ! D  ! NOMBRE DE COEF EXTRA DIAGONAUX DES MAT ELEM  !
C !  NBICOR   !  E ! D  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !  NODESF   ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE SURF FLUIDE !
C !  NCOUPF   ! TE ! R  ! NUMEROS GLOBAUX DES NOEUDS FLUIDES COUPLES   !
C !  VCOUPF   ! TR ! M  ! VALEURS DE LA CL ENTRE FLUIDE ET SOLIDE      !
C !  NCOUPS   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS SOLIDES COUPLES   !
C !  NFLUSS   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS AVEC CL FLUX      !
C !  NDIRS    ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS AVEC CL DIRICHLET !
C !  NECHS    ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS AVEC CL COEFF ECH !
C !  NFLUVS   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS AVEC FLUX VOLUM   !
C !  NMOBIL   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS EN MOUVEMENT      !
C !  VRESCS   ! TR ! M  ! VALEURS DE LA CL DE TYPE RESIST DE CONTACT   !
C !  VRAYTS   ! TR ! M  ! VALEURS DE LA CL DE TYPE RAYONNEMENT         !
C !   NFFLUS  ! TE ! D  ! No de facette flux ---> face glob            !
C !   VFFLUS  ! TR ! D  ! Valeur des flux a chaque point de la face    !
C !   NBFFLU  ! E  ! D  ! Nombre de facette de type flux               ! 
C !   NFECHS  ! TE ! D  ! No de facette echange ---> face glob         !
C !   VFECHS  ! TR ! D  ! Valeur des echan aux points de la face       !
C !   NBFECH  ! E  ! D  ! Nombre de facette de type echange            ! 
C !   NFRESC  ! TE ! D  ! No de facette resistance ---> face glob      !
C !   VFRESC  ! TR ! D  ! Valeur des resista aux points de la face     !
C !   NELERC  ! E  ! D  ! Nombre de facette de type resistance         ! 
C !   NFRAYS  ! TE ! D  ! No de facette rayonnement ---> face glob     !
C !   VFRAYS  ! TR ! D  ! Valeur du rayo aux points de la face         !
C !   NELERA  ! E  ! D  ! Nombre de facette de type rayonnement        ! 
C !   NFCOUS  ! TE ! D  ! No de facette couplee ---> face glob         !
C !   VFCOUS  ! TR ! D  ! Valeur du couplage aux points de la face     !
C !   NELESS  ! E  ! D  ! Nombre de facette de type couplee            ! 
C !  NREFS    ! TR ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  COORDS   ! TR ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE SOLIDE    !
C !  NODES    ! TE ! D  ! TABLEAU DE CONNECTIVITE MAILLAGE SOLIDE      !
C !  NODESS   ! TE ! D  ! TABLEAU DE CONNECTIVITE MAILLAGE SURF SOLIDE !
C !  NODEUS   ! TE ! D  ! CONNECTIVITE NOEUDS AVEC CL TYPE FLUX (SOL)  !
C !  NODERC   ! TE ! M  ! CONNECTIVITE NOEUDS AVEC CL TYPE RES CONTACT !
C !  NCBORS   ! TE ! M  ! NUMERO DE L'ELEMENT FLUIDE CORRESPONDANT     !
C !  NCBORF   ! TE ! M  ! NUMERO DE L'ELEMENT SOLIDE CORRESPONDANT     !
C !  BARYS    ! TR ! M  ! COORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! SOLIDES DANS LES ELEMENTS FLUIDES            !
C !  BARYF    ! TR ! M  ! COORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! FLUIDES DANS LES ELEMENTS SOLIDES            !
C !  PHYSOL   ! TR ! M  ! PROPRIETES PHYSIQUES DU SOLIDE               !
C !  TMPSA    ! TR ! M  ! TEMPERATURE DANS LE SOLIDE ETAPE n           !
C !  TMPS     ! TR ! M  ! TEMPERATURE DANS LE SOLIDE ETAPE n+1         !
C !  TMPSC1   ! TR ! M  ! MODELE COQUE : TEMPERATURE COMPOSANTE 1      !
C !  TMPSC2   ! TR ! M  ! MODELE COQUE : TEMPERATURE COMPOSANTE 2      !
C !  TMPSC3   ! TR ! M  ! MODELE COQUE : TEMPERATURE COMPOSANTE 3      !
C !  VOLUME   ! TR ! R  ! SURFACE DU TRIANGLE EN 2D                    !
C !           !    !    ! VOLUME DU TETRAEDRE EN 3D                    !
C !  SURFUS   ! TR ! R  ! EN 3D SURFACE DU TRIANGLE DE BORD (flux)     !
C !           !    !    ! EN 2D LONGUEUR DU SEGMENT DE BORD (flux)     !
C !  B        ! TR ! M  ! Seccond membrede l'equation                  !
C !  DMAT     ! TR ! M  ! Diagonale de la matrice complete (mass+diff) !
C !  XMAT     ! TR ! M  ! Termes extra-diagonaux de la mat de diffusion!
C !  DIAG     ! TR ! M  ! Diagonale inverse de la mat complete         !
C !TRAV1-TRAV4! TR ! A  ! TABLEAUX DE TRAVAIL                          !
C !  WCT      ! TR ! A  ! TABLEAUX DE TRAVAIL                          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     :
C
C     SOUS PROGRAMME(S) APPELE(S) :
C
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "mobil.h"
#include "divct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "syrthu.h"
#include "bilan.h"
C
C **********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NDIELE,NBCOUF,NELESF,NDMASF,NBFACE
      INTEGER NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL
      INTEGER NPOINS,NELEMS,NDMATS
      INTEGER NELESS,NELEUS,NDMASS,NELERC,NELEPR,NBRESS
      INTEGER NBPRIO,NBCOPR,NBMOBS
      INTEGER NBPHYS,NPPEL,NPOUE,NCOEMA,NBICOR
      INTEGER NBFFLU,NBFECH
      INTEGER NFFLUS(NBFFLU),NFECHS(NBFECH),NFRESC(NELERC)
      INTEGER NFCOUS(NELESS)
C
      INTEGER NBRAYS,NBRAIS
      INTEGER NELERA,NBFRAI
      INTEGER NFRAYS(NELERA),NFRAIS(NBFRAI)
      INTEGER NRAYTS(NBRAYS),NRAYIS(NBRAIS)
C
      INTEGER NCOUPF(NBCOUF,2),NODESF(NELESF,NDMASF)
      INTEGER NCOUPS(NBCOUS),NFLUSS(NBFLUS),NDIRS(NBDIRS)
      INTEGER NECHS(NBECHS),NFLUVS(NBFLVS),NRESCS(NBRESS,2)
      INTEGER NPRIOS(NBPRIO,1+NBCOPR),NMOBIL(NBMOBS,2)
      INTEGER NREFAC(NELEMS,NBFACE),NREFAL(NELEUS)
      INTEGER NREFS(NPOINS),NREFE(NELEMS),NODES(NELEMS,NDMATS)
      INTEGER NODESS(NELESS,NDMASS), NODEUS(NELEUS,NDMASS)
      INTEGER NODEPR(NELEPR,NDMATS+1),NODERC(NELERC,NDMASS)
      INTEGER NCBORS(NBCOUS,NBICOR),NCBORF(NBCOUF,NBICOR)
      INTEGER NANGLE(NELEMS)
C
      DOUBLE PRECISION VFFLUS(NBFFLU,NDMASS),VFECHS(NBFECH,NDMASS,2)
      DOUBLE PRECISION VFRESC(NELERC,NDMASS,2)
      DOUBLE PRECISION VFCOUS(NELESS,NDMASS,2)
C
      DOUBLE PRECISION VRAYTS(NBRAYS,2),VRAYIS(NBRAIS,2)
      DOUBLE PRECISION VFRAYS(NELERA,NDMASS,2),VFRAIS(NBFRAI,NDMASS,2)
C
      DOUBLE PRECISION COORDF(NBCOUF,NDIM),VCOUPF(NBCOUF,2)
      DOUBLE PRECISION VCOUPS(NBCOUS,2),VFLUSS(NBFLUS),VDIRS(NBDIRS)
      DOUBLE PRECISION VECHS(NBECHS,2),VFLUVS(NBFLVS,NPFEL)
      DOUBLE PRECISION VRESCS(NBRESS,2)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)
      DOUBLE PRECISION BARYF(NBCOUF,NDIM), BARYS(NBCOUS,NDIM)
      DOUBLE PRECISION PHYSOL(NPOUE,NPPEL,NBPHYS)
      DOUBLE PRECISION TMPSC1(NPOINS),TMPSC2(NPOINS),TMPSC3(NPOINS)
      DOUBLE PRECISION TMPSA(NPOINS), TMPS(NPOINS)
      DOUBLE PRECISION VOLUME(NELEMS),SURFUS(NELEUS)
      DOUBLE PRECISION B(NPOINS),DMAT(NPOINS),XMAT(NELEMS,NCOEMA)
      DOUBLE PRECISION DIAG(NPOINS),TMPMAX(NPOINS),TMPMIN(NPOINS)
C
C     Tableaux de travail
      DOUBLE PRECISION TRAV1(NPOINS),TRAV2(NPOINS)
      DOUBLE PRECISION TRAV3(NPOINS),TRAV4(NPOINS)
      DOUBLE PRECISION TRAVF(NELEUS,NDMASS)
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
      DOUBLE PRECISION TX,TY,TZ
C
C..Variables Internes
      INTEGER N,MODE,NG,NB,NUMA,NPMAX,NPMIN,NPTMAX,NPTMIN,ITMIN,ITMAX
      INTEGER I,NBSCAL
      DOUBLE PRECISION COEF,TMIN,TMAX,TTMIN,TTMAX,TTTMIN,TTTMAX
      LOGICAL LF
C
      DATA NPTMAX /0/
      DATA NPTMIN /0/
      DATA TTMIN  /1.e8/
      DATA TTMAX  /0./
      DATA ITMIN /0/
      DATA ITMAX /0/
      DATA TTTMIN /0./
      DATA TTTMAX /0./
C
C***********************************************************************
C
C
C       MISE A JOUR DE LA TEMPERATURE
C       =============================
C
        DO 111 N=1,NPOINS
          TMPSA(N) = TMPS(N)
  111   CONTINUE
C      
C
C       0.- TRAITEMENT DES SOLIDES MOBILES
C       ==================================
C
        IF (NBMOBS.GT.0) THEN
C
           CALL MOBROT (NDIM,NPOINS,NBMOBS,NMOBIL,COORDS)
C
           CALL MOBCOR (NDIM,NPOINS,NELESS,NDMASS,NELESF,NDMASF,
     *                  NBCOUS,NBCOUF,COORDS,NODESS,COORDF,NODESF,
     *                  BARYF,NCBORF,BARYS,NCBORS,NCOUPS,NCOUPF,NBICOR)
        ENDIF
C
        IF (LSDEPL) THEN
C
           COEF = VTRMOB * RDTTS / TRNMOB
           TX = TRXMOB * COEF
           TY = TRYMOB * COEF
           TZ = TRZMOB * COEF
C
           NUMA = -1
           CALL MOBTRA (NUMA,NDIM,NPOINS,COORDS,TX,TY,TZ)
C
           CALL MOBCOR (NDIM,NPOINS,NELESS,NDMASS,NELESF,NDMASF,
     *                  NBCOUS,NBCOUF,COORDS,NODESS,COORDF,NODESF,
     *                  BARYF,NCBORF,BARYS,NCBORS,NCOUPS,NCOUPF,NBICOR)
C
           CALL MOBTMX (NBCOUS,NBICOR,NCBORS,NCOUPS,NUMA)
C          Si NUMA=0 --> rien a faire, sinon decaler le maillage NUMA
C
           IF (NUMA.NE.0) THEN
             CALL MOBTRA (NUMA,NDIM,NPOINS,COORDS,
     *                   -2.*TRXMOB,-2.*TRYMOB,-2.*TRZMOB)
C
             CALL MOBTMP (NUMA,NDIM,NPOINS,TMPSA,TMPS)
C
             CALL MOBCOR (NDIM,NPOINS,NELESS,NDMASS,NELESF,NDMASF,
     *                    NBCOUS,NBCOUF,COORDS,NODESS,COORDF,NODESF,
     *                    BARYF,NCBORF,BARYS,NCBORS,NCOUPS,NCOUPF,
     *                    NBICOR)
C
             CALL CORESC (NDIM,NPOINS,NBRESS,NRESCS,COORDS)
C
             CALL MOBRES (NPOINS,NBRESS,NRESCS,VRESCS,NREFS,
     *                    NODERC,NFRESC,VFRESC,NELERC,NDMASS,
     *                    NREFAL,NELEUS,TRAV1)
           ENDIF
C
        ENDIF
C
C       1- MISE A JOUR DES PROPRIETES PHYSIQUES
C       =======================================
C
        CALL CPHYSO (NDIM,NPOINS,COORDS,NREFS,NREFE,NELEMS,
     &               NODES,NDMATS,TMPSA,TMPS,
     &               PHYSOL,NPOUE,NPPEL,NBPHYS,VOLUME)
C
        CALL FLUSHF(NFECRA)
C
C       2- MISE A JOUR DES FLUX VOLUMIQUES
C       ==================================
C
        IF (NBFLVS.GT.0)
     &    CALL CFLUVS (NDIM,NPOINS,COORDS,NREFS,NREFE,NELEMS,
     &                 NODES,NDMATS,TMPSA,TMPS,
     &                 NBFLVS,NPFEL,NFLUVS,VFLUVS)
C
C       2.1- Mise em place d'une regulation thermique
C       =============================================
        IF (NBFLVS.GT.0 .AND. LREGUL)
     *    CALL REGUSY (NDIM,NPOINS,COORDS,NREFS,NREFE,NELEMS,
     *                 NODES,NDMATS,TMPSA,TMPS,
     *                 NBFLVS,NPFEL,NFLUVS,VFLUVS,
     *                 PHYSOL,NPOUE,NPPEL,NBPHYS)
C
C       3- CALCUL DES CONDITIONS AUX LIMITES POUR LE SOLIDE
C       ===================================================
C
C
C       3.0- MISE A JOUR DE LA "TEMPERATURE EXTERIEURE" POUR LES
C            RESISTANCES DE CONTACT
C       --------------------------------------------------------
        IF (NBRESS.GT.0 .OR. NELERC.GT.0) 
     &      CALL LIMRES(NDIM,NPOINS,NBRESS,NRESCS,VRESCS,
     &                  NODERC,VFRESC,NELERC,NDMASS,TMPSA,TRAV1)
C
C
C       3.1- MISE A JOUR DES CONDITIONS VARIABLES F(x,y,z,t,T)
C       ------------------------------------------------------
C
        IF (LCFACE) THEN
         CALL LIMFSO (NDIM,NPOINS,NELEMS,NDMATS,
     *                NREFS,COORDS,NODES,TMPSA,TMPS,
     *                NELEUS,NDMASS,NODEUS,NREFAL,
     *                NBFFLU,NFFLUS,VFFLUS,NBDIRS,NDIRS,VDIRS,
     *                NBFECH,NFECHS,VFECHS,
     *                NBFRAI,NFRAIS,VFRAIS,NELERC,NFRESC,VFRESC)
        ELSE
         CALL LIMSOL (NDIM,NPOINS,NELEMS,NDMATS,NREFS,COORDS,NODES,
     &                TMPSA,TMPS,
     &                NBFLUS,NFLUSS,VFLUSS,NBDIRS,NDIRS,VDIRS,
     &                NBECHS,NECHS,VECHS,
     &                NBRAIS,NRAYIS,VRAYIS,NBRESS,NRESCS,VRESCS)
        ENDIF
C
        CALL FLUSHF(NFECRA)
C
C       3.3- PASSAGE DU FLUX SUR LES POINTS CORRESPONDANTS DU SOLIDE
C       ------------------------------------------------------------
C
        IF (NBCOUS.GT.0) THEN
          MODE = 2
          IF (LCOIN) THEN
             CALL PSFCOI (MODE,
     &                    NDIM,NBCOUF,VCOUPF,NBCOUS,VCOUPS,
     &                    NELESF,NDMASF,NODESF,NELESS,NDMASS,NODESS,
     &                    NBICOR,NCBORF,NCBORS)
          ELSE
            IF (NDIM .EQ. 2) THEN
               CALL PSFNC2 (MODE,
     &                      NDIM,NBCOUF,VCOUPF,NBCOUS,VCOUPS,
     &                      NELESF,NDMASF,NODESF,NELESS,NDMASS,NODESS,
     &                      NBICOR,BARYF,NCBORF,BARYS,NCBORS)
            ELSE
               CALL PSFNC3 (MODE,
     &                      NDIM,NBCOUF,VCOUPF,NBCOUS,VCOUPS,
     &                      NELESF,NDMASF,NODESF,NELESS,NDMASS,NODESS,
     &                      NBICOR,BARYF,NCBORF,BARYS,NCBORS)
            ENDIF
          ENDIF
        ENDIF
C
C
C
C       3.5- COND LIM PAR FACES : REMPLISSAGE DE VFCOUS
C       -----------------------------------------------
        IF (NBCOUS.GT.0) THEN
          IF (LCFACE) 
     &       CALL PSSCLF (NBCOUS,VCOUPS,NELESS,NDMASS,VFCOUS,NODESS)
        ENDIF
C
        CALL FLUSHF(NFECRA)
C
C       3.6- MISE A JOUR DES CL DANS LE CAS DES SOLIDES MOBILES
C       --------------------------------------------------------
        IF (NBMOBS.GT.0 .OR. LSDEPL) 
     &      CALL MOBLIM (NDIM,NPOINS,NBCOUS,NBICOR,
     &                   NCOUPS,NCBORS,VCOUPS,NREFS,COORDS,
     &                   NODESS,VFCOUS,NELESS,NDMASS)
C
C
C       4- RESOLUTION DE LA DIFFUSION SOLIDE
C       ====================================
C
        CALL DIFSOL (TMPS,TMPSA,B,DMAT,XMAT,PHYSOL,
     &               COORDS,NODES,NODEUS,NFLUVS,VFLUVS,NDIRS,VDIRS,
     &               NCOUPS,VCOUPS,NFLUSS,VFLUSS,NECHS,VECHS,
     &               NODERC,NODEPR,NPRIOS,NRESCS,VRESCS,
     &               NRAYTS,VRAYTS,NBRAYS,
     &               NRAYIS,VRAYIS,NBRAIS,
     &               VOLUME,SURFUS,DIAG,
     &               NELEMS,NPOINS,NDIM,NDIELE,NDMATS,NDMASS,NCOEMA,
     &               NPOUE,NPPEL,NBPHYS,
     &               NELEUS,NELERC,NELEPR,
     &               NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL,NBRESS, 
     &               NBPRIO,NBCOPR,
     &               NFFLUS,VFFLUS,NBFFLU,NFECHS,VFECHS,NBFECH, 
     &               NFRESC,VFRESC,
     &               NFRAYS,VFRAYS,NELERA,
     &               NFRAIS,VFRAIS,NBFRAI,
     &               NFCOUS,VFCOUS,NELESS,NANGLE,TRAVF,
     &               TRAV1,TRAV2,TRAV3,TRAV4,WCT)
C
C
C
C       5- ECRITURES SUR LA PEAU DU FLUIDE (avant de les ecraser)
C       =========================================================
      IF (NCHROS.GE.1 .AND. LCHROF .AND.
     *    (MOD ((NTSYR-NTSYRD),NCHROS).EQ.0 .OR.
     *    (MOD ((NTSYR-NTSYRD),NCHROS).NE.0 .AND. 
     *                   (LDERN.OR.LSTOPS) )) ) THEN
            NBSCAL=2
            CALL ECRG2E(NBSCAL,NFCFCT,NDIM,NDIM-1,NELESF,NBCOUF) 
            CALL ECRG3E(NFCFCT) 
            CALL ECRG2R(VCOUPF(1,1),NBCOUF,'T_PEAU_FLUID','3',NFCFCT)
            CALL ECRG2R(VCOUPF(1,2),NBCOUF,'COEF_ECHANGE','3',NFCFCT)
        ENDIF
C
        IF ((LDERN.OR.LSTOPS) .AND. LRESUF) THEN
            CALL ECRG3E(NFRFCT) 
            CALL ECRG2R(VCOUPF(1,1),NBCOUF,'T_PEAU_FLUID','3',NFRFCT)
            CALL ECRG2R(VCOUPF(1,2),NBCOUF,'COEF_ECHANGE','3',NFRFCT)
        ENDIF
C
C
C       6- PASSAGE DE LA TEMPERATURE DU SOLIDE VERS LE FLUIDE
C       =====================================================
C
        DO 611 N=1,NBCOUS
           NG = NCOUPS(N)
           VCOUPS(N,1) = TMPS(NG)
  611   CONTINUE
C
        IF  (NBCOUS.GT.0) THEN
          MODE = 1
          IF (LCOIN) THEN
             CALL PSFCOI (MODE,
     &                    NDIM,NBCOUF,VCOUPF,NBCOUS,VCOUPS,
     &                    NELESF,NDMASF,NODESF,NELESS,NDMASS,NODESS,
     &                    NBICOR,NCBORF,NCBORS)
          ELSE
            IF (NDIM .EQ. 2) THEN
               CALL PSFNC2 (MODE,
     &                      NDIM,NBCOUF,VCOUPF,NBCOUS,VCOUPS,
     &                      NELESF,NDMASF,NODESF,NELESS,NDMASS,NODESS,
     &                      NBICOR,BARYF,NCBORF,BARYS,NCBORS)
            ELSE
               CALL PSFNC3 (MODE,
     &                      NDIM,NBCOUF,VCOUPF,NBCOUS,VCOUPS,
     &                      NELESF,NDMASF,NODESF,NELESS,NDMASS,NODESS,
     &                      NBICOR,BARYF,NCBORF,BARYS,NCBORS)
            ENDIF
          ENDIF
        ENDIF
C
C
C     Temperature max
C     ---------------
      IF (LTMAX) THEN
        DO N=1,NPOINS
          IF (TMPS(N).GT.TMPMAX(N)) TMPMAX(N)=TMPS(N)
          IF (TMPS(N).LT.TMPMIN(N)) TMPMIN(N)=TMPS(N)
        ENDDO
      ENDIF

C     1- Ecriture sur fichiers chronologiques
C     ========================================
      LF = LCFACE
C
      IF (NCHROS.GE.1 .AND. 
     *    (MOD ((NTSYR-NTSYRD),NCHROS).EQ.0 .OR.
     *    (MOD ((NTSYR-NTSYRD),NCHROS).NE.0 .AND. 
     *                   (LDERN.OR.LSTOPS) )) ) THEN
C
         NBSCAL=1
         IF (LTMAX)  NBSCAL = NBSCAL+2
         CALL ECRG2E(NBSCAL,NFGCCT,NDIM,NDIELE,NELEMS,NPOINS) 
         CALL ECRG3E(NFGCCT) 
         CALL ECRG2R(TMPS,NPOINS,'TEMP_SOLIDE ','3',NFGCCT)
         CALL FLUSHF(NFGCCT)
C
      ENDIF
C
C     2- Ecriture sur fichier resultat
C     ================================
      IF (LDERN.OR.LSTOPS) THEN
        CALL ECRG3E(NFGRCT)
        CALL ECRG2R(TMPS,NPOINS,'TEMP_SOLIDE ','3',NFGRCT)
        IF (LTMAX) THEN
         CALL ECRG2R(TMPMIN,NPOINS,'TEMP_MIN    ','3',NFGRCT)
         CALL ECRG2R(TMPMAX,NPOINS,'TEMP_MAX    ','3',NFGRCT)
        ENDIF
      ENDIF
C
C
C     3- ECRITURE DES HISTORIQUES EN TEMPS
C     ====================================
      IF (LHISOL .AND. (TEMPSS - THISSO .GE. XFREQS) ) THEN
          THISSO = THISSO + XFREQS
          CALL WHISOL (NDIM,NPOINS,COORDS,TMPSA,TMPS)
      ENDIF
C
C     4- MIN-MAX DU CHAMP
C     ===================
C
      TMIN=1.e8
      TMAX=-273.
      NPMIN=0
      NPMAX=0
      DO N=1,NPOINS
        IF (TMPS(N).GT.TMAX) THEN
           TMAX=TMPS(N)
           NPMAX=N
        ENDIF
        IF (TMPS(N).LT.TMIN) THEN
           TMIN=TMPS(N)
           NPMIN=N
        ENDIF
      ENDDO
      WRITE(NFECRA,5000) TMIN,NPMIN,TMAX,NPMAX
      IF (TMAX.GT.TTMAX) THEN
        TTMAX=TMAX
        ITMAX=NTSYR
        TTTMAX=TEMPSS
        NPTMAX=NPMAX
      ENDIF
      IF (TMIN.LT.TTMIN) THEN
        TTMIN=TMIN
        ITMIN=NTSYR
        TTTMIN=TEMPSS
        NPTMIN=NPMIN
      ENDIF
      IF (LDERN) THEN
         IF (NDIM.EQ.2) THEN
           WRITE(NFECRA,5010) 
     *       TTMIN,TTTMIN,ITMIN,NPTMIN,
     *       COORDS(NPTMIN,1),COORDS(NPTMIN,2),
     *       TTMAX,TTTMAX,ITMAX,NPTMAX,
     *       COORDS(NPTMAX,1),COORDS(NPTMAX,2)
         ELSE
           WRITE(NFECRA,5011) 
     *       TTMIN,TTTMIN,ITMIN,NPTMIN,
     *       COORDS(NPTMIN,1),COORDS(NPTMIN,2),COORDS(NPTMIN,3),
     *       TTMAX,TTTMAX,ITMAX,NPTMAX,
     *       COORDS(NPTMAX,1),COORDS(NPTMAX,2),COORDS(NPTMAX,3)
        ENDIF
      ENDIF
C
C
C     5- BILANS DU FLUX 
C     =================
      IF (NBILAS.GT.0) THEN
        CALL BILFLU (NFFLUS,VFFLUS,NBFFLU,NFECHS,VFECHS,NBFECH, 
     *               NFRESC,VFRESC,NELERC,
     *               NFRAYS,VFRAYS,NELERA,
     *               NFRAIS,VFRAIS,NBFRAI,
     *               NFCOUS,VFCOUS,NELESS,
     *               TMPSA,NODEUS,SURFUS, 
     *               NPOINS,NDIM,NELEUS,NDMASS,NREFAL,COORDS)
      ENDIF

      IF (NBILAV.GT.0) THEN
        CALL BILFLV (NREFE,NELEMS,NBFLVS,NPFEL,NFLUVS,VFLUVS,VOLUME,
     *               NPOINS,NDIM,COORDS,NDMATS,NODES)
      ENDIF
C
C     6- UTILISATEUR
C     ==============
      CALL AFAIRE ( NFFLUS,VFFLUS,NBFFLU,NFECHS,VFECHS,NBFECH, 
     *              NFRESC,VFRESC,NELERC,
     *              NFRAYS,VFRAYS,NELERA,
     *              NFRAIS,VFRAIS,NBFRAI,
     *              NFCOUS,VFCOUS,NELESS,
     *              NFLUVS,VFLUVS,NBFLVS,NPFEL,
     *              TMPSA,NODEUS,SURFUS,VOLUME,
     *              NPOINS,NDIM,NELEUS,NDMASS,NREFAL,COORDS,
     *              NREFE,NELEMS,NDMATS,NODES,NODESS)

C
C--------
C FORMATS
C--------
C
 4000 FORMAT(/,'IL Y A UNE INCOHERENCE ENTRE : ',/,
     *         'TRAITEMENT PAR FACE OU NOEUD ET LA ',
     *         'DEFINITION DES PROPRIETES PHYSIQUES',I2)
 5000 FORMAT(/,' -> Temperature min :',F12.5,' noeud ',I8,
     * ' -- Temperature max :',F12.5,' noeud ',I8)
 5010 FORMAT(//,78('='),//,
     *   5X,'Temperature minimale atteinte : ',F12.5,/,
     *   5X,'     - au temps               : ',E12.5,/,
     *   5X,'     - a l''iteration          : ',I12,/,
     *   5X,'     - au noeud               : ',I12,/,
     *   5X,'     - coordonnees            : ',2(F12.5,1X),//,
     *   5X,'Temperature maximale atteinte : ',F12.5,/,
     *   5X,'     - au temps               : ',E12.5,/,
     *   5X,'     - a l''iteration          : ',I12,/,
     *   5X,'     - au noeud               : ',I12,/,
     *   5X,'     - coordonnees            : ',2(F12.5,1X))
 5011 FORMAT(//,78('='),//,
     *   5X,'Temperature minimale atteinte : ',F12.5,/,
     *   5X,'     - au temps               : ',E12.5,/,
     *   5X,'     - a l''iteration          : ',I12,/,
     *   5X,'     - au noeud               : ',I12,/,
     *   5X,'     - coordonnees            : ',3(F12.5,1X),//,
     *   5X,'Temperature maximale atteinte : ',F12.5,/,
     *   5X,'     - au temps               : ',E12.5,/,
     *   5X,'     - a l''iteration          : ',I12,/,
     *   5X,'     - au noeud               : ',I12,/,
     *   5X,'     - coordonnees            : ',3(F12.5,1X))
C
C----
C FIN
C----
C
      END


