C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LRASY3
C                       *****************
C
C      -----------------------------------------
     * (NDIM,NPOINR,NELRAY,NODRAY,NRFRAY,COORAY)
C      ------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             LECTURE DU MAILLAGE ELEMENTS FINIS                       *
C             STRUCTURE DE DONNEE ISSUE DE SYRTHES                     *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (3     )               !
C !  NPOINR   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE RAYONNEMENT     !
C !  NELRAY   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE RAYONNEMENT        !
C !  NODRAY   ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE RAYONNEMENT !
C !  NRFRAY   ! TE ! R  ! TABLEAU DES REFERENCES ELTS MAILLAGE RAYT    !
C !  COORAY   ! TR ! R  ! COORD DES NOEUDS DU MAILLAGE RAYONNEMENT     !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C ! /MOBIL/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NELRAY,NPOINR,NDIM
      INTEGER NODRAY(NELRAY,NDIM),NRFRAY(NELRAY)
      DOUBLE PRECISION  COORAY(NPOINR,NDIM)
C
C.. Variables internes
      INTEGER N,I,J,N1,NBNO,IERR
      CHARACTER CH1*7
      LOGICAL LF
C
C***********************************************************************
C
C
      NBNO = NDIM
C
C     2- LECTURE DE LA TABLE DES NOEUDS
C     =================================
C
C     2.1- Recherche de la rubrique contenant la table des noeuds
C     -----------------------------------------------------------
      IERR = 0
      CALL SECGRF(NFSGRA,'C$ RUBRIQUE = NOEUDS',20,IERR)
      IF (IERR.NE.0) THEN
         WRITE(NFECRA,2100)
         STOP
      ENDIF
C
C     2.2- Coordonnees et references
C     ------------------------------
      DO 220 N=1,NPOINR
       READ(NFSGRA,2200) CH1,N1,(COORAY(N,J),J=1,NDIM)
  220 CONTINUE
C
C
C     3- TABLE DES ELEMENTS
C     =====================
C
C     3.1- Recherche de la rubrique contenant la table des noeuds
C     -----------------------------------------------------------
      IERR = 0
      CALL SECGRF(NFSGRA,'C$ RUBRIQUE = ELEMENTS',22,IERR)
      IF (IERR.NE.0) THEN
         WRITE(NFECRA,3100)
         STOP
      ENDIF
C
C     3.2- Lecture des elements
C     -------------------------
C
      DO N=1,NELRAY
         READ(NFSGRA,3200) N1,NRFRAY(N),(NODRAY(N,I),I=1,NBNO)
      ENDDO
C
C
C     5- IMPRESSION SUR LISTING
C     =========================
C
      IF (NBLBLR.GT.0) THEN
        WRITE(NFECRA,5000)
        WRITE(NFECRA,5010) NDIM,NPOINR,NELRAY
      ENDIF
C
C
C     6- VERIFICATION DU MAILLAGE LU
C     ==============================
C
      IF (NBLBLR.GE.2) THEN
C
      WRITE(NFECRA,6000) 
      WRITE(NFECRA,6010)
      DO 100 I=1,10
        WRITE(NFECRA,6011) I,(COORAY(I,J),J=1,NDIM)
  100 CONTINUE
C
      WRITE(NFECRA,6020)
      DO 110 I=1,10
        WRITE(NFECRA,6012)I,(NODRAY(I,J),J=1,NDIM)
 110  CONTINUE
C
      WRITE(NFECRA,6030)
      DO 120 I=1,10
        WRITE(NFECRA,6013)I,NRFRAY(I)
 120  CONTINUE
C
C
      ENDIF  
C
C--------
C FORMATS
C--------
C
 2100 FORMAT(//,' *** LRASY2 : LE FICHIER SUITE NE CONTIENT PAS LA',
     &          ' TABLE DES NOEUDS')
 2200 FORMAT(A10,I3,1X,3(E14.7,1X))
 3100 FORMAT(//,' *** LRASY2 : LE FICHIER SUITE NE CONTIENT PAS LA',
     &          ' TABLE DES ELEMENTS')
 3200 FORMAT(I10,I3,3I10)
C
 5000 FORMAT(//,' *** LRASY2 : MAILLAGE ELEMENTS FINIS DU SOLIDE :')
 5010 FORMAT(8X,'- Dimension du maillage            : ',I6,/
     &       8X,'- Nombre total de noeuds           : ',I6,/
     &       8X,'- Nombre d''elements                : ',I6)
C
 6000 FORMAT(//,' *** LRASY2 : Verification du maillage rayonnement',/)
 6010 FORMAT(//,3X,'Coordonnees des 10 premiers noeuds :',/)
 6020 FORMAT(//,3X,'Table des 10 premiers elements :',/)
 6030 FORMAT(//,3X,'References des 10 premiers noeuds :',/)
 6011 FORMAT(14X,'N=',I2,'   COORDS : ',3E12.5)
 6012 FORMAT(14X,'N=',I2,'   NOEUDS : ',4I6)
 6013 FORMAT(14X,'N=',I2,'   REFERENCE : ',I3)
C
      END
