C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECLIR
C                       *****************
C
     * ( NDIM,NELRAY,
     *   NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE,
     *   NRFRAY,NGFFIR,NGFTIR,NGFPER,NGFPEF,NGFMST,NGFMSE,
     *   EMISSI,TEMRAY,PHFRAF,PHFRAE,FIRAY,VFIRAY,VFMSTE,
     *   PHMSTP,PHMSTO)
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   LECTURE ET INTERPRETATION DU FICHIER syrthes.ray        *
C              Lecture des CL et donnees physiques pour le rayonnement *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/XREFER/!      ! D  !                                             !
C   !/NLOFES/!      ! D  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : POSCOT,POSREE,POSLIS,CCONDR,CCONQ
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "optct.h"
#include "mobil.h"
#include "xrefer.h"
#include "nlofes.h"
#include "nlofct.h"
#include "rayonn.h"
C
C**********************************************************************
C
      INTEGER NVV
      PARAMETER (NVV=12)
C
C..Variables externes
      INTEGER NDIM,NELRAY
      INTEGER NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE
      INTEGER NRFRAY(NELRAY)
      INTEGER NGFFIR(NFFIRA),NGFTIR(NFTIRA)
      INTEGER NGFPER(NFPERA),NGFPEF(NFCFRA)
      INTEGER NGFMST(NFMST,2),NGFMSE(NFMSTE)
      DOUBLE PRECISION EMISSI(NELRAY,2,NBANDE)
      DOUBLE PRECISION PHFRAF(NFCFRA,4),PHFRAE(NFPERA,4)
      DOUBLE PRECISION TEMRAY(NELRAY),FIRAY(NELRAY,NBANDE)
      DOUBLE PRECISION VFIRAY(NFFIRA,NBANDE,2),VFMSTE(NFMSTE,2)
      DOUBLE PRECISION PHMSTP(NFMST,4),PHMSTO(NFMST,5,NBANDE)
C
C..Variables internes
      INTEGER I,I1,I2,N,LCH,II1,II2,NB,NPS,NBAN
      INTEGER ITAB(NRFMAX)
      CHARACTER*200 CHAINE,FORMA
      LOGICAL ERR
      DOUBLE PRECISION EPSBDE,XLBDA1,XLBDA2,EMILBD,XNUMBA
      DOUBLE PRECISION VALEQ(4),VALEQ2(6)
      DOUBLE PRECISION TRIMP,XFLU,SCAPP,AAUX,XNP,APER
      DOUBLE PRECISION ANG,T,XH
      INTEGER NUMBAN,NPE
C      
C
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
      ERR = .FALSE.
      REWIND (NFCLRA)
      NPS = 0
      EPSBDE = 1E-10
      NPE = 0
      TEMINF = 20.
      NBHSOR=0
C    
C==================================================================
C
C     0.1- INITIALISATIONS DES BANDES SPECTRALES
C     ------------------------------------------
      DO N=1,NBANDE
        SPECTL(N,1) = -1.
        SPECTL(N,2) = -1.
      ENDDO
C
C     0.2- INITIALISATIONS DES CARACTERISTIQUES PHYSIQUES
C     ---------------------------------------------------
C
        DO I=1,NBANDE
           DO N=1,NELRAY
              EMISSI(N,1,I) = 1.0
              EMISSI(N,2,I) = 0.
              FIRAY(N,I) = 0.
           ENDDO
        ENDDO
C
        DO N=1,NELRAY
          TEMRAY(N) = 20.
        ENDDO
C
        DO N=1,NFCFRA
           PHFRAF(N,1) = 25.1
           PHFRAF(N,2) = 0.01
           PHFRAF(N,3) = 20.
           PHFRAF(N,4) = 0.
        ENDDO
C      
C
        DO N=1,NFPERA
           PHFRAE(N,1) = 25.1
           PHFRAE(N,2) = 0.01
           PHFRAE(N,3) = 20.
           PHFRAE(N,4) = 0.
        ENDDO
C
        DO N=1,NFMST
           PHMSTP(N,1)=7000.
           PHMSTP(N,2)=460.
           PHMSTP(N,3)=5.
           PHMSTP(N,4)=0.005
        ENDDO
C
        DO I=1,NBANDE
           DO N=1,NFMST
              PHMSTO(N,1,I)=0.8
              PHMSTO(N,2,I)=0.2
              PHMSTO(N,3,I)=0.
              PHMSTO(N,4,I)=50.
              PHMSTO(N,5,I)=1.5
           ENDDO
        ENDDO
C      
        DO I=1,NFMSTE
         VFMSTE(I,1)=20.
         VFMSTE(I,2)=0.
        ENDDO
C
C==================================================================
C
C
C
C     0.3- SYMETRIE POUR LE RAYONNEMENT
C     ----------------------------------
      DO 131 N=1,12
        PLASYM(N,1) = 0.
  131 CONTINUE
      PLASYM(1,1) = 1.
      PLASYM(2,2) = 1.
      PLASYM(3,3) = 1.

      WRITE(NFECRA,*)
C
C     0.4- NOMBRE DE COMPOSANTES CONNEXES
C     -----------------------------------
      NUMGU = 0    
C
C     =====================
C     1- LECTURE DU FICHIER
C     =====================
C
      REWIND(NFCLRA)
C
C     Boucle de lecture....
   10 CONTINUE
C
      CHAINE = ' '
      READ(NFCLRA,1000,END=999) CHAINE
C
      IF (CHAINE(1:1) .EQ. '/') GOTO 10
C
      CALL POSCOT(CHAINE,I1,I2,LCH)
C
      IF (I1 .EQ. 0) THEN
C
         GOTO 10
C
      ELSE
C
C
C     =================================
C     2- CONDITIONS POUR LE RAYONNEMENT
C     =================================
C
         IF (CHAINE(I1:I2) .EQ. 'RAYT') THEN
C
C
            IF (.NOT. LRAY) THEN
               WRITE(NFECRA,2000)
               ERR = .TRUE.
            ELSE
               CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
               I1 = I2 + II1 + 1
               I2 = I1 + LCH - 1
C     
C               2.1- Plans de symetrie
C               --------------------------
                IF (CHAINE(I1:I2) .EQ. 'SYM3D') THEN
                  NPS = NPS + 1
                  IF (NPS.GT.NPLASY) THEN
                    WRITE (NFECRA,2110)
                    ERR = .TRUE.
                  ELSEIF (NDIM.NE.3) THEN
                    WRITE (NFECRA,2120)
                    ERR = .TRUE.
                  ELSE
                   CALL POSREE(CHAINE(I2+2:),4,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,4,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) 
     *                                   (PLASYM(I,NPS),I=1,4)
                   IF (NBLBLR.GE.2) THEN
                     WRITE(NFECRA,2130) (PLASYM(I,NPS),I=1,4)
                   ENDIF
                  ENDIF
C
                ELSEIF (CHAINE(I1:I2) .EQ. 'SYM2D') THEN
                  NPS = NPS + 1
                  IF (NPS.GT.NPLASY) THEN
                    WRITE (NFECRA,2110)
                    ERR = .TRUE.
                  ELSEIF (NDIM.NE.2) THEN
                    WRITE (NFECRA,2121)
                    ERR = .TRUE.
                  ELSE
                   CALL POSREE(CHAINE(I2+2:),3,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,3,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) 
     *                                   (PLASYM(I,NPS),I=1,3)
                   IF (NBLBLR.GE.2) THEN
                     WRITE(NFECRA,2131) (PLASYM(I,NPS),I=1,3)
                   ENDIF
                  ENDIF
C
C               2.2- Composantes connexes
C               -------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 'VOLUME CONNEXE') THEN
                   CALL POSREE(CHAINE(I2+2:),3,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,3,FORMA)
                   NUMGU = NUMGU + 1
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) 
     *                                   (PINTER(I,NUMGU),I=1,3)
                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,2250) (PINTER(I,NUMGU),I=1,3)
                   ENDIF
C
C               2.3.1- Bandes spectrales
C               -----------------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 'BANDES SPECTRALES') THEN
                   CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) XNUMBA
                   NUMBAN = INT(XNUMBA+0.1)
                   IF (NUMBAN .LT. 1 .OR. NUMBAN .GT. NBANDE) THEN
                      WRITE(NFECRA,2300) NUMBAN,NBANDE
                      ERR = .TRUE.
                   ENDIF                      
                   CALL POSREE(CHAINE(I2+2:),3,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,2,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) XLBDA1,XLBDA2
                   IF ( SPECTL(NUMBAN,1) .LT. 0. .AND. 
     *                  SPECTL(NUMBAN,2) .LT. 0.) THEN
                     SPECTL(NUMBAN,1) = XLBDA1
                     SPECTL(NUMBAN,2) = XLBDA2
                   ELSEIF ( ABS(XLBDA1-SPECTL(NUMBAN,1)) .GT. EPSBDE 
     *                  .OR. ABS(XLBDA2-SPECTL(NUMBAN,2)) .GT. EPSBDE )
     *                  THEN
                     WRITE(NFECRA,2310) NUMBAN,SPECTL(NUMBAN,1),
     *                                  SPECTL(NUMBAN,2),XLBDA1,XLBDA2
                     ERR = .TRUE.
                   ELSE
                     SPECTL(NUMBAN,1) = XLBDA1
                     SPECTL(NUMBAN,2) = XLBDA2
                   ENDIF
                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,2320) NUMBAN,XLBDA1,XLBDA2
                   ENDIF
C                                    
C
C               2.3.2- Emissivite par bande spectrale
C               -----------------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 'EMISSIVITE PAR BANDE') THEN
                   CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) XNUMBA
                   NUMBAN = INT(XNUMBA+0.1)
                   IF (NUMBAN .LT. 1 .OR. NUMBAN .GT. NBANDE) THEN
                      WRITE(NFECRA,2300) NUMBAN,NBANDE
                      ERR = .TRUE.
                   ENDIF                      
                   CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) EMILBD
                   II1 = I2+2
                   CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,2321) NUMBAN,EMILBD,(ITAB(I),I=1,NB)
                   ENDIF
                   CALL CCONDR(EMILBD,NRFRAY,NELRAY,EMISSI,NUMBAN,
     *                         ITAB,NB)
C                                    
C               2.4- Initialisation pour les caracteristiques equiv des
C                    zones de rayonnement couplee au fluide.
C               -------------------------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 
     *              'PROPRIETES PAROI EQUIVALENTE COUPLEE FLUIDE') THEN
                   CALL POSREE(CHAINE(I2+2:),4,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,4,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (VALEQ(I),I=1,4)
                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,*) 
                   ENDIF
                   II1 = I2+2
                   CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                   CALL CCOEQF(VALEQ,NELRAY,NRFRAY,NFCFRA,PHFRAF,NGFPEF,
     *                         ITAB,NB)
C
C               2.5- Initialisation pour les caracteristiques equiv des
C                    zones de rayonnement isolees.
C               -------------------------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 
     *              'PROPRIETES PAROI EQUIVALENTE ISOLEE') THEN
                   CALL POSREE(CHAINE(I2+2:),4,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,4,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (VALEQ(I),I=1,4)
                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,*) 
                   ENDIF
                   II1 = I2+2
                   CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                   CALL CCOEQI(VALEQ,NELRAY,NRFRAY,NFPERA,PHFRAE,NGFPER,
     *                         ITAB,NB)
C
C               2.6- Traitement de la temperature impose
C                    pour chaque element de rayonnement
C               -------------------------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 
     *              'TEMPERATURE IMPOSEE') THEN
                   CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) TRIMP
                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,*) 
                   ENDIF
                   II1 = I2+2
                   CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                   CALL CCONDT(TRIMP,NRFRAY,NELRAY,NFTIRA,NGFTIR,
     *                         TEMRAY,ITAB,NB)
C
C               2.7- Initialisation du flux impose pour chaque bande
C                    pour chaque element de rayonnement
C               -------------------------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 
     *              'FLUX IMPOSE PAR BANDE') THEN
                   CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) XNUMBA
                   NUMBAN = INT(XNUMBA+0.1)
                   IF (NUMBAN .LT. 1 .OR. NUMBAN .GT. NBANDE) THEN
                      WRITE(NFECRA,2300) NUMBAN,NBANDE
                      ERR = .TRUE.
                   ENDIF                      
                   CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) XFLU
                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,*) 
                   ENDIF
                   II1 = I2+2
                   CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                   CALL CCONFI(XFLU,NRFRAY,NELRAY,NFFIRA,NGFFIR,FIRAY,
     *                         VFIRAY,NUMBAN,ITAB,NB)
C
C               2.8- Periodicite en rayonnement
C               --------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 'PERIO3D') THEN
                  NPE = NPE + 1
                  IF (NPE.GT.0 .AND. .NOT.LPERAY) THEN
                    WRITE (NFECRA,2800)
                    ERR = .TRUE.
                  ELSEIF (NDIM.NE.3) THEN
                    WRITE (NFECRA,2810)
                    ERR = .TRUE.
                  ELSE
                   CALL POSREE(CHAINE(I2+2:),7,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,7,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) 
     *                                   (PERRAY(I),I=1,7)
                   IF (NBLBLR.GE.2) THEN
                     WRITE(NFECRA,2820) (PERRAY(I),I=1,7)
                   ENDIF
C                  Normalisation
                   APER = SQRT(PERRAY(4)*PERRAY(4)+PERRAY(5)*PERRAY(5)+
     &                         PERRAY(6)*PERRAY(6))
                   PERRAY(4) = PERRAY(4)/APER
                   PERRAY(5) = PERRAY(5)/APER
                   PERRAY(6) = PERRAY(6)/APER
                  ENDIF
C
                ELSEIF (CHAINE(I1:I2) .EQ. 'PERIO2D') THEN
                  NPE = NPE + 1
                  IF (NPE.GT.0 .AND. .NOT.LPERAY) THEN
                    WRITE (NFECRA,2800)
                    ERR = .TRUE.
                  ELSEIF (NDIM.NE.2) THEN
                    WRITE (NFECRA,2811)
                    ERR = .TRUE.
                  ELSE
                   CALL POSREE(CHAINE(I2+2:),3,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,3,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) 
     *                                   (PERRAY(I),I=1,3)
                   IF (NBLBLR.GE.2) THEN
                     WRITE(NFECRA,2821) (PERRAY(I),I=1,3)
                   ENDIF
                  ENDIF
C
C               2.10- Temperature pour l'infini (domaines ouverts)
C               -----------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 'TEMPERATURE INFINI') THEN
                   CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) TEMINF
C
               ENDIF
C
            ENDIF
C
C        
C        ============
C        HISTORIQUES
C        ============
C            
         ELSEIF (CHAINE(I1:I2) .EQ. 'HISTORIQUES') THEN
            IF (.NOT.LHISOR) THEN
               WRITE (NFECRA,4000)
            ELSE
               II1 = I2+2
               CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
               IF (NB.GT.NRFMAX) THEN
                  WRITE(NFECRA,4010) NRFMAX
                  ERR=.TRUE.
               ENDIF
               IF (NBHSOR+NB.GT.NHRMAX) THEN
                  WRITE(NFECRA,4020) NHRMAX
                  ERR=.TRUE.
               ENDIF
               I1 = I2 + II1 + 1
               I2 = I1 + LCH - 1
               CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
               READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
               DO I=1,NB
                  NHISOR(NBHSOR+I)=ITAB(I)
               ENDDO
               NBHSOR=NBHSOR+NB
            ENDIF
C     


C     ========================================================
C     3- CONDITIONS POUR LES MILIEUX SEMI TRANSPARENTS SOLIDES
C     ========================================================
C
         ELSEIF (CHAINE(I1:I2) .EQ. 'MSTS') THEN
C
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
C
C               3.1- Proprietes physiques
C               --------------------------
                IF (CHAINE(I1:I2) .EQ. 'CPHY') THEN
                   CALL POSREE(CHAINE(I2+2:),4,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,4,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999)  (VALEQ2(I),I=1,4)
                   II1 = I2+2
                   CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                   CALL CCOMST(VALEQ2,NELRAY,NRFRAY,NFMST,PHMSTP,PHMSTO,
     *                         NGFMST,ITAB,NB,1)
                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,3210) (VALEQ2(I),I=1,4),
     *                                   (ITAB(I),I=1,NB)
                   ENDIF
C
C               3.2- Proprietes optiques
C               --------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 'OPTIQUE') THEN
                   CALL POSREE(CHAINE(I2+2:),6,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,6,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999)  (VALEQ2(I),I=1,6)
                   NBAN=INT(VALEQ2(1)+0.1)
                   IF (NBAN.LT.0 .OR. NBAN.GT.NBANDE) THEN
                      WRITE(NFECRA,3200) NBAN,NBANDE
                      ERR=.TRUE.
                   ENDIF
                   II1 = I2+2
                   CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                   CALL CCOMST(VALEQ2,NELRAY,NRFRAY,NFMST,PHMSTP,PHMSTO,
     *                         NGFMST,ITAB,NB,2)
                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,3220) NBAN,(VALEQ2(I),I=2,6),
     *                                   (ITAB(I),I=1,NB)
                   ENDIF
C
C               3.3- Temperature initiale
C               -------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 'T INITIALE') THEN
                   CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) TRIMP
                   II1 = I2+2
                   CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                   CALL CCONDT(TRIMP,NRFRAY,NELRAY,NFMST,NGFMST(1,1),
     *                         TEMRAY,ITAB,NB)

                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,3230) TRIMP,(ITAB(I),I=1,NB)
                   ENDIF
C
C               3.4- T ext et coeff d'echange
C               -----------------------------
                ELSEIF (CHAINE(I1:I2) .EQ. 'COEF ECH') THEN
                   CALL POSREE(CHAINE(I2+2:),2,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('R',CHAINE(I1:I2),LCH,2,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) T,XH
                   II1 = I2+2
                   CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                   I1 = I2 + II1 + 1
                   I2 = I1 + LCH - 1
                   CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                   READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                   CALL CCONDM(T,XH,NRFRAY,NELRAY,NFMSTE,NGFMSE,VFMSTE,
     *                         ITAB,NB)
                   IF (NBLBLR.GE.2) THEN
                      WRITE(NFECRA,3240) T,XH,(ITAB(I),I=1,NB)
                   ENDIF
C
                ELSE
                  WRITE(NFECRA,6000) CHAINE
                  ERR=.TRUE.
                ENDIF
C
C
          ENDIF
C
      ENDIF
C
      GOTO 10
C
 999  CONTINUE
C
C
C     3- VERIFICATIONS
C     ================
C
C
      IF (NUMGU.GT.NGUMAX) THEN
        WRITE(NFECRA,3000) NGUMAX
        ERR = .TRUE.
      ENDIF
C
      IF (NDIM.EQ.2 .AND. LPERAY .AND. NPLASY .GT. 0) THEN
         WRITE(NFECRA,3010)
         ERR = .TRUE.
      ENDIF
C
      IF (NDIM.EQ.2 .AND. NPLASY.GT.2) THEN
         WRITE(NFECRA,3020)
         ERR = .TRUE.
      ENDIF
      IF (NDIM.EQ.3 .AND. NPLASY.GT.3) THEN
         WRITE(NFECRA,3030)
         ERR = .TRUE.
      ENDIF
C
      IF (LPERAY) THEN
        IF (NDIM.EQ.2) THEN
          ANG=PERRAY(3)
        ELSE
          ANG=PERRAY(7)
        ENDIF
        AAUX = INT(360./ANG+0.01)-360./ANG
        IF (ABS(AAUX) .GT. 0.001) THEN
          WRITE(NFECRA,3100) ANG
          ERR = .TRUE.
        ENDIF
C
        IF (NDIM.EQ.3 .AND. NPS .EQ. 1) THEN
           XNP  = SQRT(PLASYM(1,1)*PLASYM(1,1)
     &           +PLASYM(2,1)*PLASYM(2,1)
     &           +PLASYM(3,1)*PLASYM(3,1))
           PLASYM(1,1) = PLASYM(1,1) / XNP
           PLASYM(2,1) = PLASYM(2,1) / XNP
           PLASYM(3,1) = PLASYM(3,1) / XNP   
           SCAPP = PLASYM(1,1)*PERRAY(4)+
     &             PLASYM(2,1)*PERRAY(5)+
     &             PLASYM(3,1)*PERRAY(6)
           IF ( ABS(ABS(SCAPP)-1.) .GT. 1.E-5) THEN
              WRITE(NFECRA,3110) 
              ERR = .TRUE.
           ENDIF
        ELSEIF (NDIM.EQ.2 .AND. NPS .EQ. 1) THEN
          WRITE(NFECRA,3120)
          ERR = .TRUE.
        ENDIF
C
      ENDIF
C
      IF (NBHSOR.EQ.0) LHISOR=.FALSE.
C
C     4- STOP EN CAS D'ERREUR DANS LES MOTS-CLES
C     ==========================================
      IF (ERR) STOP
C
C
C     5- IMPRESSIONS DE CONTROLE
C     ==========================
C
      IF (NBLBLR.GE.3) THEN
C
        IF (LHISOR) THEN
         WRITE(NFECRA,5010) NBHSOR
         WRITE(NFECRA,5011) (NHISOR(I),I=1,NBHSOR)
        ENDIF
C
      ENDIF
C
      GOTO 300
C
C     6. Erreur de lecture sur le fichier
C     ===================================
 9999 WRITE(NFECRA,6000) CHAINE
      STOP
C
  300 CONTINUE
C--------
C FORMATS
C--------
 1000 FORMAT(A200)
C
 1162 FORMAT(/,' %% ERREUR LECLIR : LE TYPE DE CONDITION A LA LIMITE',
     &       ' CITE N''EST PAS RECONNU',/,
     &       '    ??? ',A)
C
 1310 FORMAT(' *** LECLIR : Masse volumique',/,
     *         14X,'Valeur : ',E12.5,4X,'References : ',32I3)
 1351 FORMAT(/,' %% ERREUR LECLIR : LA CONDITION PHYSIQUE INDIQUEE',
     &       ' N''EST PAS RECONNUE',/,
     &       '    ??? ',A)
C
C
 1118 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''CLIM'' ''DIRICHLET'' ',/,
     *  20X,'alors qu''aucun Dirichlet n''a ete defini',/,
     *  20X,'(cf ''REFERENCES NOEUDS SOLIDES AVEC DIRICHLET'')') 
C
 2000 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ',/,
     *  20X,'alors que le rayonnement n''est pas en pris ',
     *      'en compte ',/,
     *  20X,'(cf ''PRISE EN COMPTE DU RAYONNEMENT='')')
 2110 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ''SYM3D''  ',/,
     *  20X,'on definit plus de plans de symetrie qu''il n''y ',
     *      'en a de declares ',/,
     *  20X,'(cf ''NOMBRE DE PLANS DE SYMETRIE POUR ',
     *      'LE RAYONNEMENT='')')
 2120 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ''SYM3D''  ',/,
     *  20X,'Le probleme actuel n''est pas de dimension 3 ',/,
     *  20X,'(cf ''SYM2D'')')
 2121 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ''SYM2D''  ',/,
     *  20X,'Le probleme actuel n''est pas de dimension 2 ',/,
     *  20X,'(cf ''SYM3D'')')
 2130 FORMAT(' *** LECLIR : Symetrie pour le rayonnement',/,
     *         14X,E12.5,' X + ',E12.5,' Y + ',E12.5,' Z + ',
     *             E12.5,' = 0') 
 2131 FORMAT(' *** LECLIR : Symetrie pour le rayonnement',/,
     *         14X,E12.5,' X + ',E12.5,' Y + ',E12.5,' = 0') 
C
 2250 FORMAT(' *** LECLIR : Rayonnement : composante connexe',/,
     *         14X,'Point interieur : ',3E12.5)
C
 2300 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT''  ''BANDES SPECTRALES''  ',/,
     * 20X,'le numero de bande spectrale indique :',I2,' est incoherent'
     * ,/,20X,'avec le nombre de bandes definies precedemment (',I2,')')
 2310 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ''BANDES SPECTRALES''  ',/,
     *  20X,'les bornes de la bande spectrale ',I2,' sont incoherentes'
     * ,/,20X,'avec les bornes precedemment definies pour cette bande.'
     * ,/,20X,
     * 'Precedente occurence : Lambda_1 = ',E10.5,' Lambda_2 = ',E10.5
     * ,/,20X,
     * 'Presente occurence   : Lambda_1 = ',E10.5,' Lambda_2 = ',E10.5)
 2320 FORMAT(' *** LECLIR : Definition de la bande spectrale ',I2,/,
     *         14X,'Limites de la bande :',2E12.5)
 2321 FORMAT(' *** LECLIR : emissivite de la bande spectrale ',I2,/,
     *         14X,'Emisivite  :',E12.5,/,
     *         14X,'References : ',32I3)
C
 2800 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ''PERIO3D'' ou   ''PERIO2D'' ',/,
     *  20X,'La periodicite n''a pas ete declaree au prealable ',/,
     *  20X,'(cf ''PERIODICITE DE ROTATION POUR LE RAYONNEMENT'' ')
 2810 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ''PERIO3D''  ',/,
     *  20X,'Le probleme actuel n''est pas de dimension 3 ',/,
     *  20X,'(cf ''PERIO2D'')')
 2811 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ''PERIO2D''  ',/,
     *  20X,'Le probleme actuel n''est pas de dimension 2 ',/,
     *  20X,'(cf ''PERIO3D'')')
 2820 FORMAT(' *** LECLIR : Periodicite pour le rayonnement',/,
     *         14X,'Point invariant    : Px = ',E12.5,' Py = ',E12.5,
     *          ' Pz = ',E12.5,/,
     *         14X,'Axe de la rotation : Ax = ',E12.5,' Ay = ',E12.5,
     *          ' Az = ',E12.5,/,
     *         14X,'Angle = ',E12.5) 
 2821 FORMAT(' *** LECLIR : Periodicite pour le rayonnement',/,
     *         14X,'Point invariant : Px = ',E12.5,' Py = ',E12.5,/,
     *         14X,'Angle = ',E12.5) 
C
 3000 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ''VOLUME CONNEXE''  ',/,
     *  20X,'le nombre de composantes connexes definies est superieur '
     *      ,/,'au maximum autorise (',I2,')')
 3010 FORMAT(/,' %% ERREUR LECLIR : MOT-CLE " NOMBRE DE ',
     &       'PLANS DE SYMETRIE POUR LE RAYONNEMENT="',/,
     &       '                             et " PERIODICITE',
     &       'DE ROTATION POUR LE RAYONNEMENT="',/,
     &       '    Ces 2 options ne peuvent etre activees ',
     &       'simultanement en dimension 2',/)     
C
 3020 FORMAT(/,' %% ERREUR LECLIR : MOT-CLE " NOMBRE DE ',
     &       'PLANS DE SYMETRIE POUR LE RAYONNEMENT="',/,
     &       '    Il ne peut y avoir plus de 2 plans de symetrie ',
     &       'en dimension 2',/)     
 3030 FORMAT(/,' %% ERREUR LECLIR : MOT-CLE " NOMBRE DE ',
     &       'PLANS DE SYMETRIE POUR LE RAYONNEMENT="',/,
     &       '    Il ne peut y avoir plus de 3 plans de symetrie ',
     &       'en dimension 3',/)     
C
C
 3100 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ''PERIO3D'' ou  ''PERIO2D''  ',/,
     *  20X,' L''angle defini',E12.5,' ne convient pas.',/,
     *  20X,'On doit pouvoir faire 360 degres avec un',
     *       'multiple entier de cet angle')
 3110 FORMAT(/,' %% ERREUR LECLIR : utilisation du mot-cle',
     *         ' ''RAYT'' ''PERIO3D''  ',/,
     *  20X,'L''axe definissant la periodicite n''est pas orthogonal',
     *  20X,'au plan de symetrie defini')
 3120 FORMAT(/,' %% ERREUR LECLIR : en dimension 2 on ne peut definir',
     *         ' a la fois',/,
     *  20X,'de la periodicite ET de la symetrie')
 3200 FORMAT(/,' %% ERREUR LECLIR : proprietes optiques d''un milieu',
     *         ' semi transparent',/,
     *  20X,'le numero de bande spectrale n''est pas coherent avec',
     *      ' le nombre total de bandes definies',/,
     *  20X,'-> numero de bande fourni = ',I6,/,
     *  20x,'-> il devrait etre entre 0 et ',I3)
 3210 FORMAT(' *** LECLIR : Proprietes physiques d''un MST',/,
     *         14X,'rho= ',E12.5,'        Cp= ',E12.5,/,
     *         14X,'  k= ',E12.5,' epaisseur= ',E12.5,/,
     *         14X,'References : ',32I3)
 3220 FORMAT(' *** LECLIR : Proprietes optiques d''un MST',/,
     *         14X,'  Bande : ',I3,/,
     *         14X,'      emissivite= ',E12.5,' reflectivite= ',E12.5,/,
     *         14X,'  transmittivite= ',E12.5,' extinction  = ',E12.5,/,
     *         14X,'      refraction= ',E12.5,/,
     *         14X,'References : ',32I3)
 3230 FORMAT(' *** LECLIR : Temperature initiale d''un MST',/,
     *         14X,' T (C) = ',E12.5,/,
     *         14X,'References : ',32I3)
 3240 FORMAT(' *** LECLIR : Echange sur un MST',/,
     *         14X,' T (C) = ',E12.5, 'h = ',E12.5,/,
     *         14X,'References : ',32I3)
C
 4000 FORMAT(/,' $$ ATTENTION LECLIR : MOT-CLE "HISTORIQUES" ',/,
     *   20X,'Les historiques sur les facettes de rayonnement ',/,
     *   20X,'n''ont pas ete demandes (cf ''HISTORIQUES'')',/,
     *   20X,'On continue normalement...')
 4010 FORMAT(/,' %% ERREUR LECLIR : MOT-CLE "HISTORIQUES" ',/,
     *   20X,'Le nombre de facettes est limite a ',I3,' par ligne',/,
     *   20X,'Utiliser le mot-cle plusieurs fois pour definir ',
     *       ' toutes vos facettes')
 4020 FORMAT(/,' %% ERREUR LECLIR : MOT-CLE "HISTORIQUES" ',/,
     *   20X,'Le nombre total de facettes est limite a ',I4)
C
 5010 FORMAT(' *** LECLIR : Nombre d''historiques sur les facettes :',
     *         I7,/,
     *         14X,'Liste des facettes :')
 5011 FORMAT(100(1X,10I7,/))
C
 6000 FORMAT(/,' %% ERREUR LECLIR : Erreur dans le fichier de donnees',
     * /,20X,'au cours de la lecture des conditions limites et ',
     *       'physiques',/,
     *   20X,'Ligne concernee : ',A)
C
C----
C FIN
C----
C
      RETURN
      END
