C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                    *****************
                     SUBROUTINE DIFCOQ
C                    *****************
C
C     ---------------------------------------------------
     *( TMPS,TMPSA,TMPSC1,TMPSC2,TMPSC3,B,DMAT, 
     *  XMAT,PHYSOL,COORDS,NODES,NFLUVS,VFLUVS,  
     *  NDIRS,VDIRS,NCOUPS,VCOUPS,NFLUSS,VFLUSS,
     *  NECHS,VECHS,NRAYTS,VRAYTS,NPRIOS,NODEPR,
     *  VOLUME,DIAG,
     *  NPOINS,NELEMS,NDIELE,NCOEMA,NDMATS,NDIM,
     *  NBDIRS,NBCOUS,NBFLUS,NBFLVS,NPFEL,NBECHS,
     *  NPOUE,NPPEL,NBPHYS,
     *  NBRAYS,NBPRIO,NBCOPR,NELEPR,
     *  TRAV1,TRAV2,TRAV3,TRAV4,WCT )
C     ----------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     TRAITEMENT DE LA DIFFUSION SOLIDE                 *
C                    CAS  COQUE                                        *
C                    Dans un second temps, ce programme devrait        *
C                    etre a meme de traiter des materiaux multicouches *
C                    et une coque qui se deplace (suivant certaines    *
C                    modalite qui reste a definir.                     *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   TMPSA   !  TR  ! R  ! TEMPERATURE EN CHAQUE POINT interieur    !
C   !   TMPS    !  TR  ! D  ! TEMPERATURE EN CHAQUE POINT exterieur    !
C   !   TMPSC1  !  TR  ! D  ! 1er  COEF DE TEMPERATURE                 !
C   !   TMPSC2  !  TR  ! D  ! 2eme COEF DE TEMPERATURE                 !
C   !   TMPSC3  !  TR  ! D  ! 3eme COEF DE TEMPERATURE                 !
C   !   DMAT    !  TR  ! M  ! DIAGONALE DE LA MATRICE M                !
C   !   XMAT    !  TR  ! M  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   PHYSOL  !  TR  ! D  ! CARACTERISTIQUE DU SOLIDE                !
C   !           !      !    !   physol(n,1) = k conductivite           !
C   !           !      !    !   physol(n,2) = H (R courbure principal) !
C   !           !      !    !   physol(n,3) = e (epaisseur locale)     !
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   NFLUVS  !  TR  ! D  ! NUMERO DES POINTS DE FLUX VOLUMIQUE      !
C   !   VFLUVS  !  TR  ! D  ! VALEUR DU FLUX AU POINT DE FLUX VOLUMIQUE!
C   !   NCOUPS  !  TR  ! D  ! NUMERO DES POINTS DE COUPLAGE            !
C   !   VCOUPS  !  TR  ! D  ! VCOUPS(I,1) VALEUR DE T (FLUIDE)         !
C   !           !  TR  ! D  ! VCOUPS(I,2) coef d'echange (FLUIDE)      !
C   !   NFLUSS  !  TR  ! D  ! NUMERO DES POINTS DE FLUX (surf externe) !
C   !   VFLUSS  !  TR  ! D  ! VALEUR DU FLUX AU POINT DE FLUX  ( // )  !
C   !   NDIRS   !  TR  ! D  ! NUMERO DES POINTS DE DIRICHLET           !
C   !   VDIRS   !  TR  ! D  ! VALEUR DE DIRICHLET                      !
C   !   NECHS   !  TR  ! D  ! NUMERO DES POINTS DE COEF D'ECHANGE      !
C   !   VECHS   !  TR  ! D  ! VALEUR POUR LES POINTS A COEF D'ECHANGE  !
C   !           !  TR  ! D  !     VECHS(n,1) = Temperature exterieure  !
C   !           !  TR  ! D  !     VECHS(n,2) = Coef d'echange          !
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN COQUE             !
C   !   DIAG    !  TR  ! M  ! DIAGONALE DE PRECONDITIONNEMENT          !
C   !   TRAV1   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPMXS)       !
C   !   TRAV2   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPMXS)       ! 
C   !   TRAV3   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPMXS)       ! 
C   !   TRAV4   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPMXS)       !  
C   !   W1...W10!  TR  ! M  ! TABLEAUX DE TRAVAIL (Taille: NELMXS )    !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "rayonn.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDIELE,NCOEMA,NDMATS,NDIM
      INTEGER NBDIRS,NBCOUS,NBFLUS,NBFLVS,NPFEL
      INTEGER NBECHS,NPOUE,NPPEL,NBPHYS
      INTEGER NBRAYS
      INTEGER NBPRIO,NBCOPR,NELEPR
      INTEGER NRAYTS(NBRAYS)
      INTEGER NODES(NELEMS,NDMATS),NODEPR(NELEPR,NDMATS+1)
      INTEGER NPRIOS(NBPRIO,1+NBCOPR)
      INTEGER NFLUVS(NBFLVS)
      INTEGER NDIRS(NBDIRS),NCOUPS(NBCOUS),NFLUSS(NBFLUS),NECHS(NBECHS)
C
      DOUBLE PRECISION VRAYTS(NBRAYS,2)
      DOUBLE PRECISION COORDS(NPOINS,NDIM),B(NPOINS)
      DOUBLE PRECISION XMAT(NELEMS,NCOEMA)
      DOUBLE PRECISION DMAT(NPOINS)
      DOUBLE PRECISION TMPS(NPOINS),TMPSA(NPOINS)
      DOUBLE PRECISION TMPSC1(NPOINS),TMPSC2(NPOINS)
      DOUBLE PRECISION TMPSC3(NPOINS)
      DOUBLE PRECISION PHYSOL(NPOUE,NPPEL,NBPHYS)
      DOUBLE PRECISION VFLUVS(NBFLVS,NPFEL)
      DOUBLE PRECISION VDIRS(NBDIRS),VCOUPS(NBCOUS,2)
      DOUBLE PRECISION VFLUSS(NBFLUS),VECHS(NBECHS,2)
      DOUBLE PRECISION DIAG(NPOINS),VOLUME(NELEMS)
      DOUBLE PRECISION TRAV1(NPOINS),TRAV2(NPOINS)
      DOUBLE PRECISION TRAV3(NPOINS),TRAV4(NPOINS)
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
C
C..Variables locales
      INTEGER I,INODE
      INTEGER N1,N2,N3,N4,N5,N6,NJ,NJGL
      LOGICAL LVERIF
      DOUBLE PRECISION S2EP,EPAIS1,ZERO,SUR3,SUR5,ROCP1,RINDTS
      DOUBLE PRECISION HRAYO
C
C***********************************************************************
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .FALSE.
      ZERO   = 0.D0
C
C
      CALL OV ( 'X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )
C     
C     2- CALCUL DE L'EQUATION SUR LE PREMIER COEFFICIENT
C     ==================================================
C
C     2.1- Calcul de la matrice de masse mass-lumpee
C          ----------------------------------------------
      DO 210 I=1,NBCOUS
        INODE = NCOUPS(I)
         EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
         TRAV1(INODE) = (1.D0-EPAIS1*PHYSOL(INODE,1,5)) * VCOUPS(I,2)
  210 CONTINUE
C
      DO 211 I=1,NBECHS
         INODE = NECHS(I)
         EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
         TRAV1(INODE) = TRAV1(INODE) + 
     &                  (1.D0+EPAIS1*PHYSOL(INODE,1,5)) * VECHS(I,2)
  211 CONTINUE
C
      IF ( .NOT. LCOSTA ) THEN
        RINDTS = 1.D0 / RDTTS
        DO 212 I=1,NPOINS
          ROCP1 = PHYSOL(I,1,1) * PHYSOL(I,1,2) * RINDTS
          TRAV1(I) = TRAV1(I) + ROCP1 * PHYSOL(I,1,6) 
 212    CONTINUE
      ENDIF
C
      DO 213 I=1,NBRAYS
         INODE = NRAYTS(I)
         HRAYO = VRAYTS(I,2)*SIGMA*(TMPS(INODE)+VRAYTS(I,1)+2.*TKEL)*
     &            ((TMPS(INODE)+TKEL)*(TMPS(INODE)+TKEL)+
     &             (VRAYTS(I,1)+TKEL)*(VRAYTS(I,1)+TKEL) )
         TRAV1(INODE) = TRAV1(INODE) + 
     &                  (1.D0+EPAIS1*PHYSOL(INODE,1,5)) * HRAYO
 213  CONTINUE
C
       CALL MATELC ('MASSE   ',DMAT,XMAT,TRAV1,NODES,COORDS,VOLUME, 
     &               NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &               WCT )
C
C
C      2.2- Calcul du second membre
C      ----------------------------
C      cela comprend : 
C                         le flux couple au fluide
C                         le flux exterieur utilisateur
C                         le flux avec coefficient d'echange.
C                         le flux volumique constant dans l'epaisseur
C                         le second membre explicite (iteration n)
C
       CALL OV ( 'X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )
C
C  
C
       DO 221 I=1,NBCOUS
          INODE = NCOUPS(I)
          EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
          TRAV1(INODE) =(1.D0-EPAIS1*PHYSOL(INODE,1,5))
     &                               * VCOUPS(I,2)
     &                               * VCOUPS(I,1)
  221  CONTINUE
C
       DO 222 I=1,NBFLUS
          INODE = NFLUSS(I)
          EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
          TRAV1(INODE) = TRAV1(INODE) +
     &                   (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                   * VFLUSS(I)
  222         CONTINUE          
C
       DO 223 I=1,NBECHS
          INODE = NECHS(I)
          EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
          TRAV1(INODE) = TRAV1(INODE) +
     &                   (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                   * VECHS(I,2) 
     &                   * VECHS(I,1)
  223  CONTINUE
C
C
      IF (NBFLVS.GE.1) THEN
       IF(NDFLUV.EQ.1) THEN
         DO 2240 I=1,NBFLVS
           INODE = NFLUVS(I)
           TRAV1(INODE) = TRAV1(INODE) +
     &                    VFLUVS(I,1) * PHYSOL(INODE,1,6)
 2240    CONTINUE
C
       ELSEIF(NDFLUV.EQ.2) THEN
         DO 2241 I=1,NBFLVS
           N1 = NODES(NFLUVS(I),1)
           N2 = NODES(NFLUVS(I),2)
           N3 = NODES(NFLUVS(I),3)
           N4 = NODES(NFLUVS(I),4)
           N5 = NODES(NFLUVS(I),5)
           N6 = NODES(NFLUVS(I),6)
           TRAV1(N1) = TRAV1(N1)+VFLUVS(I,1)*PHYSOL(N1,1,6)
           TRAV1(N2) = TRAV1(N2)+VFLUVS(I,1)*PHYSOL(N2,1,6)
           TRAV1(N3) = TRAV1(N3)+VFLUVS(I,1)*PHYSOL(N3,1,6)
           TRAV1(N4) = TRAV1(N4)+VFLUVS(I,1)*PHYSOL(N4,1,6)
           TRAV1(N5) = TRAV1(N5)+VFLUVS(I,1)*PHYSOL(N5,1,6)
           TRAV1(N6) = TRAV1(N6)+VFLUVS(I,1)*PHYSOL(N6,1,6)
 2241    CONTINUE
C
       ELSE
         DO 2242 I=1,NBFLVS
           N1 = NODES(NFLUVS(I),1)
           N2 = NODES(NFLUVS(I),2)
           N3 = NODES(NFLUVS(I),3)
           N4 = NODES(NFLUVS(I),4)
           N5 = NODES(NFLUVS(I),5)
           N6 = NODES(NFLUVS(I),6)
           TRAV1(N1) = TRAV1(N1)+VFLUVS(I,1)*PHYSOL(N1,1,6)
           TRAV1(N2) = TRAV1(N2)+VFLUVS(I,2)*PHYSOL(N2,1,6)
           TRAV1(N3) = TRAV1(N3)+VFLUVS(I,3)*PHYSOL(N3,1,6)
           TRAV1(N4) = TRAV1(N4)+VFLUVS(I,4)*PHYSOL(N4,1,6)
           TRAV1(N5) = TRAV1(N5)+VFLUVS(I,5)*PHYSOL(N5,1,6)
           TRAV1(N6) = TRAV1(N6)+VFLUVS(I,6)*PHYSOL(N6,1,6)
 2242    CONTINUE
        ENDIF
       ENDIF
C
C
C
       DO 225 I=1,NBCOUS
          INODE = NCOUPS(I)
          EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
          TRAV1(INODE) = TRAV1(INODE) 
     &               - (1.D0-EPAIS1*PHYSOL(INODE,1,5)) * VCOUPS(I,2)
     &               * ( - TMPSC2(INODE) + TMPSC3(INODE) )            
  225  CONTINUE
C
       DO 226 I=1,NBECHS
          INODE = NCOUPS(I)
          EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
          TRAV1(INODE) = TRAV1(INODE) 
     &               - (1.D0+EPAIS1*PHYSOL(INODE,1,5)) * VECHS(I,2)
     &               * ( TMPSC2(INODE) + TMPSC3(INODE) )            
  226  CONTINUE
C
       IF ( .NOT. LCOSTA ) THEN
         RINDTS = 1.D0 / RDTTS
         DO 227 I=1,NPOINS
           ROCP1 = PHYSOL(I,1,1) * PHYSOL(I,1,2) * RINDTS
           TRAV1(I) = TRAV1(I) + ROCP1 * PHYSOL(I,1,6) * TMPSC1(I)
  227    CONTINUE
       ENDIF
C
       DO 228 I=1,NBRAYS
          INODE = NRAYTS(I)
          EPAIS1 = PHYSOL(INODE,1,6) *0.5D0
          HRAYO = VRAYTS(I,2)*SIGMA*(TMPS(INODE)+VRAYTS(I,1)+2.*TKEL)*
     &            ((TMPS(INODE)+TKEL)*(TMPS(INODE)+TKEL)+
     &             (VRAYTS(I,1)+TKEL)*(VRAYTS(I,1)+TKEL) )
          TRAV1(INODE) = TRAV1(INODE) + 
     &                   (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                   * HRAYO * VRAYTS(I,1)
 228  CONTINUE
C
C
       CALL SMFCOQ ( TRAV1,B,NODES,VOLUME,
     &               NPOINS,NELEMS,NDMATS,NDIELE,
     &               WCT )
C
C
C      2.3- Calcul de la matrice de diffusion
C      --------------------------------------
C
       DO 230 I=1,NPOINS
         TRAV1(I) =   PHYSOL(I,1,6) * PHYSOL(I,1,3)
 230   CONTINUE
C
       CALL MATELC ('DIFFU   ',DMAT,XMAT,TRAV1,NODES,COORDS,VOLUME, 
     &               NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &               WCT )
C
C
C
C      2.4- Resolution de la premiere equation
C      ---------------------------------------
C
C
        CALL OV ('X=1/Y   ',DIAG,DMAT,DMAT,ZERO,NPOINS )
C
        CALL GRCONJ ( TMPSC1,DMAT,XMAT,B,DIAG,NODES,
     &                TRAV1,TRAV2,TRAV3,TRAV4,WCT,
     &                NPOINS,NELEMS,NDIELE,NDMATS,NCOEMA,
     &                NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR )
C      
C
C
C     3- CALCUL DE L'EQUATION SUR LE DEUXIEME COEFFICIENT
C     ==================================================
C
      CALL OV ( 'X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )
C
C        3.1- Calcul de la matrice de masse mass-lumpee
C        ----------------------------------------------
         S2EP = 2.D0 / EPAIS1
         DO 310 I=1,NBCOUS
           INODE = NCOUPS(I)
           EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
           TRAV1(I) = S2EP *  PHYSOL(INODE,1,4) +
     &               (1.D0-EPAIS1*PHYSOL(INODE,1,5)) * VCOUPS(I,2)          
  310    CONTINUE
C
         DO 311 I=1,NBECHS
           INODE = NECHS(I)
           EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
           TRAV1(INODE) =  TRAV1(INODE)
     &                + (1.D0+EPAIS1*PHYSOL(INODE,1,5)) * VECHS(I,2)         
  311    CONTINUE
C
         IF ( .NOT. LCOSTA ) THEN
           SUR3 = 1.D0 / 3.D0
           RINDTS = 1.D0 / RDTTS
            DO 312 I=1,NPOINS
              ROCP1 = PHYSOL(I,1,1) * PHYSOL(I,1,2) * RINDTS
              TRAV1(INODE) =  TRAV1(INODE) + ROCP1 * SUR3 *
     &                         PHYSOL(I,1,6)
  312       CONTINUE
         ENDIF
C
C
      DO 313 I=1,NBRAYS
         INODE = NRAYTS(I)
         EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
         HRAYO = VRAYTS(I,2)*SIGMA*(TMPS(INODE)+VRAYTS(I,1)+2.*TKEL)*
     &            ((TMPS(INODE)+TKEL)*(TMPS(INODE)+2.*TKEL)+
     &             (VRAYTS(I,1)+TKEL)*(VRAYTS(I,1)+TKEL) )
         TRAV1(INODE) = TRAV1(INODE) +
     &                 (1.D0-EPAIS1*PHYSOL(INODE,1,5)) * HRAYO
 313  CONTINUE
C
         CALL MATELC ('MASSE   ',DMAT,XMAT,TRAV1,NODES,COORDS,VOLUME, 
     &                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &                 WCT )
C
C        3.2- Calcul de la matrice de diffusion
C        --------------------------------------
         S2EP =  1.D0 / 3.D0
         DO 320 I=1,NPOINS
           TRAV1(I) =   S2EP * PHYSOL(I,1,3) * PHYSOL(I,1,6)
  320    CONTINUE
C
         CALL MATELC ('DIFFU   ',DMAT,XMAT,TRAV1,NODES,COORDS,VOLUME, 
     &                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &                 WCT )
C
C
C        3.3- Calcul du second membre
C        ----------------------------
C        cela comprend : 
C                         la partie couplee au fluide
C                         la partie avec flux exterieur utilisateur
C                         la partie avec coefficient d'echange.
C                         le flux volumique constant dans l'epaisseur
C
         CALL OV ( 'X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )
C
C  
C
         DO 331 I=1,NBCOUS
            INODE = NCOUPS(I)
            EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
            TRAV1(INODE) = - (1.D0-EPAIS1*PHYSOL(INODE,1,5))
     &                               * VCOUPS(I,2)
     &                               * VCOUPS(I,1)
  331    CONTINUE
C
         DO 332 I=1,NBFLUS
            INODE = NFLUSS(I)
            EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
            TRAV1(INODE) = TRAV1(INODE)
     &                     + (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                     * VFLUSS(I)
  332    CONTINUE          
C
         DO 333 I=1,NBECHS
            INODE = NECHS(I)
            EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
            TRAV1(INODE) = TRAV1(INODE)
     &                     + (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                     * VECHS(I,2)
     &                     * VECHS(I,1)
  333    CONTINUE
C
         DO 334 I=1,NBRAYS
            INODE = NRAYTS(I)
            EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
            HRAYO = VRAYTS(I,2)*SIGMA*(TMPS(INODE)+VRAYTS(I,1)+2.*TKEL)*
     &               ((TMPS(INODE)+TKEL)*(TMPS(INODE)+TKEL)+
     &                (VRAYTS(I,1)+TKEL)*(VRAYTS(I,1)+TKEL) )
            TRAV1(INODE) = TRAV1(INODE) 
     &                     + (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                     * HRAYO
     &                     * VRAYTS(I,1)
  334         CONTINUE
C
         DO 335 I=1,NBCOUS
            INODE = NCOUPS(I)
            EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
            TRAV1(INODE) = TRAV1(INODE)
     &                     + (1.D0-EPAIS1*PHYSOL(INODE,1,5))
     &                        * VCOUPS(I,2)
     &                        * ( TMPSC1(INODE) + TMPSC3(INODE) )  
     &                     - 2.D0*PHYSOL(INODE,1,5)*PHYSOL(INODE,1,4)
     &                        * TMPSC3(INODE)         
  335     CONTINUE
C
          DO 336 I=1,NBECHS
             INODE = NECHS(I)
             EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
             TRAV1(INODE) = TRAV1(INODE)
     &                     - (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                     * VECHS(I,2)
     &                     * ( TMPSC1(INODE) + TMPSC3(INODE) )           
  336     CONTINUE
C
      IF ( .NOT. LCOSTA ) THEN
        SUR3 = 1.D0 / 3.D0
        RINDTS = 1.D0 / RDTTS
        DO 337 I=1,NPOINS
          ROCP1 = PHYSOL(I,1,1) * PHYSOL(I,1,2) * RINDTS
          TRAV1(INODE) =  TRAV1(INODE) + ROCP1 * SUR3 *
     &                                     PHYSOL(I,1,6) * TMPSC2(I)
  337   CONTINUE
      ENDIF
C
          DO 338 I=1,NBRAYS
             INODE = NRAYTS(I)
             EPAIS1 = PHYSOL(INODE,1,6) * 0.5D0
             HRAYO = VRAYTS(I,2)*SIGMA*
     &                (TMPS(INODE)+VRAYTS(I,1)+2.*TKEL)*
     &                ((TMPS(INODE)+TKEL)*(TMPS(INODE)+TKEL)+
     &                 (VRAYTS(I,1)+TKEL)*(VRAYTS(I,1)+TKEL) )
             TRAV1(INODE) = TRAV1(INODE)
     &                     - (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                     * HRAYO
     &                     * ( TMPSC1(INODE) + TMPSC3(INODE) )           
  338     CONTINUE

          CALL SMFCOQ ( TRAV1,B,NODES,VOLUME,
     &                  NPOINS,NELEMS,NDMATS,NDIELE,
     &                  WCT )
C
      IF (NBFLVS.GE.1) THEN
       IF(NDFLUV.EQ.1) THEN
         DO 3390 I=1,NBFLVS
            INODE = NFLUVS(I)
            EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
            TRAV1(INODE) = TRAV1(INODE) 
     &                     + VFLUVS(I,1)
     &                     * 2.D0/3.D0 * EPAIS1 * EPAIS1
     &                     * ABS( PHYSOL(INODE,1,5) )
 3390   CONTINUE
C
       ELSEIF(NDFLUV.EQ.2) THEN
         DO 3391 I=1,NBFLVS
            DO 3392 NJ=1,NDMATS
              NJGL = NODES(NFLUVS(I),NJ)
              EPAIS1 = PHYSOL(NJGL,1,6) / 2.D0
              TRAV1(NJGL) =   TRAV1(NJGL) 
     &                       + VFLUVS(I,1)
     &                       * 2.D0/3.D0 * EPAIS1 * EPAIS1
     &                       * ABS( PHYSOL(NJGL,1,5) )
 3392       CONTINUE
 3391    CONTINUE
C
       ELSE
         DO 3393 I=1,NBFLVS
            DO 3394 NJ=1,NDMATS
              NJGL = NODES(NFLUVS(I),NJ)
              EPAIS1 = PHYSOL(NJGL,1,6) / 2.D0
              TRAV1(NJGL) =   TRAV1(NJGL) 
     &                       + VFLUVS(I,NJ)
     &                       * 2.D0/3.D0 * EPAIS1 * EPAIS1
     &                       * ABS( PHYSOL(NJGL,1,5) )
 3394       CONTINUE
 3393    CONTINUE
       ENDIF
      ENDIF
C
C
         CALL OV ('X=1/Y   ',DIAG,DMAT,DMAT,ZERO,NPOINS )
C
         CALL GRCONJ ( TMPSC2,DMAT,XMAT,B,DIAG,NODES,
     &                  TRAV1,TRAV2,TRAV3,TRAV4,WCT,
     &                  NPOINS,NELEMS,NDIELE,NDMATS,NCOEMA,
     &                  NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR )
C      
C
C     4- CALCUL DE L'EQUATION SUR LE TROISIEME COEFFICIENT
C     ====================================================
C
C
C 
C
      CALL OV ( 'X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )
C
C        4.1- Calcul de la matrice de masse mass-lumpee
C        ----------------------------------------------
         S2EP = 6.D0 
         DO 410 I=1,NBCOUS
           INODE = NCOUPS(I)
           EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
           TRAV1(INODE) = S2EP * PHYSOL(INODE,1,4) / EPAIS1   
     &                   + (1.D0-EPAIS1*PHYSOL(INODE,1,5)) * VCOUPS(I,2)    
  410    CONTINUE
C
         DO 411 I=1,NBECHS
           INODE = NECHS(I)
           EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
           TRAV1(INODE) =  TRAV1(INODE)
     &                  + (1.D0+EPAIS1*PHYSOL(INODE,1,5)) * VECHS(I,2)     
  411    CONTINUE
C
         IF ( .NOT. LCOSTA ) THEN
            SUR5 = 1.D0 / 5.D0
            RINDTS = 1.D0 / RDTTS
            DO 412 I=1,NPOINS
              ROCP1 = PHYSOL(I,1,1) * PHYSOL(I,1,2) * RINDTS
              TRAV1(INODE) =  TRAV1(INODE) + ROCP1*SUR5*PHYSOL(I,1,6)
  412       CONTINUE
         ENDIF
C
      DO 413 I=1,NBRAYS
         INODE = NRAYTS(I)
         EPAIS1 = PHYSOL(INODE,1,6) / 2.D0
         HRAYO = VRAYTS(I,2)*SIGMA*
     &            (TMPS(INODE)+VRAYTS(I,1)+2.*TKEL)*
     &            ((TMPS(INODE)+TKEL)*(TMPS(INODE)+TKEL)+
     &             (VRAYTS(I,1)+TKEL)*(VRAYTS(I,1)+TKEL)  )
         TRAV1(INODE) = TRAV1(INODE) +
     &                 (1.D0-EPAIS1*PHYSOL(INODE,1,5)) * HRAYO
 413  CONTINUE
C
         CALL MATELC ('MASSE   ',DMAT,XMAT,TRAV1,NODES,COORDS,VOLUME, 
     &                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &                 WCT )
C
C        4.2- Calcul de la matrice de diffusion
C        --------------------------------------
         S2EP =  1.D0 / 5.D0 
         DO 420 I=1,NPOINS
           TRAV1(I) =   S2EP * PHYSOL(I,1,3) * PHYSOL(I,1,6)
  420    CONTINUE
C
         CALL MATELC ('DIFFU   ',DMAT,XMAT,TRAV1,NODES,COORDS,VOLUME, 
     &                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &                 WCT )
C
C
C        4.3- Calcul du second membre
C        ----------------------------
C        cela comprend : 
C                         la partie couplee au fluide
C                         la partie avec flux exterieur utilisateur
C                         la partie avec coefficient d'echange.
C                         le flux volumique constant dans l'epaisseur
C
C
         CALL OV ( 'X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )
C
C  
         IF ( .NOT. LCOSTA ) THEN
           SUR5 = 1.D0 / 5.D0
           RINDTS = 1.D0 / RDTTS
           DO 430 I=1,NPOINS
             ROCP1 = PHYSOL(I,1,1) * PHYSOL(I,1,2) * RINDTS
             TRAV1(INODE) =  TRAV1(INODE) + ROCP1 * SUR5
     &                             * PHYSOL(I,1,6) * TMPSC3(I)
  430      CONTINUE
         ENDIF
C
C
         DO 431 I=1,NBCOUS
            INODE = NCOUPS(I)
            EPAIS1 =  PHYSOL(INODE,1,6) / 2.D0
            TRAV1(INODE) = (1.D0-EPAIS1*PHYSOL(INODE,1,5))
     &                      * VCOUPS(I,2)
     &                      * VCOUPS(I,1)
  431    CONTINUE
C
         DO 432 I=1,NBFLUS
            INODE = NFLUSS(I)
            EPAIS1 =  PHYSOL(INODE,1,6) / 2.D0
            TRAV1(INODE) = TRAV1(INODE)
     &                     + (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                    * VFLUSS(I)                  
  432    CONTINUE          
C
         DO 433 I=1,NBECHS
            INODE = NECHS(I)
             EPAIS1 =  PHYSOL(INODE,1,6) / 2.D0
             TRAV1(INODE) = TRAV1(INODE)
     &                      + (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                      *  VECHS(I,2)
     &                      *  VECHS(I,1)
  433    CONTINUE
C
         DO 434 I=1,NBRAYS
            INODE = NRAYTS(I)
            EPAIS1 =  PHYSOL(INODE,1,6) / 2.D0
            HRAYO = VRAYTS(I,2)*SIGMA*
     &               (TMPS(INODE)+VRAYTS(I,1)+2.*TKEL)*
     &               ((TMPS(INODE)+TKEL)*(TMPS(INODE)+TKEL)+
     &                (VRAYTS(I,1)+TKEL)*(VRAYTS(I,1)+TKEL)  )
            TRAV1(INODE) = TRAV1(INODE) 
     &                     + (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                     * HRAYO
     &                     * VRAYTS(I,1)
  434         CONTINUE
C
C
C
         DO 435 I=1,NBCOUS
            INODE = NCOUPS(I)
            EPAIS1 =  PHYSOL(INODE,1,6) / 2.D0
            TRAV1(INODE) = TRAV1(INODE)
     &                 - (1.D0-EPAIS1*PHYSOL(INODE,1,5))
     &                 * ( -TMPSC2(INODE) + TMPSC1(INODE) )
     &                 * VCOUPS(I,2)
     &                 - 2.D0*PHYSOL(INODE,1,5)*PHYSOL(INODE,1,4)
     &                 * TMPSC2(INODE)
  435    CONTINUE
C
         DO 436 I=1,NBECHS
            INODE = NECHS(I)
            EPAIS1 =  PHYSOL(INODE,1,6) / 2.D0
            TRAV1(INODE) = TRAV1(INODE)
     &                - (1.D0+EPAIS1*PHYSOL(INODE,1,5))
     &                * VECHS(I,2)
     &                * ( TMPSC2(INODE) + TMPSC1(INODE) )
  436    CONTINUE
C
         DO 437 I=1,NBRAYS
            INODE = NRAYTS(I)
            HRAYO = VRAYTS(I,2)*SIGMA*
     &               (TMPS(INODE)+VRAYTS(I,1)+2.*TKEL)*
     &               ((TMPS(INODE)+TKEL)*(TMPS(INODE)+TKEL)+
     &                (VRAYTS(I,1)+TKEL)*(VRAYTS(I,1)+TKEL)  )
            EPAIS1 =  PHYSOL(INODE,1,6) / 2.D0
            TRAV1(INODE) = TRAV1(INODE)
     &                 - (1.D0-EPAIS1*PHYSOL(INODE,1,5))
     &                 * ( -TMPSC2(INODE) + TMPSC1(INODE) )
     &                 * HRAYO
c     &                 - 2.D0*PHYSOL(INODE,1,5)*PHYSOL(INODE,1,4)
c     &                 * TMPSC2(INODE)
  437    CONTINUE
C
         CALL SMFCOQ ( TRAV1,B,NODES,VOLUME,
     &                 NPOINS,NELEMS,NDMATS,NDIELE,
     &                 WCT )
C
C
C
C
         DO 438 I=1,NBDIRS
         VDIRS(I) = VDIRS(I) - TMPSC1(NDIRS(I)) 
     &                       + TMPSC2(NDIRS(I))
  438       CONTINUE
C
C
         IF ( NBDIRS .GT. 0 ) THEN
         CALL SMDIRS ( NDIRS,VDIRS,B,DMAT,XMAT,NODES,
     &                 TRAV1,TRAV2,TRAV3,
     &                 NPOINS,NELEMS,NDMATS,NBDIRS,NCOEMA,
     &                 NDIELE,NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR,
     &                 WCT ) 
         ENDIF
C
C        4.4- Resolution de la Troisieme equation
C        ---------------------------------------
C
C
         CALL OV ('X=1/Y   ',DIAG,DMAT,DMAT,ZERO,NPOINS )
C
         CALL GRCONJ ( TMPSC3,DMAT,XMAT,B,DIAG,NODES,
     &                 TRAV1,TRAV2,TRAV3,TRAV4,WCT,
     &                 NPOINS,NELEMS,NDIELE,NDMATS,NCOEMA,
     &                 NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR )
C      
C
C     5- CALCUL DE LA TEMPERATURE SUR LES DEUX FACES INT ET EXT
C     =========================================================
C
      DO 510 I=1,NPOINS
          TMPSA(I) = TMPSC1(I) - TMPSC2(I) + TMPSC3(I)
 510  CONTINUE
C
      DO 520 I=1,NPOINS
          TMPS(I) = TMPSC1(I) + TMPSC2(I) + TMPSC3(I)
 520  CONTINUE
C
      END
