/* spek-pipeline.c generated by valac 0.10.4, the Vala compiler
 * generated from spek-pipeline.vala, do not modify */

/* spek-pipeline.vala
 *
 * Copyright (C) 2010  Alexander Kojevnikov <alexander@kojevnikov.com>
 *
 * Spek is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Spek is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Spek.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Conversion of decoded samples into an FFT-happy format is heavily
 * influenced by GstSpectrum which is part of gst-plugins-good.
 * The original code:
 * (c) 1999 Erik Walthinsen <omega@cse.ogi.edu>
 * (c) 2006 Stefan Kost <ensonic@users.sf.net>
 * (c) 2007-2009 Sebastian Dröge <sebastian.droege@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <spek-audio.h>
#include <float.h>
#include <math.h>
#include <spek-fft.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define SPEK_TYPE_PIPELINE (spek_pipeline_get_type ())
#define SPEK_PIPELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_PIPELINE, SpekPipeline))
#define SPEK_PIPELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_PIPELINE, SpekPipelineClass))
#define SPEK_IS_PIPELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_PIPELINE))
#define SPEK_IS_PIPELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_PIPELINE))
#define SPEK_PIPELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_PIPELINE, SpekPipelineClass))

typedef struct _SpekPipeline SpekPipeline;
typedef struct _SpekPipelineClass SpekPipelineClass;
typedef struct _SpekPipelinePrivate SpekPipelinePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _spek_audio_close0(var) ((var == NULL) ? NULL : (var = (spek_audio_close (var), NULL)))
#define _spek_fft_destroy0(var) ((var == NULL) ? NULL : (var = (spek_fft_destroy (var), NULL)))
#define _g_mutex_free0(var) ((var == NULL) ? NULL : (var = (g_mutex_free (var), NULL)))
#define _g_cond_free0(var) ((var == NULL) ? NULL : (var = (g_cond_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SpekParamSpecPipeline SpekParamSpecPipeline;

struct _SpekPipeline {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SpekPipelinePrivate * priv;
};

struct _SpekPipelineClass {
	GTypeClass parent_class;
	void (*finalize) (SpekPipeline *self);
};

typedef void (*SpekPipelineCallback) (gint sample, float* values, int values_length1, void* user_data);
struct _SpekPipelinePrivate {
	char* _description;
	gint _sample_rate;
	SpekAudioContext* cx;
	gint bands;
	gint samples;
	gint threshold;
	SpekPipelineCallback cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	SpekFftPlan* fft;
	gint nfft;
	float* coss;
	gint coss_length1;
	gint _coss_size_;
	gint input_size;
	gint input_pos;
	float* input;
	gint input_length1;
	gint _input_size_;
	float* output;
	gint output_length1;
	gint _output_size_;
	GThread* reader_thread;
	GThread* worker_thread;
	GMutex* reader_mutex;
	GCond* reader_cond;
	GMutex* worker_mutex;
	GCond* worker_cond;
	gboolean worker_done;
	gboolean quit;
	GStaticRecMutex __lock_quit;
};

struct _SpekParamSpecPipeline {
	GParamSpec parent_instance;
};


static gpointer spek_pipeline_parent_class = NULL;

gpointer spek_pipeline_ref (gpointer instance);
void spek_pipeline_unref (gpointer instance);
GParamSpec* spek_param_spec_pipeline (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void spek_value_set_pipeline (GValue* value, gpointer v_object);
void spek_value_take_pipeline (GValue* value, gpointer v_object);
gpointer spek_value_get_pipeline (const GValue* value);
GType spek_pipeline_get_type (void) G_GNUC_CONST;
#define SPEK_PIPELINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SPEK_TYPE_PIPELINE, SpekPipelinePrivate))
enum  {
	SPEK_PIPELINE_DUMMY_PROPERTY
};
#define SPEK_PIPELINE_NFFT 64
SpekPipeline* spek_pipeline_new (const char* file_name, gint bands, gint samples, gint threshold, SpekPipelineCallback cb, void* cb_target);
SpekPipeline* spek_pipeline_construct (GType object_type, const char* file_name, gint bands, gint samples, gint threshold, SpekPipelineCallback cb, void* cb_target);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
static void _vala_array_add2 (char*** array, int* length, int* size, char* value);
static void _vala_array_add3 (char*** array, int* length, int* size, char* value);
static void _vala_array_add4 (char*** array, int* length, int* size, char* value);
static void _vala_array_add5 (char*** array, int* length, int* size, char* value);
static void spek_pipeline_set_description (SpekPipeline* self, const char* value);
const char* spek_pipeline_get_description (SpekPipeline* self);
static void spek_pipeline_set_sample_rate (SpekPipeline* self, gint value);
void spek_pipeline_start (SpekPipeline* self);
void spek_pipeline_stop (SpekPipeline* self);
static void* spek_pipeline_reader_func (SpekPipeline* self);
static void* _spek_pipeline_reader_func_gthread_func (gpointer self);
static void* spek_pipeline_worker_func (SpekPipeline* self);
static void* _spek_pipeline_worker_func_gthread_func (gpointer self);
static float spek_pipeline_average_input (SpekPipeline* self, guint8* buffer);
static void spek_pipeline_reader_sync (SpekPipeline* self, gint pos);
gint spek_pipeline_get_sample_rate (SpekPipeline* self);
double spek_pipeline_get_duration (SpekPipeline* self);
static void spek_pipeline_finalize (SpekPipeline* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


SpekPipeline* spek_pipeline_construct (GType object_type, const char* file_name, gint bands, gint samples, gint threshold, SpekPipelineCallback cb, void* cb_target) {
	SpekPipeline* self = (SpekPipeline*) g_type_create_instance (object_type);
	SpekAudioContext* _tmp0_;
	SpekPipelineCallback _tmp1_;
	gint items_length1;
	gint _items_size_;
	char** _tmp3_;
	char** _tmp2_ = NULL;
	char** items;
	gboolean _tmp4_ = FALSE;
	char* _tmp5_;
	g_return_val_if_fail (file_name != NULL, NULL);
	self->priv->cx = (_tmp0_ = spek_audio_open (file_name), _spek_audio_close0 (self->priv->cx), _tmp0_);
	self->priv->bands = bands;
	self->priv->samples = samples;
	self->priv->threshold = threshold;
	self->priv->cb = (_tmp1_ = cb, ((self->priv->cb_target_destroy_notify == NULL) ? NULL : (self->priv->cb_target_destroy_notify (self->priv->cb_target), NULL), self->priv->cb = NULL, self->priv->cb_target = NULL, self->priv->cb_target_destroy_notify = NULL), self->priv->cb_target = cb_target, self->priv->cb_target_destroy_notify = NULL, _tmp1_);
	items = (_tmp3_ = (_tmp2_ = g_new0 (char*, 0 + 1), _tmp2_), items_length1 = 0, _items_size_ = items_length1, _tmp3_);
	if (self->priv->cx->codec_name != NULL) {
		_vala_array_add1 (&items, &items_length1, &_items_size_, g_strdup (self->priv->cx->codec_name));
	}
	if (self->priv->cx->bit_rate != 0) {
		_vala_array_add2 (&items, &items_length1, &_items_size_, g_strdup_printf (_ ("%d kbps"), (self->priv->cx->bit_rate + 500) / 1000));
	}
	if (self->priv->cx->sample_rate != 0) {
		_vala_array_add3 (&items, &items_length1, &_items_size_, g_strdup_printf (_ ("%d Hz"), self->priv->cx->sample_rate));
	}
	if (self->priv->cx->bits_per_sample != 0) {
		_tmp4_ = self->priv->cx->bit_rate == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_vala_array_add4 (&items, &items_length1, &_items_size_, g_strdup_printf (ngettext ("%d bit", "%d bits", (gulong) self->priv->cx->bits_per_sample), self->priv->cx->bits_per_sample));
	}
	if (self->priv->cx->channels != 0) {
		_vala_array_add5 (&items, &items_length1, &_items_size_, g_strdup_printf (ngettext ("%d channel", "%d channels", (gulong) self->priv->cx->channels), self->priv->cx->channels));
	}
	_tmp5_ = NULL;
	if (items_length1 > 0) {
		char* _tmp6_;
		_tmp5_ = (_tmp6_ = g_strjoinv (", ", items), _g_free0 (_tmp5_), _tmp6_);
	} else {
		char* _tmp7_;
		_tmp5_ = (_tmp7_ = g_strdup (""), _g_free0 (_tmp5_), _tmp7_);
	}
	spek_pipeline_set_description (self, _tmp5_);
	if (self->priv->cx->error != NULL) {
		char* _tmp8_;
		spek_pipeline_set_description (self, _tmp8_ = g_strdup_printf (_ ("%s: %s"), self->priv->cx->error, self->priv->_description));
		_g_free0 (_tmp8_);
	} else {
		float* _tmp9_;
		float cf;
		SpekFftPlan* _tmp11_;
		float* _tmp12_;
		float* _tmp13_;
		spek_pipeline_set_sample_rate (self, self->priv->cx->sample_rate);
		self->priv->nfft = (2 * bands) - 2;
		self->priv->coss = (_tmp9_ = g_new0 (float, self->priv->nfft), self->priv->coss = (g_free (self->priv->coss), NULL), self->priv->coss_length1 = self->priv->nfft, self->priv->_coss_size_ = self->priv->coss_length1, _tmp9_);
		cf = (2.f * ((float) G_PI)) / self->priv->nfft;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp10_;
				_tmp10_ = TRUE;
				while (TRUE) {
					if (!_tmp10_) {
						i++;
					}
					_tmp10_ = FALSE;
					if (!(i < self->priv->nfft)) {
						break;
					}
					self->priv->coss[i] = cosf (cf * i);
				}
			}
		}
		self->priv->fft = (_tmp11_ = spek_fft_plan_new (self->priv->nfft, threshold), _spek_fft_destroy0 (self->priv->fft), _tmp11_);
		self->priv->input_size = self->priv->nfft * ((SPEK_PIPELINE_NFFT * 2) + 1);
		self->priv->input = (_tmp12_ = g_new0 (float, self->priv->input_size), self->priv->input = (g_free (self->priv->input), NULL), self->priv->input_length1 = self->priv->input_size, self->priv->_input_size_ = self->priv->input_length1, _tmp12_);
		self->priv->output = (_tmp13_ = g_new0 (float, bands), self->priv->output = (g_free (self->priv->output), NULL), self->priv->output_length1 = bands, self->priv->_output_size_ = self->priv->output_length1, _tmp13_);
		spek_audio_start (self->priv->cx, samples);
	}
	_g_free0 (_tmp5_);
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


SpekPipeline* spek_pipeline_new (const char* file_name, gint bands, gint samples, gint threshold, SpekPipelineCallback cb, void* cb_target) {
	return spek_pipeline_construct (SPEK_TYPE_PIPELINE, file_name, bands, samples, threshold, cb, cb_target);
}


static void* _spek_pipeline_reader_func_gthread_func (gpointer self) {
	void* result;
	result = spek_pipeline_reader_func (self);
	return result;
}


void spek_pipeline_start (SpekPipeline* self) {
	GMutex* _tmp0_;
	GCond* _tmp1_;
	GMutex* _tmp2_;
	GCond* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	spek_pipeline_stop (self);
	if (self->priv->cx->error != NULL) {
		return;
	}
	self->priv->input_pos = 0;
	self->priv->reader_mutex = (_tmp0_ = g_mutex_new (), _g_mutex_free0 (self->priv->reader_mutex), _tmp0_);
	self->priv->reader_cond = (_tmp1_ = g_cond_new (), _g_cond_free0 (self->priv->reader_cond), _tmp1_);
	self->priv->worker_mutex = (_tmp2_ = g_mutex_new (), _g_mutex_free0 (self->priv->worker_mutex), _tmp2_);
	self->priv->worker_cond = (_tmp3_ = g_cond_new (), _g_cond_free0 (self->priv->worker_cond), _tmp3_);
	{
		GThread* _tmp4_;
		_tmp4_ = g_thread_create (_spek_pipeline_reader_func_gthread_func, self, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch2_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->reader_thread = _tmp4_;
	}
	goto __finally2;
	__catch2_g_thread_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			spek_pipeline_stop (self);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void spek_pipeline_stop (SpekPipeline* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->reader_thread != NULL) {
		{
			g_static_rec_mutex_lock (&self->priv->__lock_quit);
			{
				self->priv->quit = TRUE;
			}
			__finally3:
			{
				g_static_rec_mutex_unlock (&self->priv->__lock_quit);
			}
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		g_thread_join (self->priv->reader_thread);
		self->priv->quit = FALSE;
		self->priv->reader_thread = NULL;
	}
}


static void* _spek_pipeline_worker_func_gthread_func (gpointer self) {
	void* result;
	result = spek_pipeline_worker_func (self);
	return result;
}


static void* spek_pipeline_reader_func (SpekPipeline* self) {
	void* result = NULL;
	GTimeVal timeval = {0};
	gint pos;
	gint prev_pos;
	gint block_size;
	gint size = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_get_current_time (&timeval);
	g_get_current_time (&timeval);
	pos = 0;
	prev_pos = 0;
	block_size = (self->priv->cx->width * self->priv->cx->channels) / 8;
	{
		GThread* _tmp0_;
		_tmp0_ = g_thread_create (_spek_pipeline_worker_func_gthread_func, self, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch4_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		self->priv->worker_thread = _tmp0_;
	}
	goto __finally4;
	__catch4_g_thread_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	while (TRUE) {
		guint8* buffer;
		if (!((size = spek_audio_read (self->priv->cx)) > 0)) {
			break;
		}
		{
			g_static_rec_mutex_lock (&self->priv->__lock_quit);
			{
				if (self->priv->quit) {
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_quit);
					}
					break;
				}
			}
			__finally5:
			{
				g_static_rec_mutex_unlock (&self->priv->__lock_quit);
			}
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		buffer = (guint8*) self->priv->cx->buffer;
		while (TRUE) {
			gint _tmp1_ = 0;
			if (!(size >= block_size)) {
				break;
			}
			self->priv->input[pos] = spek_pipeline_average_input (self, buffer);
			buffer = buffer + block_size;
			size = size - block_size;
			pos = (pos + 1) % self->priv->input_size;
			if (pos > prev_pos) {
				_tmp1_ = pos;
			} else {
				_tmp1_ = pos + self->priv->input_size;
			}
			if ((_tmp1_ - prev_pos) == (self->priv->nfft * SPEK_PIPELINE_NFFT)) {
				spek_pipeline_reader_sync (self, prev_pos = pos);
			}
		}
		g_assert (size == 0);
	}
	if (pos != prev_pos) {
		spek_pipeline_reader_sync (self, pos);
	}
	spek_pipeline_reader_sync (self, -1);
	g_thread_join (self->priv->worker_thread);
	result = NULL;
	return result;
}


static void spek_pipeline_reader_sync (SpekPipeline* self, gint pos) {
	g_return_if_fail (self != NULL);
	g_mutex_lock (self->priv->reader_mutex);
	while (TRUE) {
		if (!(!self->priv->worker_done)) {
			break;
		}
		g_cond_wait (self->priv->reader_cond, self->priv->reader_mutex);
	}
	self->priv->worker_done = FALSE;
	g_mutex_unlock (self->priv->reader_mutex);
	g_mutex_lock (self->priv->worker_mutex);
	self->priv->input_pos = pos;
	g_cond_signal (self->priv->worker_cond);
	g_mutex_unlock (self->priv->worker_mutex);
}


static void* spek_pipeline_worker_func (SpekPipeline* self) {
	void* result = NULL;
	gint sample;
	gint64 frames;
	gint64 num_fft;
	gint64 acc_error;
	gint head;
	gint tail;
	gint prev_head;
	g_return_val_if_fail (self != NULL, NULL);
	sample = 0;
	frames = (gint64) 0;
	num_fft = (gint64) 0;
	acc_error = (gint64) 0;
	head = 0;
	tail = 0;
	prev_head = 0;
	memset (self->priv->output, 0, (gsize) (sizeof (float) * self->priv->bands));
	while (TRUE) {
		g_mutex_lock (self->priv->reader_mutex);
		self->priv->worker_done = TRUE;
		g_cond_signal (self->priv->reader_cond);
		g_mutex_unlock (self->priv->reader_mutex);
		g_mutex_lock (self->priv->worker_mutex);
		while (TRUE) {
			if (!(tail == self->priv->input_pos)) {
				break;
			}
			g_cond_wait (self->priv->worker_cond, self->priv->worker_mutex);
		}
		tail = self->priv->input_pos;
		g_mutex_unlock (self->priv->worker_mutex);
		if (tail == (-1)) {
			result = NULL;
			return result;
		}
		while (TRUE) {
			gboolean _tmp0_ = FALSE;
			gboolean int_full;
			gboolean _tmp1_ = FALSE;
			gboolean int_over;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp7_ = FALSE;
			head = (head + 1) % self->priv->input_size;
			if (head == tail) {
				head = prev_head;
				break;
			}
			frames++;
			if (acc_error < self->priv->cx->error_base) {
				_tmp0_ = frames == self->priv->cx->frames_per_interval;
			} else {
				_tmp0_ = FALSE;
			}
			int_full = _tmp0_;
			if (acc_error >= self->priv->cx->error_base) {
				_tmp1_ = frames == (1 + self->priv->cx->frames_per_interval);
			} else {
				_tmp1_ = FALSE;
			}
			int_over = _tmp1_;
			if ((frames % self->priv->nfft) == 0) {
				_tmp2_ = TRUE;
			} else {
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				if (int_full) {
					_tmp4_ = TRUE;
				} else {
					_tmp4_ = int_over;
				}
				if (_tmp4_) {
					_tmp3_ = num_fft == 0;
				} else {
					_tmp3_ = FALSE;
				}
				_tmp2_ = _tmp3_;
			}
			if (_tmp2_) {
				prev_head = head;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							float val;
							if (!_tmp5_) {
								i++;
							}
							_tmp5_ = FALSE;
							if (!(i < self->priv->nfft)) {
								break;
							}
							val = self->priv->input[(((self->priv->input_size + head) - self->priv->nfft) + i) % self->priv->input_size];
							val = val * (0.53836f - (0.46164f * self->priv->coss[i]));
							self->priv->fft->input[i] = val;
						}
					}
				}
				spek_fft_execute (self->priv->fft);
				num_fft++;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							if (!_tmp6_) {
								i++;
							}
							_tmp6_ = FALSE;
							if (!(i < self->priv->bands)) {
								break;
							}
							self->priv->output[i] += self->priv->fft->output[i];
						}
					}
				}
			}
			if (int_full) {
				_tmp7_ = TRUE;
			} else {
				_tmp7_ = int_over;
			}
			if (_tmp7_) {
				if (int_over) {
					acc_error = acc_error - self->priv->cx->error_base;
				} else {
					acc_error = acc_error + self->priv->cx->error_per_interval;
				}
				{
					gint i;
					i = 0;
					{
						gboolean _tmp8_;
						_tmp8_ = TRUE;
						while (TRUE) {
							if (!_tmp8_) {
								i++;
							}
							_tmp8_ = FALSE;
							if (!(i < self->priv->bands)) {
								break;
							}
							self->priv->output[i] /= (float) num_fft;
						}
					}
				}
				if (sample == self->priv->samples) {
					break;
				}
				self->priv->cb (sample++, self->priv->output, self->priv->output_length1, self->priv->cb_target);
				memset (self->priv->output, 0, (gsize) (sizeof (float) * self->priv->bands));
				frames = (gint64) 0;
				num_fft = (gint64) 0;
			}
		}
	}
}


static float spek_pipeline_average_input (SpekPipeline* self, guint8* buffer) {
	float result = 0.0F;
	gint channels;
	float res;
	g_return_val_if_fail (self != NULL, 0.0F);
	channels = self->priv->cx->channels;
	res = 0.f;
	if (self->priv->cx->fp) {
		if (self->priv->cx->width == 32) {
			float* p;
			p = (float*) buffer;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < channels)) {
							break;
						}
						res = res + p[i];
					}
				}
			}
		} else {
			double* p;
			g_assert (self->priv->cx->width == 64);
			p = (double*) buffer;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp1_;
					_tmp1_ = TRUE;
					while (TRUE) {
						if (!_tmp1_) {
							i++;
						}
						_tmp1_ = FALSE;
						if (!(i < channels)) {
							break;
						}
						res = res + ((float) p[i]);
					}
				}
			}
		}
	} else {
		if (self->priv->cx->width == 16) {
			gint16* p;
			p = (gint16*) buffer;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp2_;
					_tmp2_ = TRUE;
					while (TRUE) {
						if (!_tmp2_) {
							i++;
						}
						_tmp2_ = FALSE;
						if (!(i < channels)) {
							break;
						}
						res = res + (p[i] / ((float) G_MAXINT16));
					}
				}
			}
		} else {
			gint32* p;
			g_assert (self->priv->cx->width == 32);
			p = (gint32*) buffer;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp3_;
					_tmp3_ = TRUE;
					while (TRUE) {
						if (!_tmp3_) {
							i++;
						}
						_tmp3_ = FALSE;
						if (!(i < channels)) {
							break;
						}
						res = res + (p[i] / ((float) G_MAXINT32));
					}
				}
			}
		}
	}
	result = res / channels;
	return result;
}


const char* spek_pipeline_get_description (SpekPipeline* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_description;
	return result;
}


static void spek_pipeline_set_description (SpekPipeline* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_description), _tmp0_);
}


gint spek_pipeline_get_sample_rate (SpekPipeline* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sample_rate;
	return result;
}


static void spek_pipeline_set_sample_rate (SpekPipeline* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_sample_rate = value;
}


double spek_pipeline_get_duration (SpekPipeline* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->cx->duration;
	return result;
}


static void spek_value_pipeline_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void spek_value_pipeline_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		spek_pipeline_unref (value->data[0].v_pointer);
	}
}


static void spek_value_pipeline_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = spek_pipeline_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer spek_value_pipeline_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* spek_value_pipeline_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SpekPipeline* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = spek_pipeline_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* spek_value_pipeline_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SpekPipeline** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = spek_pipeline_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* spek_param_spec_pipeline (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SpekParamSpecPipeline* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SPEK_TYPE_PIPELINE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer spek_value_get_pipeline (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPEK_TYPE_PIPELINE), NULL);
	return value->data[0].v_pointer;
}


void spek_value_set_pipeline (GValue* value, gpointer v_object) {
	SpekPipeline* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPEK_TYPE_PIPELINE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SPEK_TYPE_PIPELINE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		spek_pipeline_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		spek_pipeline_unref (old);
	}
}


void spek_value_take_pipeline (GValue* value, gpointer v_object) {
	SpekPipeline* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPEK_TYPE_PIPELINE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SPEK_TYPE_PIPELINE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		spek_pipeline_unref (old);
	}
}


static void spek_pipeline_class_init (SpekPipelineClass * klass) {
	spek_pipeline_parent_class = g_type_class_peek_parent (klass);
	SPEK_PIPELINE_CLASS (klass)->finalize = spek_pipeline_finalize;
	g_type_class_add_private (klass, sizeof (SpekPipelinePrivate));
}


static void spek_pipeline_instance_init (SpekPipeline * self) {
	self->priv = SPEK_PIPELINE_GET_PRIVATE (self);
	self->priv->reader_thread = NULL;
	self->priv->worker_done = FALSE;
	g_static_rec_mutex_init (&self->priv->__lock_quit);
	self->priv->quit = FALSE;
	self->ref_count = 1;
}


static void spek_pipeline_finalize (SpekPipeline* obj) {
	SpekPipeline * self;
	self = SPEK_PIPELINE (obj);
	{
		spek_pipeline_stop (self);
	}
	_g_free0 (self->priv->_description);
	_spek_audio_close0 (self->priv->cx);
	(self->priv->cb_target_destroy_notify == NULL) ? NULL : (self->priv->cb_target_destroy_notify (self->priv->cb_target), NULL);
	self->priv->cb = NULL;
	self->priv->cb_target = NULL;
	self->priv->cb_target_destroy_notify = NULL;
	_spek_fft_destroy0 (self->priv->fft);
	self->priv->coss = (g_free (self->priv->coss), NULL);
	self->priv->input = (g_free (self->priv->input), NULL);
	self->priv->output = (g_free (self->priv->output), NULL);
	_g_mutex_free0 (self->priv->reader_mutex);
	_g_cond_free0 (self->priv->reader_cond);
	_g_mutex_free0 (self->priv->worker_mutex);
	_g_cond_free0 (self->priv->worker_cond);
	g_static_rec_mutex_free (&self->priv->__lock_quit);
}


GType spek_pipeline_get_type (void) {
	static volatile gsize spek_pipeline_type_id__volatile = 0;
	if (g_once_init_enter (&spek_pipeline_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { spek_value_pipeline_init, spek_value_pipeline_free_value, spek_value_pipeline_copy_value, spek_value_pipeline_peek_pointer, "p", spek_value_pipeline_collect_value, "p", spek_value_pipeline_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SpekPipelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spek_pipeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpekPipeline), 0, (GInstanceInitFunc) spek_pipeline_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType spek_pipeline_type_id;
		spek_pipeline_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SpekPipeline", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&spek_pipeline_type_id__volatile, spek_pipeline_type_id);
	}
	return spek_pipeline_type_id__volatile;
}


gpointer spek_pipeline_ref (gpointer instance) {
	SpekPipeline* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void spek_pipeline_unref (gpointer instance) {
	SpekPipeline* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SPEK_PIPELINE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




