#!/usr/local/bin/python
#
# A little demo to test integer arithmetic in SAML; it will compute the
# factorial of argv[1] (or 300 if no argument is given).
#
# You should compare with factorial0() which does the same job but
# with the builtin "long" integers of Python.

from sys import *
from saml1 import *
from string import atoi

def factorial0(n):
  f = 1l
  while n > 0:
    f,n = f*n,n-1
  return f

def factorial(n):
  f = Mathnode(ST_INTEGER, "1")
  while n > 0:
    f,n = f*n,n-1
  return f

def test():
  number = 300
  if len(argv)==2:
    number = atoi(argv[1])
  print '%d! == %s' % (number,factorial(number))

if __name__ == '__main__':
  test()
