/* rygel-searchable-container-test.c generated by valac 0.14.2, the Vala compiler
 * generated from rygel-searchable-container-test.vala, do not modify */

/*
 * Copyright (C) 2012 Jens Georg.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define TYPE_SEARCH_EXPRESSION (search_expression_get_type ())
#define SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_EXPRESSION, SearchExpression))
#define SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))
#define IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_EXPRESSION))
#define IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_EXPRESSION))
#define SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))

typedef struct _SearchExpression SearchExpression;
typedef struct _SearchExpressionClass SearchExpressionClass;
typedef struct _SearchExpressionPrivate SearchExpressionPrivate;

#define TYPE_RELATIONAL_EXPRESSION (relational_expression_get_type ())
#define RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpression))
#define RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))
#define IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RELATIONAL_EXPRESSION))
#define IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RELATIONAL_EXPRESSION))
#define RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))

typedef struct _RelationalExpression RelationalExpression;
typedef struct _RelationalExpressionClass RelationalExpressionClass;
typedef struct _RelationalExpressionPrivate RelationalExpressionPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MEDIA_OBJECT (media_object_get_type ())
#define MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT, MediaObject))
#define MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECT, MediaObjectClass))
#define IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT))
#define IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECT))
#define MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECT, MediaObjectClass))

typedef struct _MediaObject MediaObject;
typedef struct _MediaObjectClass MediaObjectClass;
typedef struct _MediaObjectPrivate MediaObjectPrivate;

#define TYPE_MEDIA_CONTAINER (media_container_get_type ())
#define MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER, MediaContainer))
#define MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_CONTAINER, MediaContainerClass))
#define IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER))
#define IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_CONTAINER))
#define MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_CONTAINER, MediaContainerClass))

typedef struct _MediaContainer MediaContainer;
typedef struct _MediaContainerClass MediaContainerClass;
typedef struct _MediaContainerPrivate MediaContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA_OBJECTS (media_objects_get_type ())
#define MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECTS, MediaObjects))
#define MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECTS, MediaObjectsClass))
#define IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECTS))
#define IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECTS))
#define MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECTS, MediaObjectsClass))

typedef struct _MediaObjects MediaObjects;
typedef struct _MediaObjectsClass MediaObjectsClass;
typedef struct _Block1Data Block1Data;
typedef struct _MediaContainerGetChildrenData MediaContainerGetChildrenData;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define TYPE_TEST_CONTAINER (test_container_get_type ())
#define TEST_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_CONTAINER, TestContainer))
#define TEST_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_CONTAINER, TestContainerClass))
#define IS_TEST_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_CONTAINER))
#define IS_TEST_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_CONTAINER))
#define TEST_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_CONTAINER, TestContainerClass))

typedef struct _TestContainer TestContainer;
typedef struct _TestContainerClass TestContainerClass;
typedef struct _TestContainerPrivate TestContainerPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _TestContainerTestSearchNoLimitData TestContainerTestSearchNoLimitData;
typedef struct _TestContainerTestSearchWithLimitData TestContainerTestSearchWithLimitData;
typedef struct _TestContainerSearchData TestContainerSearchData;
typedef struct _MediaObjectsPrivate MediaObjectsPrivate;

struct _SearchExpression {
	GObject parent_instance;
	SearchExpressionPrivate * priv;
	gchar* operand1;
	gchar* operand2;
	gchar* op;
};

struct _SearchExpressionClass {
	GObjectClass parent_class;
};

struct _RelationalExpression {
	SearchExpression parent_instance;
	RelationalExpressionPrivate * priv;
};

struct _RelationalExpressionClass {
	SearchExpressionClass parent_class;
};

struct _MediaObject {
	GObject parent_instance;
	MediaObjectPrivate * priv;
};

struct _MediaObjectClass {
	GObjectClass parent_class;
};

struct _MediaContainer {
	MediaObject parent_instance;
	MediaContainerPrivate * priv;
	guint child_count;
};

struct _MediaContainerClass {
	MediaObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	MediaContainer * self;
	gpointer _async_data_;
};

struct _MediaContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MediaContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	MediaObjects* result;
	Block1Data* _data1_;
	MediaObjects* _tmp0_;
	MediaObjects* _result_;
	gint i;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	MediaObjects* _tmp5_;
	MediaObject* _tmp6_;
	MediaObject* _tmp7_;
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	MediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _TestContainer {
	MediaContainer parent_instance;
	TestContainerPrivate * priv;
	GMainLoop* loop;
};

struct _TestContainerClass {
	MediaContainerClass parent_class;
};

struct _TestContainerPrivate {
	GeeArrayList* _search_classes;
};

struct _TestContainerTestSearchNoLimitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestContainer* self;
	guint total_matches;
	guint _tmp0_;
	MediaObjects* _tmp1_;
	MediaObjects* _result_;
	guint _tmp2_;
	MediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	guint _tmp6_;
	MediaObjects* _tmp7_;
	MediaObjects* _tmp8_;
	guint _tmp9_;
	MediaObjects* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint i;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	guint _tmp18_;
	MediaObjects* _tmp19_;
	MediaObjects* _tmp20_;
	guint _tmp21_;
	MediaObjects* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GMainLoop* _tmp26_;
	GError * _inner_error_;
};

struct _TestContainerTestSearchWithLimitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestContainer* self;
	guint total_matches;
	guint _tmp0_;
	MediaObjects* _tmp1_;
	MediaObjects* _result_;
	guint _tmp2_;
	MediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	guint _tmp6_;
	MediaObjects* _tmp7_;
	MediaObjects* _tmp8_;
	guint _tmp9_;
	MediaObjects* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint i;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	guint _tmp18_;
	MediaObjects* _tmp19_;
	MediaObjects* _tmp20_;
	guint _tmp21_;
	MediaObjects* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GMainLoop* _tmp27_;
	GError * _inner_error_;
};

struct _TestContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestContainer* self;
	SearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	MediaObjects* result;
	SearchExpression* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GCancellable* _tmp3_;
	guint _tmp4_;
	MediaObjects* _tmp5_;
	MediaObjects* _tmp6_;
	GError * _inner_error_;
};

struct _MediaObjects {
	GeeArrayList parent_instance;
	MediaObjectsPrivate * priv;
};

struct _MediaObjectsClass {
	GeeArrayListClass parent_class;
};


static gpointer relational_expression_parent_class = NULL;
static gpointer search_expression_parent_class = NULL;
static gpointer media_object_parent_class = NULL;
static gpointer media_container_parent_class = NULL;
static gpointer test_container_parent_class = NULL;
static RygelSearchableContainerIface* test_container_rygel_searchable_container_parent_iface = NULL;
static gpointer media_objects_parent_class = NULL;

GType search_expression_get_type (void) G_GNUC_CONST;
GType relational_expression_get_type (void) G_GNUC_CONST;
enum  {
	RELATIONAL_EXPRESSION_DUMMY_PROPERTY
};
RelationalExpression* relational_expression_new (void);
RelationalExpression* relational_expression_construct (GType object_type);
SearchExpression* search_expression_new (void);
SearchExpression* search_expression_construct (GType object_type);
#define SEARCH_CRITERIA_OP_EQ "="
enum  {
	SEARCH_EXPRESSION_DUMMY_PROPERTY
};
GType media_object_get_type (void) G_GNUC_CONST;
gboolean search_expression_satisfied_by (SearchExpression* self, MediaObject* object);
static void search_expression_finalize (GObject* obj);
enum  {
	MEDIA_OBJECT_DUMMY_PROPERTY
};
MediaObject* media_object_new (void);
MediaObject* media_object_construct (GType object_type);
GType media_container_get_type (void) G_GNUC_CONST;
enum  {
	MEDIA_CONTAINER_DUMMY_PROPERTY
};
static void media_container_get_children_data_free (gpointer _data);
GType media_objects_get_type (void) G_GNUC_CONST;
void media_container_get_children (MediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* media_container_get_children_finish (MediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean media_container_get_children_co (MediaContainerGetChildrenData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean __lambda0_ (Block1Data* _data1_);
static gboolean ___lambda0__gsource_func (gpointer self);
MediaObjects* media_objects_new (void);
MediaObjects* media_objects_construct (GType object_type);
MediaContainer* media_container_new (void);
MediaContainer* media_container_construct (GType object_type);
static void media_container_finalize (GObject* obj);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType test_container_get_type (void) G_GNUC_CONST;
#define TEST_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_CONTAINER, TestContainerPrivate))
enum  {
	TEST_CONTAINER_DUMMY_PROPERTY,
	TEST_CONTAINER_SEARCH_CLASSES
};
static void test_container_test_search_no_limit_data_free (gpointer _data);
void test_container_test_search_no_limit (TestContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void test_container_test_search_no_limit_finish (TestContainer* self, GAsyncResult* _res_);
static gboolean test_container_test_search_no_limit_co (TestContainerTestSearchNoLimitData* _data_);
void rygel_searchable_container_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void test_container_test_search_no_limit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_container_test_search_with_limit_data_free (gpointer _data);
void test_container_test_search_with_limit (TestContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void test_container_test_search_with_limit_finish (TestContainer* self, GAsyncResult* _res_);
static gboolean test_container_test_search_with_limit_co (TestContainerTestSearchWithLimitData* _data_);
static void test_container_test_search_with_limit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_container_real_search_data_free (gpointer _data);
static void test_container_real_search (RygelSearchableContainer* base, SearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean test_container_real_search_co (TestContainerSearchData* _data_);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void test_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TestContainer* test_container_new (void);
TestContainer* test_container_construct (GType object_type);
static void test_container_finalize (GObject* obj);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
static void _vala_test_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);
static void _vala_test_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	MEDIA_OBJECTS_DUMMY_PROPERTY
};
static GeeList* media_objects_real_slice (GeeAbstractList* base, gint start, gint stop);
gint _vala_main (void);


RelationalExpression* relational_expression_construct (GType object_type) {
	RelationalExpression * self = NULL;
#line 23 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (RelationalExpression*) search_expression_construct (object_type);
#line 23 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 411 "rygel-searchable-container-test.c"
}


RelationalExpression* relational_expression_new (void) {
#line 23 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return relational_expression_construct (TYPE_RELATIONAL_EXPRESSION);
#line 418 "rygel-searchable-container-test.c"
}


static void relational_expression_class_init (RelationalExpressionClass * klass) {
#line 23 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	relational_expression_parent_class = g_type_class_peek_parent (klass);
#line 425 "rygel-searchable-container-test.c"
}


static void relational_expression_instance_init (RelationalExpression * self) {
}


GType relational_expression_get_type (void) {
	static volatile gsize relational_expression_type_id__volatile = 0;
	if (g_once_init_enter (&relational_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RelationalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) relational_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RelationalExpression), 0, (GInstanceInitFunc) relational_expression_instance_init, NULL };
		GType relational_expression_type_id;
		relational_expression_type_id = g_type_register_static (TYPE_SEARCH_EXPRESSION, "RelationalExpression", &g_define_type_info, 0);
		g_once_init_leave (&relational_expression_type_id__volatile, relational_expression_type_id);
	}
	return relational_expression_type_id__volatile;
}


gboolean search_expression_satisfied_by (SearchExpression* self, MediaObject* object) {
	gboolean result = FALSE;
#line 35 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 35 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_return_val_if_fail (object != NULL, FALSE);
#line 36 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = TRUE;
#line 36 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 455 "rygel-searchable-container-test.c"
}


SearchExpression* search_expression_construct (GType object_type) {
	SearchExpression * self = NULL;
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (SearchExpression*) g_object_new (object_type, NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 465 "rygel-searchable-container-test.c"
}


SearchExpression* search_expression_new (void) {
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return search_expression_construct (TYPE_SEARCH_EXPRESSION);
#line 472 "rygel-searchable-container-test.c"
}


static void search_expression_class_init (SearchExpressionClass * klass) {
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	search_expression_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->finalize = search_expression_finalize;
#line 481 "rygel-searchable-container-test.c"
}


static void search_expression_instance_init (SearchExpression * self) {
}


static void search_expression_finalize (GObject* obj) {
	SearchExpression * self;
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = SEARCH_EXPRESSION (obj);
#line 31 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (self->operand1);
#line 32 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (self->operand2);
#line 33 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (self->op);
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (search_expression_parent_class)->finalize (obj);
#line 501 "rygel-searchable-container-test.c"
}


GType search_expression_get_type (void) {
	static volatile gsize search_expression_type_id__volatile = 0;
	if (g_once_init_enter (&search_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchExpression), 0, (GInstanceInitFunc) search_expression_instance_init, NULL };
		GType search_expression_type_id;
		search_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchExpression", &g_define_type_info, 0);
		g_once_init_leave (&search_expression_type_id__volatile, search_expression_type_id);
	}
	return search_expression_type_id__volatile;
}


MediaObject* media_object_construct (GType object_type) {
	MediaObject * self = NULL;
#line 40 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (MediaObject*) g_object_new (object_type, NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 523 "rygel-searchable-container-test.c"
}


MediaObject* media_object_new (void) {
#line 40 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return media_object_construct (TYPE_MEDIA_OBJECT);
#line 530 "rygel-searchable-container-test.c"
}


static void media_object_class_init (MediaObjectClass * klass) {
#line 40 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	media_object_parent_class = g_type_class_peek_parent (klass);
#line 537 "rygel-searchable-container-test.c"
}


static void media_object_instance_init (MediaObject * self) {
}


GType media_object_get_type (void) {
	static volatile gsize media_object_type_id__volatile = 0;
	if (g_once_init_enter (&media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaObject), 0, (GInstanceInitFunc) media_object_instance_init, NULL };
		GType media_object_type_id;
		media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "MediaObject", &g_define_type_info, 0);
		g_once_init_leave (&media_object_type_id__volatile, media_object_type_id);
	}
	return media_object_type_id__volatile;
}


static void media_container_get_children_data_free (gpointer _data) {
	MediaContainerGetChildrenData* _data_;
	_data_ = _data;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->result);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->self);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_slice_free (MediaContainerGetChildrenData, _data_);
#line 568 "rygel-searchable-container-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 575 "rygel-searchable-container-test.c"
}


void media_container_get_children (MediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MediaContainerGetChildrenData* _data_;
	MediaContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_slice_new0 (MediaContainerGetChildrenData);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, media_container_get_children);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, media_container_get_children_data_free);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->self = _tmp0_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = offset;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->offset = _tmp1_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp2_ = max_count;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->max_count = _tmp2_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp3_ = cancellable;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->cancellable = _tmp4_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	media_container_get_children_co (_data_);
#line 612 "rygel-searchable-container-test.c"
}


MediaObjects* media_container_get_children_finish (MediaContainer* self, GAsyncResult* _res_, GError** error) {
	MediaObjects* result;
	MediaContainerGetChildrenData* _data_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return NULL;
#line 623 "rygel-searchable-container-test.c"
	}
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = _data_->result;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->result = NULL;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 633 "rygel-searchable-container-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return _data1_;
#line 642 "rygel-searchable-container-test.c"
}


static void block1_data_unref (Block1Data* _data1_) {
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_object_unref0 (_data1_->self);
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 653 "rygel-searchable-container-test.c"
	}
}


static gboolean __lambda0_ (Block1Data* _data1_) {
	MediaContainer * self;
	gboolean result = FALSE;
#line 49 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = _data1_->self;
#line 49 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	media_container_get_children_co (_data1_->_async_data_);
#line 49 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = FALSE;
#line 49 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 669 "rygel-searchable-container-test.c"
}


static gboolean ___lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda0_ (self);
#line 49 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 678 "rygel-searchable-container-test.c"
}


static gboolean media_container_get_children_co (MediaContainerGetChildrenData* _data_) {
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (_data_->_state_) {
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 0:
#line 687 "rygel-searchable-container-test.c"
		goto _state_0;
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 1:
#line 691 "rygel-searchable-container-test.c"
		goto _state_1;
		default:
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 696 "rygel-searchable-container-test.c"
	}
	_state_0:
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 49 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda0__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_state_ = 1;
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 713 "rygel-searchable-container-test.c"
	_state_1:
	;
#line 52 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp0_ = media_objects_new ();
#line 52 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 720 "rygel-searchable-container-test.c"
	{
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->i = 0;
#line 724 "rygel-searchable-container-test.c"
		{
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			_data_->_tmp1_ = TRUE;
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			while (TRUE) {
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp2_ = _data_->_tmp1_;
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!_data_->_tmp2_) {
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp3_ = _data_->i;
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->i = _data_->_tmp3_ + 1;
#line 738 "rygel-searchable-container-test.c"
				}
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp1_ = FALSE;
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp4_ = _data_->i;
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!(_data_->_tmp4_ < 10)) {
#line 53 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					break;
#line 748 "rygel-searchable-container-test.c"
				}
#line 54 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp5_ = _data_->_result_;
#line 54 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp6_ = media_object_new ();
#line 54 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp7_ = _data_->_tmp6_;
#line 54 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp5_, _data_->_tmp7_);
#line 54 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_g_object_unref0 (_data_->_tmp7_);
#line 760 "rygel-searchable-container-test.c"
			}
		}
	}
#line 57 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->result = _data_->_result_;
#line 57 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	block1_data_unref (_data_->_data1_);
#line 57 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 57 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 774 "rygel-searchable-container-test.c"
	} else {
#line 57 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 778 "rygel-searchable-container-test.c"
	}
#line 57 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 57 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->_result_);
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	block1_data_unref (_data_->_data1_);
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_ = NULL;
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 794 "rygel-searchable-container-test.c"
	} else {
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 798 "rygel-searchable-container-test.c"
	}
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 804 "rygel-searchable-container-test.c"
}


MediaContainer* media_container_construct (GType object_type) {
	MediaContainer * self = NULL;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (MediaContainer*) media_object_construct (object_type);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 814 "rygel-searchable-container-test.c"
}


MediaContainer* media_container_new (void) {
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return media_container_construct (TYPE_MEDIA_CONTAINER);
#line 821 "rygel-searchable-container-test.c"
}


static void media_container_class_init (MediaContainerClass * klass) {
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	media_container_parent_class = g_type_class_peek_parent (klass);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->finalize = media_container_finalize;
#line 830 "rygel-searchable-container-test.c"
}


static void media_container_instance_init (MediaContainer * self) {
#line 44 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self->child_count = (guint) 10;
#line 837 "rygel-searchable-container-test.c"
}


static void media_container_finalize (GObject* obj) {
	MediaContainer * self;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = MEDIA_CONTAINER (obj);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (media_container_parent_class)->finalize (obj);
#line 847 "rygel-searchable-container-test.c"
}


GType media_container_get_type (void) {
	static volatile gsize media_container_type_id__volatile = 0;
	if (g_once_init_enter (&media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaContainer), 0, (GInstanceInitFunc) media_container_instance_init, NULL };
		GType media_container_type_id;
		media_container_type_id = g_type_register_static (TYPE_MEDIA_OBJECT, "MediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&media_container_type_id__volatile, media_container_type_id);
	}
	return media_container_type_id__volatile;
}


static void test_container_test_search_no_limit_data_free (gpointer _data) {
	TestContainerTestSearchNoLimitData* _data_;
	_data_ = _data;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->self);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_slice_free (TestContainerTestSearchNoLimitData, _data_);
#line 870 "rygel-searchable-container-test.c"
}


void test_container_test_search_no_limit (TestContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestContainerTestSearchNoLimitData* _data_;
	TestContainer* _tmp0_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_slice_new0 (TestContainerTestSearchNoLimitData);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, test_container_test_search_no_limit);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_container_test_search_no_limit_data_free);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->self = _tmp0_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_no_limit_co (_data_);
#line 889 "rygel-searchable-container-test.c"
}


void test_container_test_search_no_limit_finish (TestContainer* self, GAsyncResult* _res_) {
	TestContainerTestSearchNoLimitData* _data_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 897 "rygel-searchable-container-test.c"
}


static void test_container_test_search_no_limit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestContainerTestSearchNoLimitData* _data_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = _user_data_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_source_object_ = source_object;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_res_ = _res_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_no_limit_co (_data_);
#line 911 "rygel-searchable-container-test.c"
}


static gboolean test_container_test_search_no_limit_co (TestContainerTestSearchNoLimitData* _data_) {
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (_data_->_state_) {
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 0:
#line 920 "rygel-searchable-container-test.c"
		goto _state_0;
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 1:
#line 924 "rygel-searchable-container-test.c"
		goto _state_1;
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 2:
#line 928 "rygel-searchable-container-test.c"
		goto _state_2;
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 3:
#line 932 "rygel-searchable-container-test.c"
		goto _state_3;
		default:
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 937 "rygel-searchable-container-test.c"
	}
	_state_0:
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp0_ = 0U;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_state_ = 1;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 0, (guint) 0, NULL, test_container_test_search_no_limit_ready, _data_);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 948 "rygel-searchable-container-test.c"
	_state_1:
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp1_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp1_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp0_, &_data_->_inner_error_);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->total_matches = _data_->_tmp0_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_result_ = _data_->_tmp1_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 966 "rygel-searchable-container-test.c"
	}
#line 71 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp2_ = _data_->total_matches;
#line 71 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_assert (_data_->_tmp2_ == ((guint) 10));
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp3_ = _data_->_result_;
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_assert (_data_->_tmp5_ == 10);
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp6_ = 0U;
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_state_ = 2;
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 10, (guint) 0, NULL, test_container_test_search_no_limit_ready, _data_);
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 988 "rygel-searchable-container-test.c"
	_state_2:
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp7_ = NULL;
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp7_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->total_matches = _data_->_tmp6_;
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_object_unref0 (_data_->_result_);
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1008 "rygel-searchable-container-test.c"
	}
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->_result_);
#line 74 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_result_ = _data_->_tmp8_;
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp9_ = _data_->total_matches;
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_assert (_data_->_tmp9_ == ((guint) 10));
#line 76 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp10_ = _data_->_result_;
#line 76 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp10_);
#line 76 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp12_ = _data_->_tmp11_;
#line 76 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_assert (_data_->_tmp12_ == 0);
#line 1026 "rygel-searchable-container-test.c"
	{
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->i = 1;
#line 1030 "rygel-searchable-container-test.c"
		{
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			_data_->_tmp13_ = TRUE;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			while (TRUE) {
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp14_ = _data_->_tmp13_;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!_data_->_tmp14_) {
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp15_ = _data_->i;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->i = _data_->_tmp15_ + 1;
#line 1044 "rygel-searchable-container-test.c"
				}
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp13_ = FALSE;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp16_ = _data_->i;
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!(_data_->_tmp16_ < 10)) {
#line 78 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					break;
#line 1054 "rygel-searchable-container-test.c"
				}
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp17_ = _data_->i;
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp18_ = 0U;
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_state_ = 3;
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) _data_->_tmp17_, (guint) 0, NULL, test_container_test_search_no_limit_ready, _data_);
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				return FALSE;
#line 1066 "rygel-searchable-container-test.c"
				_state_3:
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp19_ = NULL;
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp19_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp18_, &_data_->_inner_error_);
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->total_matches = _data_->_tmp18_;
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp20_ = _data_->_tmp19_;
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (_data_->_inner_error_ != NULL) {
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_g_object_unref0 (_data_->_result_);
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					g_clear_error (&_data_->_inner_error_);
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					return FALSE;
#line 1086 "rygel-searchable-container-test.c"
				}
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_g_object_unref0 (_data_->_result_);
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_result_ = _data_->_tmp20_;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp21_ = _data_->total_matches;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				g_assert (_data_->_tmp21_ == ((guint) 10));
#line 81 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp22_ = _data_->_result_;
#line 81 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp22_);
#line 81 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp24_ = _data_->_tmp23_;
#line 81 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp25_ = _data_->i;
#line 81 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				g_assert (_data_->_tmp24_ == (10 - _data_->_tmp25_));
#line 1106 "rygel-searchable-container-test.c"
			}
		}
	}
#line 84 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp26_ = _data_->self->loop;
#line 84 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_main_loop_quit (_data_->_tmp26_);
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->_result_);
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1120 "rygel-searchable-container-test.c"
	} else {
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1124 "rygel-searchable-container-test.c"
	}
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 66 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 1130 "rygel-searchable-container-test.c"
}


static void test_container_test_search_with_limit_data_free (gpointer _data) {
	TestContainerTestSearchWithLimitData* _data_;
	_data_ = _data;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->self);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_slice_free (TestContainerTestSearchWithLimitData, _data_);
#line 1141 "rygel-searchable-container-test.c"
}


void test_container_test_search_with_limit (TestContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestContainerTestSearchWithLimitData* _data_;
	TestContainer* _tmp0_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_slice_new0 (TestContainerTestSearchWithLimitData);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, test_container_test_search_with_limit);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_container_test_search_with_limit_data_free);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->self = _tmp0_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_with_limit_co (_data_);
#line 1160 "rygel-searchable-container-test.c"
}


void test_container_test_search_with_limit_finish (TestContainer* self, GAsyncResult* _res_) {
	TestContainerTestSearchWithLimitData* _data_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1168 "rygel-searchable-container-test.c"
}


static void test_container_test_search_with_limit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestContainerTestSearchWithLimitData* _data_;
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = _user_data_;
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_source_object_ = source_object;
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_res_ = _res_;
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_with_limit_co (_data_);
#line 1182 "rygel-searchable-container-test.c"
}


static gboolean test_container_test_search_with_limit_co (TestContainerTestSearchWithLimitData* _data_) {
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (_data_->_state_) {
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 0:
#line 1191 "rygel-searchable-container-test.c"
		goto _state_0;
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 1:
#line 1195 "rygel-searchable-container-test.c"
		goto _state_1;
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 2:
#line 1199 "rygel-searchable-container-test.c"
		goto _state_2;
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 3:
#line 1203 "rygel-searchable-container-test.c"
		goto _state_3;
		default:
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 1208 "rygel-searchable-container-test.c"
	}
	_state_0:
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp0_ = 0U;
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_state_ = 1;
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 0, (guint) 4, NULL, test_container_test_search_with_limit_ready, _data_);
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 1219 "rygel-searchable-container-test.c"
	_state_1:
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp1_ = NULL;
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp1_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp0_, &_data_->_inner_error_);
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->total_matches = _data_->_tmp0_;
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_result_ = _data_->_tmp1_;
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 91 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1237 "rygel-searchable-container-test.c"
	}
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp2_ = _data_->total_matches;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_assert (_data_->_tmp2_ == ((guint) 0));
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp3_ = _data_->_result_;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_assert (_data_->_tmp5_ == 4);
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp6_ = 0U;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_state_ = 2;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 10, (guint) 4, NULL, test_container_test_search_with_limit_ready, _data_);
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 1259 "rygel-searchable-container-test.c"
	_state_2:
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp7_ = NULL;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp7_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->total_matches = _data_->_tmp6_;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_object_unref0 (_data_->_result_);
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1279 "rygel-searchable-container-test.c"
	}
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->_result_);
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_result_ = _data_->_tmp8_;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp9_ = _data_->total_matches;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_assert (_data_->_tmp9_ == ((guint) 0));
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp10_ = _data_->_result_;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp10_);
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp12_ = _data_->_tmp11_;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_assert (_data_->_tmp12_ == 0);
#line 1297 "rygel-searchable-container-test.c"
	{
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->i = 1;
#line 1301 "rygel-searchable-container-test.c"
		{
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			_data_->_tmp13_ = TRUE;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			while (TRUE) {
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp14_ = _data_->_tmp13_;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!_data_->_tmp14_) {
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp15_ = _data_->i;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->i = _data_->_tmp15_ + 1;
#line 1315 "rygel-searchable-container-test.c"
				}
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp13_ = FALSE;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp16_ = _data_->i;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!(_data_->_tmp16_ < 10)) {
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					break;
#line 1325 "rygel-searchable-container-test.c"
				}
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp17_ = _data_->i;
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp18_ = 0U;
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_state_ = 3;
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) _data_->_tmp17_, (guint) 3, NULL, test_container_test_search_with_limit_ready, _data_);
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				return FALSE;
#line 1337 "rygel-searchable-container-test.c"
				_state_3:
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp19_ = NULL;
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp19_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp18_, &_data_->_inner_error_);
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->total_matches = _data_->_tmp18_;
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp20_ = _data_->_tmp19_;
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (_data_->_inner_error_ != NULL) {
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_g_object_unref0 (_data_->_result_);
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					g_clear_error (&_data_->_inner_error_);
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					return FALSE;
#line 1357 "rygel-searchable-container-test.c"
				}
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_g_object_unref0 (_data_->_result_);
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_result_ = _data_->_tmp20_;
#line 101 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp21_ = _data_->total_matches;
#line 101 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				g_assert (_data_->_tmp21_ == ((guint) 0));
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp22_ = _data_->_result_;
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp22_);
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp24_ = _data_->_tmp23_;
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp25_ = _data_->i;
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp26_ = 0;
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp26_ = MIN (10 - _data_->_tmp25_, 3);
#line 102 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				g_assert (_data_->_tmp24_ == _data_->_tmp26_);
#line 1381 "rygel-searchable-container-test.c"
			}
		}
	}
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp27_ = _data_->self->loop;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_main_loop_quit (_data_->_tmp27_);
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->_result_);
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1395 "rygel-searchable-container-test.c"
	} else {
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1399 "rygel-searchable-container-test.c"
	}
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 1405 "rygel-searchable-container-test.c"
}


static void test_container_real_search_data_free (gpointer _data) {
	TestContainerSearchData* _data_;
	_data_ = _data;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->expression);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->result);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->self);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_slice_free (TestContainerSearchData, _data_);
#line 1422 "rygel-searchable-container-test.c"
}


static void test_container_real_search (RygelSearchableContainer* base, SearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestContainer * self;
	TestContainerSearchData* _data_;
	TestContainer* _tmp0_;
	SearchExpression* _tmp1_;
	SearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (TestContainer*) base;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_slice_new0 (TestContainerSearchData);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, test_container_real_search);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_container_real_search_data_free);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->self = _tmp0_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = expression;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->expression = _tmp2_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp3_ = offset;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->offset = _tmp3_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp4_ = max_count;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->max_count = _tmp4_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp5_ = cancellable;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->cancellable = _tmp6_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_real_search_co (_data_);
#line 1470 "rygel-searchable-container-test.c"
}


static MediaObjects* test_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	MediaObjects* result;
	TestContainerSearchData* _data_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return NULL;
#line 1481 "rygel-searchable-container-test.c"
	}
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (total_matches) {
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		*total_matches = _data_->total_matches;
#line 1489 "rygel-searchable-container-test.c"
	}
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = _data_->result;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->result = NULL;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 1497 "rygel-searchable-container-test.c"
}


static void test_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestContainerSearchData* _data_;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = _user_data_;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_source_object_ = source_object;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_res_ = _res_;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_real_search_co (_data_);
#line 1511 "rygel-searchable-container-test.c"
}


static gboolean test_container_real_search_co (TestContainerSearchData* _data_) {
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (_data_->_state_) {
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 0:
#line 1520 "rygel-searchable-container-test.c"
		goto _state_0;
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 1:
#line 1524 "rygel-searchable-container-test.c"
		goto _state_1;
		default:
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 1529 "rygel-searchable-container-test.c"
	}
	_state_0:
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp0_ = _data_->expression;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp1_ = _data_->offset;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp2_ = _data_->max_count;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp3_ = _data_->cancellable;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp4_ = 0U;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_state_ = 1;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, test_container_search_ready, _data_);
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 1548 "rygel-searchable-container-test.c"
	_state_1:
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp5_ = NULL;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp5_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->total_matches = _data_->_tmp4_;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_error_free (_data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		if (_data_->_state_ == 0) {
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1568 "rygel-searchable-container-test.c"
		} else {
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1572 "rygel-searchable-container-test.c"
		}
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_object_unref (_data_->_async_result);
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1578 "rygel-searchable-container-test.c"
	}
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->result = _data_->_tmp6_;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1586 "rygel-searchable-container-test.c"
	} else {
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1590 "rygel-searchable-container-test.c"
	}
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1600 "rygel-searchable-container-test.c"
	} else {
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1604 "rygel-searchable-container-test.c"
	}
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 1610 "rygel-searchable-container-test.c"
}


TestContainer* test_container_construct (GType object_type) {
	TestContainer * self = NULL;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (TestContainer*) media_container_construct (object_type);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 1620 "rygel-searchable-container-test.c"
}


TestContainer* test_container_new (void) {
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return test_container_construct (TYPE_TEST_CONTAINER);
#line 1627 "rygel-searchable-container-test.c"
}


static GeeArrayList* test_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	TestContainer* self;
	GeeArrayList* _tmp0_;
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (TestContainer*) base;
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = self->priv->_search_classes;
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = _tmp0_;
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 1643 "rygel-searchable-container-test.c"
}


static void test_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	TestContainer* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (TestContainer*) base;
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = value;
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self->priv->_search_classes = _tmp1_;
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_notify ((GObject *) self, "search-classes");
#line 1663 "rygel-searchable-container-test.c"
}


static void test_container_class_init (TestContainerClass * klass) {
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_parent_class = g_type_class_peek_parent (klass);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_type_class_add_private (klass, sizeof (TestContainerPrivate));
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_test_container_get_property;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_test_container_set_property;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->finalize = test_container_finalize;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEST_CONTAINER_SEARCH_CLASSES, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1680 "rygel-searchable-container-test.c"
}


static void test_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	iface->search = (MediaObjects* (*)(RygelSearchableContainer*, SearchExpression*, guint, guint, guint*, GCancellable*, GError**)) test_container_real_search;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	iface->search_finish = test_container_real_search_finish;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	iface->get_search_classes = test_container_real_get_search_classes;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	iface->set_search_classes = test_container_real_set_search_classes;
#line 1695 "rygel-searchable-container-test.c"
}


static void test_container_instance_init (TestContainer * self) {
	GeeArrayList* _tmp0_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self->priv = TEST_CONTAINER_GET_PRIVATE (self);
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self->priv->_search_classes = _tmp0_;
#line 1707 "rygel-searchable-container-test.c"
}


static void test_container_finalize (GObject* obj) {
	TestContainer * self;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = TEST_CONTAINER (obj);
#line 62 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_main_loop_unref0 (self->loop);
#line 63 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (test_container_parent_class)->finalize (obj);
#line 1721 "rygel-searchable-container-test.c"
}


GType test_container_get_type (void) {
	static volatile gsize test_container_type_id__volatile = 0;
	if (g_once_init_enter (&test_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestContainer), 0, (GInstanceInitFunc) test_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) test_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType test_container_type_id;
		test_container_type_id = g_type_register_static (TYPE_MEDIA_CONTAINER, "TestContainer", &g_define_type_info, 0);
		g_type_add_interface_static (test_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&test_container_type_id__volatile, test_container_type_id);
	}
	return test_container_type_id__volatile;
}


static void _vala_test_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TestContainer * self;
	self = TEST_CONTAINER (object);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (property_id) {
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case TEST_CONTAINER_SEARCH_CLASSES:
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		break;
#line 1750 "rygel-searchable-container-test.c"
		default:
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		break;
#line 1756 "rygel-searchable-container-test.c"
	}
}


static void _vala_test_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TestContainer * self;
	self = TEST_CONTAINER (object);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (property_id) {
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case TEST_CONTAINER_SEARCH_CLASSES:
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		break;
#line 1772 "rygel-searchable-container-test.c"
		default:
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		break;
#line 1778 "rygel-searchable-container-test.c"
	}
}


static GeeList* media_objects_real_slice (GeeAbstractList* base, gint start, gint stop) {
	MediaObjects * self;
	GeeList* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GeeList* _tmp2_ = NULL;
	GeeList* slice;
	MediaObjects* _tmp3_;
	MediaObjects* ret;
#line 125 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (MediaObjects*) base;
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = start;
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = stop;
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp2_ = GEE_ABSTRACT_LIST_CLASS (media_objects_parent_class)->slice ((GeeAbstractList*) GEE_ARRAY_LIST (self), _tmp0_, _tmp1_);
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	slice = _tmp2_;
#line 127 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp3_ = media_objects_new ();
#line 127 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	ret = _tmp3_;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	gee_abstract_collection_add_all ((GeeAbstractCollection*) ret, (GeeCollection*) slice);
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = (GeeList*) ret;
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (slice);
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 1814 "rygel-searchable-container-test.c"
}


MediaObjects* media_objects_construct (GType object_type) {
	MediaObjects * self = NULL;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (MediaObjects*) gee_array_list_construct (object_type, TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 1824 "rygel-searchable-container-test.c"
}


MediaObjects* media_objects_new (void) {
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return media_objects_construct (TYPE_MEDIA_OBJECTS);
#line 1831 "rygel-searchable-container-test.c"
}


static void media_objects_class_init (MediaObjectsClass * klass) {
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	media_objects_parent_class = g_type_class_peek_parent (klass);
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = media_objects_real_slice;
#line 1840 "rygel-searchable-container-test.c"
}


static void media_objects_instance_init (MediaObjects * self) {
}


GType media_objects_get_type (void) {
	static volatile gsize media_objects_type_id__volatile = 0;
	if (g_once_init_enter (&media_objects_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaObjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_objects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaObjects), 0, (GInstanceInitFunc) media_objects_instance_init, NULL };
		GType media_objects_type_id;
		media_objects_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "MediaObjects", &g_define_type_info, 0);
		g_once_init_leave (&media_objects_type_id__volatile, media_objects_type_id);
	}
	return media_objects_type_id__volatile;
}


gint _vala_main (void) {
	gint result = 0;
	GMainLoop* _tmp0_;
	GMainLoop* loop;
	TestContainer* _tmp1_;
	TestContainer* c;
	GMainLoop* _tmp2_;
	GMainLoop* _tmp3_;
	GMainLoop* _tmp4_;
#line 137 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 137 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	loop = _tmp0_;
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = test_container_new ();
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	c = _tmp1_;
#line 139 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp2_ = g_main_loop_new (NULL, FALSE);
#line 139 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_main_loop_unref0 (c->loop);
#line 139 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	c->loop = _tmp2_;
#line 140 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_no_limit (c, NULL, NULL);
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp3_ = c->loop;
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_main_loop_run (_tmp3_);
#line 142 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_with_limit (c, NULL, NULL);
#line 143 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp4_ = c->loop;
#line 143 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_main_loop_run (_tmp4_);
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = 0;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (c);
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_main_loop_unref0 (loop);
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 1903 "rygel-searchable-container-test.c"
}


int main (int argc, char ** argv) {
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_type_init ();
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return _vala_main ();
#line 1912 "rygel-searchable-container-test.c"
}



