//client.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2012
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLD_CLIENT_H_
#define _RPLD_CLIENT_H_

#define RPLD_PROTO_UNUSED  -1
#define RPLD_PROTO_SIMPLE   1
#define RPLD_PROTO_MPD      2

#define RPLD_CLIENTS_MAX    8

// access level:
enum rpld_client_acclev {
 ACCLEV_ERR      = -1,
 ACCLEV_NONE     =  0, // no right to do anything
 ACCLEV_CONCTL,        // only allowed to do basic connection things: noop, quit, auth...
 ACCLEV_GUEST,         // guest connection (read only)
 ACCLEV_USER,          // normal user connect (read write)
 ACCLEV_ALL            // full (admin) access (read write ctl)
};

enum rpld_client_state {
 CSTATE_ERROR  = -1,
 CSTATE_UNUSED =  0,
 CSTATE_USED   =  1
};

struct rpld_proto {
 int proto;
 const char * description;
 int (*set_proto)(int client, struct roar_vio_calls * vio, struct roar_buffer ** obuffer, void ** userdata);
 int (*unset_proto)(int client, struct roar_vio_calls * vio, struct roar_buffer ** obuffer, void ** userdata);
 int (*handle)(int client, struct roar_vio_calls * vio, struct roar_buffer ** obuffer, void ** userdata);
 int (*flush)(int client, struct roar_vio_calls * vio, struct roar_buffer ** obuffer, void ** userdata);
 int (*flushed)(int client, struct roar_vio_calls * vio, struct roar_buffer ** obuffer, void ** userdata);
};

void client_init(void);
int  client_new(struct roar_vio_calls ** vio);
int  client_delete(int id);
int  client_set_proto(int id, int proto);
int  client_get_proto(int id);
struct roar_vio_calls * client_get_vio(int id);

enum rpld_client_acclev client_get_acclev(int id);
int  client_set_acclev(int id, enum rpld_client_acclev acclev, int setter);
int  client_inc_acclev(int id, int inc, int setter);

int  client_set_playlist(int id, pli_t pl);
pli_t client_get_playlist(int id);
int  client_set_queue(int id, pli_t pl);
pli_t client_get_queue(int id);
int  client_set_pointer(int id, int pointer, struct rpld_playlist_pointer * plp);
struct rpld_playlist_pointer * client_get_pointer(int id, int pointer);

int  client_handle(int id);

int  client_str2proto(const char * str);
int  client_str2acclev(const char * str);

#endif

//ll
