/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _DOCSEQDB_H_INCLUDED_
#define _DOCSEQDB_H_INCLUDED_
/* @(#$Id: docseqdb.h,v 1.2 2007/01/19 15:22:50 dockes Exp $  (C) 2004 J.F.Dockes */
#include "docseq.h"
#include "refcntr.h"

#include "searchdata.h"

/** A DocSequence from a Db query (there should be one active for this
    to make sense) */
class DocSequenceDb : public DocSequence {
 public:
    DocSequenceDb(Rcl::Db *d, const string &t, RefCntr<Rcl::SearchData> sdata) 
	: DocSequence(t), m_db(d), m_sdata(sdata), m_rescnt(-1) 
	{}
    virtual ~DocSequenceDb() {}
    virtual bool getDoc(int num, Rcl::Doc &doc, int *percent, string * = 0);
    virtual int getResCnt();
    virtual bool getTerms(vector<string>& terms, 
			  vector<vector<string> >& groups, 
			  vector<int>& gslks) const {
	return m_sdata.getptr()->getTerms(terms, groups, gslks);
    }

    virtual string getAbstract(Rcl::Doc &doc);
    virtual string getDescription() {return m_sdata->getDescription();}

 private:
    Rcl::Db                 *m_db;
    RefCntr<Rcl::SearchData> m_sdata;
    int                      m_rescnt;
};

#endif /* _DOCSEQDB_H_INCLUDED_ */
