MODULE PrettyPrinter ;
(* Pretty printing auxiliary functions for use with CLANG pretty printing
   program generated by COCO from an attributed grammar
   P.D. Terry, Rhodes University, 17 May 1991 *)

IMPORT Wr, Thread ;

<* FATAL Wr.Failure, Thread.Alerted *>

VAR
  indent : CARDINAL := 0 ;

PROCEDURE Append(String : TEXT) =
BEGIN
  Wr.PutText(results, String) ;
END Append ;

PROCEDURE NewLine() =
BEGIN
  Wr.PutChar(results, '\n') ;
  FOR i := 1 TO indent DO
    Wr.PutChar(results, ' ')
  END
END NewLine ;

PROCEDURE IndentNextLine() =
BEGIN
  INC(indent, 2) ;
  NewLine()
END IndentNextLine ;

PROCEDURE ExdentNextLine() =
BEGIN
  DEC(indent, 2) ;
  NewLine()
END ExdentNextLine ;

PROCEDURE Indent() =
BEGIN
  INC(indent, 2)
END Indent ;

PROCEDURE Exdent() =
BEGIN
  DEC(indent, 2)
END Exdent ;

BEGIN
END PrettyPrinter.
