/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file ingame_menu_layer.cpp
 * \brief Implementation of the ptb::ingame_menu_layer class.
 * \author Julien Jorge
 */
#include "ptb/layer/ingame_menu_layer.hpp"

#include "ptb/frame/frame_pause.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Inform the layer that a key had been pressed.
 * \param key The value of the pressed key.
 */
bool ptb::ingame_menu_layer::key_pressed
( const bear::input::key_info& key )
{
  bool result = super::key_pressed( key );

  if ( !result && key.is_escape() )
    {
      show_centered_window( new frame_pause(this) );
      result = true;
    }

  return result;
} // ingame_menu_layer::key_pressed()
