/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_password.tpp
 * \brief Implementation of the template methods of the ptb::frame_password
 *        class.
 * \author Julien Jorge
 */

#include "engine/game.hpp"

#include <claw/string_algorithm.hpp>

/*----------------------------------------------------------------------------*/
/**
 * \brief Execute a 'gamevar' command.
 * \param command The tokens read on the command line.
 */
template<typename T>
void ptb::frame_password::command_game_variable
( const std::string& var_value ) const
{
  const std::size_t equal( var_value.find_first_of('=') );

  if ( equal == std::string::npos )
    claw::logger << claw::log_warning
                 << "gamevar: bad format."
                 << " Must be 'gamevar type name=value'."
                 << std::endl;
  else
    {
      std::string name( var_value.substr(0, equal) );
      std::string value( var_value.substr(equal+1) );

      if ( !claw::text::is_of_type<T>(value) )
        claw::logger << claw::log_warning << "gamevar: incorrect value."
                     << std::endl;
      else
        {
          std::istringstream iss(value);
          T v;

          iss >> v;
          bear::engine::game::get_instance()
            .get_game_variables().template set<T>(name, v);
        }
    }
} // frame_password::command_game_variable()
