/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file button.tpp
 * \brief Implementation of the ptb::button class.
 * \author Julien Jorge
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owner The component owning this one.
 * \param func The function to call when a click occurs.
 * \param arg The argument passed to func. This class does not store a
 *        reference to \a arg.
 */
template<typename Super, typename Function>
ptb::button<Super, Function>::button
( bear::gui::visual_component& owner, function_type func, argument_type arg )
  : super(&owner), m_function(func), m_argument(arg)
{

} // button::button()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called when a click occurs on the button.
 * \param key The mouse button that was clicked.
 * \param pos The position of the click.
 */
template<typename Super, typename Function>
bool ptb::button<Super, Function>::on_mouse_press
( bear::input::mouse::mouse_code key,
  const claw::math::coordinate_2d<unsigned int>& pos )
{
  if ( key == bear::input::mouse::mc_left_button )
    return m_function(m_argument);
  else
    return false;
} // button::on_mouse_press()
