;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../../common.scm")

(define halo-jump
  (lambda (dest_image)

    (let ( (src_name "halo.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (halo_4_green 1)
               (halo_4 2)
               (halo_3_green 3)
               (halo_3 4)
               (halo_2_green 5)
               (halo_2 6)
               (halo_1_green 7)
               (halo_1 8) )

          (create-layer src_image
                        (list halo_1 halo_1_green)
                        0 0 72 62 dest_image)
          (create-layer src_image
                        (list halo_2 halo_2_green)
                        72 0 72 62 dest_image)
          (create-layer src_image
                        (list halo_3 halo_3_green)
                        144 0 72 62 dest_image)
          (create-layer src_image
                        (list halo_4 halo_4_green)
                        0 62 72 62 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define halo-jump

(define halo-hand
  (lambda (dest_image)

    (let ( (src_name "hand-halo.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (halo_3 0)
               (halo_2 1)
               (halo_1 2)
               (halo_0 3) )

          (create-layer src_image
                        (list halo_0)
                        216 0 29 20 dest_image)
          (create-layer src_image
                        (list halo_1)
                        216 20 29 20 dest_image)
          (create-layer src_image
                        (list halo_2)
                        216 40 29 20 dest_image)
          (create-layer src_image
                        (list halo_3)
                        216 60 29 20 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define halo-hand

(let ( (dest_name "halo.png") )
  (let ( (dest_image (car (gimp-image-new 256 128 RGB))) )
    (let ( (bk (car (gimp-layer-new dest_image 256 128 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    (halo-jump dest_image);
    (halo-hand dest_image);

    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
