;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../common.scm")

(let ( (src_name "bonus-box.xcf.bz2")
       (dest_name "bonus-box.png") )
  (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
         (dest_image (car (gimp-image-new 256 256 RGB)))
         )
    (let ( (bk (car (gimp-layer-new dest_image 256 256 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    (let ( (water_plinth 0)
           (fire_plinth 1)
           (stone_plinth 3)
           (invincibility_plinth 6)
           (glass 8)
           (stones 11)
           (more_stones 12)
           (water_1 13)
           (water_2 14)
           (water_3 15)
           (fire_2 16)
           (fire_1 17)
           (invincibility_4 24)
           (invincibility_3 25)
           (invincibility_2 26)
           (invincibility_1 27)
           (statue          28)
           (water_pot 29)
           (fire_pot 30)
           (air_pot 31)
           (pot 32) )

      ; water
      (create-layer src_image (list water_plinth glass water_1 pot)
                    0  0 60 80 dest_image)
      (create-layer src_image (list water_plinth glass water_2 pot)
                    60  0 60 80 dest_image)
      (create-layer src_image (list water_plinth glass water_3 pot)
                    120  0 60 80 dest_image)

      ; stones
      (create-layer src_image (list stone_plinth glass stones)
                    180  0 60 80 dest_image)

      ; more stones
      (create-layer src_image (list stone_plinth glass more_stones)
                    0 80 60 80 dest_image)

      ; fire
      (create-layer src_image (list fire_plinth glass fire_1 pot)
                     60  80 60 80 dest_image)
      (create-layer src_image (list fire_plinth glass fire_2 pot)
                    120  80 60 80 dest_image)
      (create-layer src_image (list fire_plinth glass fire_1 fire_2 pot)
                    180  80 60 80 dest_image)

      ; invincibility
      (create-layer src_image
                    (list invincibility_plinth glass statue invincibility_1)
                    0 160 60 80 dest_image)
      (create-layer src_image
                    (list invincibility_plinth glass statue invincibility_2)
                    60 160 60 80 dest_image)
      (create-layer src_image
                    (list invincibility_plinth glass statue invincibility_3)
                    120 160 60 80 dest_image)
      (create-layer src_image
                    (list invincibility_plinth glass statue invincibility_4)
                    180 160 60 80 dest_image)
    
      ; water pot
      (create-layer-crop src_image (list water_pot)
                         39 54 37 39
                         0 240 15 16 dest_image (list) )

      ; fire pot
      (create-layer-crop src_image (list fire_pot)
                         39 54 37 39
                         15 240 15 16 dest_image (list) )

      ; air pot
      (create-layer-crop src_image (list air_pot)
                         39 54 37 39
                         30 240 15 16 dest_image (list) )
      ) ; let

    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
