/*
    Bear Engine - Model editor

    Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/impl/model_frame.tpp
 * \brief Implementation of the template methods of the bf::model_frame
 *        class.
 * \author Julien Jorge
 */

#include "bf/wx_facilities.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Update the content of a the menu bar or the popup menu. Entries are
 *        enabled/disabled, checkmarks are set or not.
 * \param m The menu to update
 */
template<typename MenuType>
void bf::model_frame::update_menu( MenuType& m ) const
{
  m.Enable(wxID_SAVE, is_changed());

  if ( m_history.can_undo() )
    m.SetLabel
      (wxID_UNDO,
       _("Undo \"") + m_history.get_undo_description()
       + _("\"\tCTRL+Z"));
  else
    m.SetLabel(wxID_UNDO, _("Nothing to undo\tCTRL+Z"));

  if ( m_history.can_redo() )
    m.SetLabel
      (wxID_REDO,
       _("Redo \"") + m_history.get_redo_description()
       + _("\"\tCTRL+Y"));
  else
    m.SetLabel(wxID_REDO, _("Nothing to redo\tCTRL+Y"));

  m.Enable(wxID_UNDO, m_history.can_undo());
  m.Enable(wxID_REDO, m_history.can_redo());

  m.Enable(ID_NEW_SNAPSHOT, can_create_snapshot());
  m.Enable(ID_DELETE_SNAPSHOT, can_delete_snapshot());

#if 0
  m.Enable(wxID_CUT, m_ingame_view->has_selection());
  m.Enable(wxID_COPY, m_ingame_view->has_selection());
  m.Enable
    (wxID_PASTE, !m_ingame_view->get_clipboard().items.empty());
  m.Enable(wxID_DELETE, m_ingame_view->has_selection());

  if ( !m_ingame_view->empty() )
    m.Enable( wxID_SELECTALL, !m_ingame_view->get_active_layer().empty() );
  else
    m.Enable( wxID_SELECTALL, false );
#endif
} // model_frame::update_menu()
