/*
    Bear Engine - Editor library

    Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/class_tree_ctrl.hpp
 * \brief A wxTreeCtrl of the available item classes.
 * \author Julien Jorge
 */
#ifndef __BF_CLASS_TREE_CTRL_HPP__
#define __BF_CLASS_TREE_CTRL_HPP__

#include <wx/treectrl.h>

#include "bf/tree_builder.hpp"
#include "bf/libeditor_export.hpp"

namespace bf
{
  class item_class_pool;

  /**
   * \brief A wxTreeCtrl of the available item classes.
   * \author Julien Jorge
   */
  class BEAR_EDITOR_EXPORT class_tree_ctrl:
    public wxTreeCtrl
  {
  public:
    class_tree_ctrl
    ( const item_class_pool& pool, wxWindow* parent, int id = wxID_ANY,
      bool show_abstract = false );

  private:
    void create_tree( const item_class_pool& pool, bool show_abstract );
    void create_categories_tree
    ( const item_class_pool& pool, tree_builder& tb, bool show_abstract ) const;

    void select_class(bool shift_down);

    void on_double_click(wxMouseEvent& event);
    void on_key_up(wxKeyEvent& event);
    void on_mouse_move(wxMouseEvent& event);

  private:

    DECLARE_EVENT_TABLE()

  }; // class class_tree_ctrl
} // namespace bf

#endif // __BF_CLASS_TREE_CTRL_HPP__
