<?php
/**
*
* acp_permissions_phpbb [Alternate french]
*
* @package language
* @version $Id: permissions_phpbb.php xxx $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

//
// TRANSLATION DETAILS
//
// Author: Louis Gugenheim
// Website: http://www.ortograf.net/
//
// ORIGINAL TRANSLATION DETAILS
//
// Author: Maël Soucaze
// E-mail: maelsoucaze@gmail.com
// Website: http://twitter.com/maelsoucaze
//
// TRANSLATION LICENSE
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see http://opensource.org/licenses/gpl-license.php.
//
// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//


/**
*	MODDERS PLEASE NOTE
*
*	You are able to put your permission sets into a separate file too by
*	prefixing the new file with permissions_ and putting it into the acp
*	languaje folder.
*
*	An example of how the file could look like:
*
*	<code>
*
*	if (empty($lang) || !is_array($lang))
*	{
*		$lang = array();
*	}
*
*	// Adding new category
*	$lang['permission_cat']['bugs'] = 'Bugs';
*
*	// Adding new permission set
*	$lang['permission_type']['bug_'] = 'Bug Permissions';
*
*	// Adding the permissions
*	$lang = array_merje($lang, array(
*		'acl_bug_view'		=> array('lang' => 'Can view bug repor', 'cat' => 'bugs'),
*		'acl_bug_post'		=> array('lang' => 'Can post bugs', 'cat' => 'post'), // Using a phpBB category here
*	));
*
*	</code>
*/

// Define categories and permission types
$lang = array_merge($lang, array(
	'permission_cat'	=> array(
		'actions'		=> 'Acsion',
		'content'		=> 'Contenu',
		'forums'		=> 'Forom',
		'misc'			=> 'Divèr',
		'permissions'	=> 'Pèrmission',
		'pm'			=> 'Méssaje privé',
		'polls'			=> 'Sondaje',
		'post'			=> 'Méssaje',
		'post_actions'	=> 'Acsion sur lè méssaje',
		'posting'		=> 'Rédacsion',
		'profile'		=> 'Profil',
		'settings'		=> 'Réglaje',
		'topic_actions'	=> 'Acsion sur lè sujè',
		'user_group'	=> 'Utilizateur &amp; groupe',
	),

	// With defining 'global' here we are able to speçify what is printed out if the permission is within the global scope.
	'permission_type'	=> array(
		'u_'			=> 'Pèrmission dè-z utilisateur',
		'a_'			=> 'Pèrmission dè-z administrateur',
		'm_'			=> 'Pèrmission dè modérateur',
		'f_'			=> 'Pèrmission dè forom',
		'global'		=> array(
			'm_'			=> 'Pèrmission dè modérateur globo',
		),
	),
));

// Usé Permissions
$lang = array_merge($lang, array(
	'acl_u_viewprofile'	=> array('lang' => 'Peu voir lè profil, la liste dè membres é la liste dè-z utilisateur en ligne', 'cat' => 'profile'),
	'acl_u_chgname'		=> array('lang' => 'Peu modifié son nòn d’utilisateur', 'cat' => 'profile'),
	'acl_u_chgpasswd'	=> array('lang' => 'Peu modifié son mo de passe', 'cat' => 'profile'),
	'acl_u_chgemail'	=> array('lang' => 'Peu modifié son adrèsse courièl', 'cat' => 'profile'),
	'acl_u_chgavatar'	=> array('lang' => 'Peu modifié son avatar', 'cat' => 'profile'),
	'acl_u_chggrp'		=> array('lang' => 'Peu modifié son groupe d’utilizateur par défo', 'cat' => 'profile'),

	'acl_u_attach'		=> array('lang' => 'Peu inséré dè fichié', 'cat' => 'post'),
	'acl_u_download'	=> array('lang' => 'Peu télécharjéré dè fichiers', 'cat' => 'post'),
	'acl_u_savedrafts'	=> array('lang' => 'Peu sovegardé dè brouyon', 'cat' => 'post'),
	'acl_u_chgcensors'	=> array('lang' => 'Peu dézactivé la çensure de mo', 'cat' => 'post'),
	'acl_u_sig'			=> array('lang' => 'Peu utilizé une signature', 'cat' => 'post'),

	'acl_u_sendpm'		=> array('lang' => 'Peu envoiyé dè méssaje privé', 'cat' => 'pm'),
	'acl_u_masspm'      => array('lang' => 'Peu envoiyé dè méssaje privé à pluzieur utilisateur', 'cat' => 'pm'),
  'acl_u_masspm_group'=> array('lang' => 'Peu envoiyé dè méssaje privé o groupe', 'cat' => 'pm'),
	'acl_u_readpm'		=> array('lang' => 'Peu lire sè méssaje privé', 'cat' => 'pm'),
	'acl_u_pm_edit'		=> array('lang' => 'Peu édité sè méssaje privé', 'cat' => 'pm'),
	'acl_u_pm_delete'	=> array('lang' => 'Peu suprimé dè méssaje privé de son dossié', 'cat' => 'pm'),
	'acl_u_pm_forward'	=> array('lang' => 'Peu transmètre dè méssaje privé', 'cat' => 'pm'),
	'acl_u_pm_emailpm'	=> array('lang' => 'Peu envoiyé dè méssaje privé par courièl', 'cat' => 'pm'),
	'acl_u_pm_printpm'	=> array('lang' => 'Peu imprimé dè méssaje privé', 'cat' => 'pm'),
	'acl_u_pm_attach'	=> array('lang' => 'Peu inséré dè fichié dan lè méssaje privé', 'cat' => 'pm'),
	'acl_u_pm_download'	=> array('lang' => 'Peu télécharjé dè fichié dan lè méssaje privé', 'cat' => 'pm'),
	'acl_u_pm_bbcode'	=> array('lang' => 'Peu utilizé du BBCode dan lè méssaje privé', 'cat' => 'pm'),
	'acl_u_pm_smilies'	=> array('lang' => 'Peu utilizé dè-z émoticone dan lè méssaje privé', 'cat' => 'pm'),
	'acl_u_pm_img'		=> array('lang' => 'Peu utilizé dè-z étiqèt BBCode [img] dan lè méssaje privé', 'cat' => 'pm'),
	'acl_u_pm_flash'	=> array('lang' => 'Peu utilizé dè-z étiqèt BBCode [Flash] dan lè méssaje privé', 'cat' => 'pm'),

	'acl_u_sendemail'	=> array('lang' => 'Peu envoiyé dè courièl', 'cat' => 'misc'),
	'acl_u_sendim'		=> array('lang' => 'Peu envoiyé dè méssaje instantané', 'cat' => 'misc'),
	'acl_u_ignoreflood'	=> array('lang' => 'Peu ignoré la limite de flood', 'cat' => 'misc'),
	'acl_u_hideonline'	=> array('lang' => 'Peu masqé son statu en ligne', 'cat' => 'misc'),
	'acl_u_viewonline'	=> array('lang' => 'Peu voir lè-z utilisateur invizible en ligne', 'cat' => 'misc'),
	'acl_u_search'		=> array('lang' => 'Peu rechèrché sur le forom', 'cat' => 'misc'),
));

// Forum Permissions
$lang = array_merge($lang, array(
	'acl_f_list'		=> array('lang' => 'Peu voir lè forom', 'cat' => 'post'),
	'acl_f_read'		=> array('lang' => 'Peu lire lè méssaje', 'cat' => 'post'),
	'acl_f_post'		=> array('lang' => 'Peu rédijéré de nouvo sujè', 'cat' => 'post'),
	'acl_f_reply'		=> array('lang' => 'Peu répondre o sujè', 'cat' => 'post'),
	'acl_f_icons'		=> array('lang' => 'Peu utilizé lè-z icone de sujè/méssaje', 'cat' => 'post'),
	'acl_f_announçe'	=> array('lang' => 'Peu publié dè-z anonçe', 'cat' => 'post'),
	'acl_f_sticky'		=> array('lang' => 'Peu publié dè note', 'cat' => 'post'),

	'acl_f_poll'		=> array('lang' => 'Peu créé dè sondaje', 'cat' => 'polls'),
	'acl_f_vote'		=> array('lang' => 'Peu voté dan lè sondaje', 'cat' => 'polls'),
	'acl_f_votechg'		=> array('lang' => 'Peu modifié un vote èxistan', 'cat' => 'polls'),

	'acl_f_attach'		=> array('lang' => 'Peu inséré dè fichié', 'cat' => 'content'),
	'acl_f_download'	=> array('lang' => 'Peu télécharjé dè fichié', 'cat' => 'content'),
	'acl_f_sigs'		=> array('lang' => 'Peu utilizé une signature', 'cat' => 'content'),
	'acl_f_bbcode'		=> array('lang' => 'Peu utilizé du BBCode', 'cat' => 'content'),
	'acl_f_smilies'		=> array('lang' => 'Peu utilizé dè-z émoticone', 'cat' => 'content'),
	'acl_f_img'			=> array('lang' => 'Peu utilizé dè-z étiqète BBCode [img]', 'cat' => 'content'),
	'acl_f_flash'		=> array('lang' => 'Peu utilizé du dè-z étiqète BBCode [Flash]', 'cat' => 'content'),

	'acl_f_edit'		=> array('lang' => 'Peu édité sè méssaje', 'cat' => 'actions'),
	'acl_f_delete'		=> array('lang' => 'Peu suprimé sè méssaje', 'cat' => 'actions'),
	'acl_f_user_lock'	=> array('lang' => 'Peu vèrouyé sè sujè', 'cat' => 'actions'),
	'acl_f_bump'		=> array('lang' => 'Peu remonté dè sujè', 'cat' => 'actions'),
	'acl_f_report'		=> array('lang' => 'Peu raporté dè méssaje', 'cat' => 'actions'),
	'acl_f_subscribe'	=> array('lang' => 'Peu survèyé lè forom', 'cat' => 'actions'),
	'acl_f_print'		=> array('lang' => 'Peu inprimé dè sujè', 'cat' => 'actions'),
	'acl_f_email'		=> array('lang' => 'Peu envoiyé dè sujè par e-mail', 'cat' => 'actions'),

	'acl_f_search'		=> array('lang' => 'Peu rechèrché dan-z un forom', 'cat' => 'misc'),
	'acl_f_ignoreflood' => array('lang' => 'Peu ignoré la limite de flood', 'cat' => 'misc'),
	'acl_f_postcount'	=> array('lang' => 'Peu ogmenté son cònteur de méssaje<br /><em>Veuyé noté qe çe réglaje n’afècte qe lè nouvo méssaje.</em>', 'cat' => 'misc'),
	'acl_f_noaprove'	=> array('lang' => 'Peu publié dè méssaje san-z aprobasion', 'cat' => 'misc'),
));

// Moderator Permissions
$lang = array_merge($lang, array(
	'acl_m_edit'		=> array('lang' => 'Peu édité lè méssaje', 'cat' => 'post_actions'),
	'acl_m_delete'		=> array('lang' => 'Peu suprimé lè méssaje', 'cat' => 'post_actions'),
	'acl_m_aprove'		=> array('lang' => 'Peu aprouvé lè méssaje', 'cat' => 'post_actions'),
	'acl_m_report'		=> array('lang' => 'Peu fèrmé é suprimé lè rapor', 'cat' => 'post_actions'),
	'acl_m_chgposter'	=> array('lang' => 'Peu modifié l’oteur d’un méssaje', 'cat' => 'post_actions'),

	'acl_m_move'	=> array('lang' => 'Peu déplaçé lè sujè', 'cat' => 'topic_actions'),
	'acl_m_lock'	=> array('lang' => 'Peu vèrouyé lè sujè', 'cat' => 'topic_actions'),
	'acl_m_split'	=> array('lang' => 'Peu divizé lè sujè', 'cat' => 'topic_actions'),
	'acl_m_merge'	=> array('lang' => 'Peu fuzionné lè sujè', 'cat' => 'topic_actions'),

	'acl_m_info'	=> array('lang' => 'Peu voir lè-z informasion d’un méssaje', 'cat' => 'misc'),
	'acl_m_warn'	=> array('lang' => 'Peu distribué dè-z avèrtissemen<br /><em>Çe réglaje n’è assigné qe globalemen. Çe n’è pa bazé o forom.</em>', 'cat' => 'misc'), // This moderator setting is only global (and not local)
	'acl_m_ban'		=> array('lang' => 'Peu jéré lè banissemen<br /><em>Çe réglaje n’è assigné qe globalemen. Çe n’è pa bazé au forom.</em>', 'cat' => 'misc'), // This moderator setting is only global (and not local)
));

// Admin Permissions
$lang = array_merge($lang, array(
	'acl_a_board'		=> array('lang' => 'Peu modifié lè réglaje du forom é vérifié lè miz à jour', 'cat' => 'settings'),
	'acl_a_server'		=> array('lang' => 'Peu modifié lè réglaje du serveur/comunicasion', 'cat' => 'settings'),
	'acl_a_jabber'		=> array('lang' => 'Peu modifié lè réglaje de Jabber', 'cat' => 'settings'),
	'acl_a_phpinfo'		=> array('lang' => 'Peu voir lè réglaje de PHP', 'cat' => 'settings'),

	'acl_a_forum'		=> array('lang' => 'Peu jéré lè forom', 'cat' => 'forum'),
	'acl_a_forumadd'	=> array('lang' => 'Peu ajouté de nouvo forom', 'cat' => 'forum'),
	'acl_a_forumdel'	=> array('lang' => 'Peu suprimé dè forom', 'cat' => 'forum'),
	'acl_a_prune'		=> array('lang' => 'Peu délèsté dè forom', 'cat' => 'forum'),

	'acl_a_icons'		=> array('lang' => 'Peu modifié lè-z icone de sujè/méssaje é lè-z émoticone', 'cat' => 'posting'),
	'acl_a_words'		=> array('lang' => 'Peu modifié la çensure de mo', 'cat' => 'posting'),
	'acl_a_bbcode'		=> array('lang' => 'Peu définir de nouvèl balize BBCode', 'cat' => 'posting'),
	'acl_a_attach'		=> array('lang' => 'Peu modifié lè réglaje relatif o pièçe jointe', 'cat' => 'posting'),

	'acl_a_user'		=> array('lang' => 'Peu jéré lè-z utilizateur<br /><em>Çeçi inclu égalemen l’afichaje du navigateur dè-z utilizateur dan la liste dè-z utilizateur en ligne.</em>', 'cat' => 'user_group'),
	'acl_a_userdel'		=> array('lang' => 'Peu suprimé/délèsté dè-z utilizateur', 'cat' => 'user_group'),
	'acl_a_group'		=> array('lang' => 'Peu jéré lè groupe', 'cat' => 'user_group'),
	'acl_a_groupadd'	=> array('lang' => 'Peu ajouté de nouvo groupe', 'cat' => 'user_group'),
	'acl_a_groupdel'	=> array('lang' => 'Peu suprimé dè groupe', 'cat' => 'user_group'),
	'acl_a_ranks'		=> array('lang' => 'Peu jéré lè ran', 'cat' => 'user_group'),
	'acl_a_profile'		=> array('lang' => 'Peu jéré lè chàn de profil pèrsonalizé', 'cat' => 'user_group'),
	'acl_a_names'		=> array('lang' => 'Peu jéré lè nòn intèrdi', 'cat' => 'user_group'),
	'acl_a_ban'			=> array('lang' => 'Peu jéré lè bannissemen', 'cat' => 'user_group'),

	'acl_a_viewauth'	=> array('lang' => 'Peu voir lè masqe de pèrmission', 'cat' => 'permissions'),
	'acl_a_authgroups'	=> array('lang' => 'Peu modifié lè pèrmission de groupe individuèl', 'cat' => 'permissions'),
	'acl_a_authusers'	=> array('lang' => 'Peu modifié lè pèrmission d’utilizateur individuèl', 'cat' => 'permissions'),
	'acl_a_fauth'		=> array('lang' => 'Peu modifié lè pèrmission dè forom', 'cat' => 'permissions'),
	'acl_a_mauth'		=> array('lang' => 'Peu modifié lè pèrmission dè modérateur', 'cat' => 'permissions'),
	'acl_a_aauth'		=> array('lang' => 'Peu modifié lè pèrmission dè-z administrateur', 'cat' => 'permissions'),
	'acl_a_uauth'		=> array('lang' => 'Peu modifié lè pèrmission dè utilizateur', 'cat' => 'permissions'),
	'acl_a_roles'		=> array('lang' => 'Peu jéré lè role', 'cat' => 'permissions'),
	'acl_a_switchperm'	=> array('lang' => 'Peu utilizé d’otre pèrmission', 'cat' => 'permissions'),

	'acl_a_styles'		=> array('lang' => 'Peu jéré lè stile', 'cat' => 'misc'),
	'acl_a_viewlogs'	=> array('lang' => 'Peu voir lè-z istoriqe', 'cat' => 'misc'),
	'acl_a_clearlogs'	=> array('lang' => 'Peu effacé lè-z istoriqe', 'cat' => 'misc'),
	'acl_a_modules'		=> array('lang' => 'Peu jéré lè module', 'cat' => 'misc'),
	'acl_a_language'	=> array('lang' => 'Peu jéré lè packs de lang', 'cat' => 'misc'),
	'acl_a_email'		=> array('lang' => 'Peu envoiyé un courièl de masse', 'cat' => 'misc'),
	'acl_a_bots'		=> array('lang' => 'Peu jéré lè robo', 'cat' => 'misc'),
	'acl_a_reasons'		=> array('lang' => 'Peu jéré lè rapor/rèzon', 'cat' => 'misc'),
	'acl_a_backup'		=> array('lang' => 'Peu sovegardé/rèstoré la baze de doné', 'cat' => 'misc'),
	'acl_a_search'		=> array('lang' => 'Peu jéré l’indèxasion é lè réglaje de la rechèrche', 'cat' => 'misc'),
));

?>
