///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/scene/material/Material.h>
#include <core/undo/UndoManager.h>

namespace Core {

IMPLEMENT_ABSTRACT_PLUGIN_CLASS(Material, RefTarget)

/******************************************************************************
* Sets the material's name.
******************************************************************************/
void Material::setName(const QString& newName)
{
	if(newName == _name) return;

	if(UNDO_MANAGER.isRecording())
		UNDO_MANAGER.addOperation(new SimplePropertyChangeOperation(this, "name"));

	this->_name = newName;	
	notifyDependents(REFTARGET_CHANGED);
	notifyDependents(SCHEMATIC_TITLE_CHANGED);
}

/******************************************************************************
* Saves the object to the given stream. 
******************************************************************************/
void Material::saveToStream(ObjectSaveStream& stream)
{
	RefTarget::saveToStream(stream);
	stream.beginChunk(0x1277309);
	stream << _name;
	stream.endChunk();
}

/******************************************************************************
* Loads the object from the given stream. 
******************************************************************************/
void Material::loadFromStream(ObjectLoadStream& stream)
{
	RefTarget::loadFromStream(stream);
	stream.expectChunk(0x1277309);
	stream >> _name;
	stream.closeChunk();
}

/******************************************************************************
* Creates a copy of this object. 
******************************************************************************/
RefTarget::SmartPtr Material::clone(bool deepCopy, CloneHelper& cloneHelper)
{
	// Let the base class create an instance of this class.
	Material::SmartPtr clone = static_object_cast<Material>(RefTarget::clone(deepCopy, cloneHelper));

	// Copy name attribute.
	clone->_name = this->_name;
		
	return clone;
}


};
