///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __CHEMICAL_ELEMENTS_H
#define __CHEMICAL_ELEMENTS_H

#include <core/Core.h>
#include <atomviz/AtomViz.h>

namespace AtomViz {

class ATOMVIZ_DLLEXPORT ChemicalElement
{
public:

	enum CrystalStructure {
		Unknown, SimpleCubic, FaceCenteredCubic, BodyCenteredCubic,
		HexagonalClosePacked, Tetragonal, Diatom, Diamond, Orthorhombic,
		Cubic, Monoclinic, Atom, Rhombohedral
	};

	CrystalStructure structure;
	FloatType latticeParameter;

	const char* elementName;
};

extern ATOMVIZ_DLLEXPORT ChemicalElement ChemicalElements[];

extern ATOMVIZ_DLLEXPORT const size_t NumberOfChemicalElements;

};	// End of namespace AtomViz

#endif // __CHEMICAL_ELEMENTS_H
