#include "jdxbase.h"
#include "jdxtypes.h"
#include "jdxblock.h"
#include <tjutils/tjlog_code.h>


const char* JcampDx::get_compName() {return "JDX";}
LOGGROUNDWORK(JcampDx)


/////////////////////////////////////////////////

ArrayScale::ArrayScale(const STD_string& scalelabel, const STD_string& scaleunit, float scalemin, float scalemax)
            : label(scalelabel), unit(scaleunit), minval(scalemin), maxval(scalemax) {
}

STD_string ArrayScale::get_label_with_unit() const {
  STD_string result(label);
  if(unit!="") result+=" ["+unit+"]";
  return result;
}

/////////////////////////////////////////////////

void PixmapProps::get_overlay_range(float& min, float& max) const {
  min=overlay_minval;
  max=overlay_maxval;
  if(overlay_minval==0.0 && overlay_maxval==0.0) {
    min=overlay_map.minvalue();
    max=overlay_map.maxvalue();
  }
}


/////////////////////////////////////////////////


JcampDxClass::JcampDxClass () :
 compatmode(notBroken),
 userDefParameter(true),
 parmode(edit),
 filemode(include),
 id(-1) {
}


JcampDxClass::JcampDxClass(const JcampDxClass& jdc) : id(-1) {
  JcampDxClass::operator = (jdc);
}


JcampDxClass::~JcampDxClass() { // for some reason, making this virtual destructor inline on GCC4, causes a crash ...
  Log<JcampDx> odinlog(this,"~JcampDxClass");
  ODINLOG(odinlog,normalDebug) << "called" << STD_endl;
}


JcampDxClass& JcampDxClass::operator = (const JcampDxClass& jdc) {
  Log<JcampDx> odinlog(this,"JcampDxClass::operator = ");
  ListItem<JcampDxClass>::operator = (jdc);
  Labeled::operator = (jdc);
  compatmode=jdc.compatmode;
  userDefParameter=jdc.userDefParameter;
  parmode=jdc.parmode;
  filemode=jdc.filemode;
  description=jdc.description;
  unit=jdc.unit;
  cmdline_option=jdc.cmdline_option;
  return *this;
}


STD_string JcampDxClass::print() const {
  if(get_filemode()==exclude) return "";
  return get_jdx_prefix()+printvalstring()+get_jdx_postfix();
}


STD_string JcampDxClass::get_parx_code(parxCodeType type, const ParxEquiv& equiv) const {
#ifdef PARAVISION_PLUGIN
  STD_string result;
  if(type==parx_passval) result=equiv.name+"="+get_label()+";\n";
  return result;
#else
  return "";
#endif
}


STD_string JcampDxClass::get_parx_def_string(const STD_string type, unsigned int dim) const {
#ifdef PARAVISION_PLUGIN
  STD_string retstring;

  STD_string typelabel(type);
  if(typelabel.find("bit")!=STD_string::npos) typelabel="int";

  retstring+=typelabel + " parameter {\n";
  retstring+="  display_name \""+STD_string(get_label())+ "\";\n";
//  retstring+="  relations method_relations;\n";
  retstring+="}  "+STD_string(get_label());
  retstring+=n_times("[]",dim);
  retstring+=";\n\n\n";

  return retstring;
#else
  return "";
#endif
}


bool JcampDxClass::parse(STD_string& parstring) {
  Log<JcampDx> odinlog(this,"parse");

  if(parstring.find("\n##")==STD_string::npos) parstring+="\n##"; // make sure we have a trailing ##

  STD_string stringdummy="##"+extract(parstring,"##","\n##"); // extract string between two ##

  stringdummy=rmblock(stringdummy,"##","=",true,true,false,false); // remove line with label

  bool result=parsevalstring(stringdummy); // pass string to underlying data type

  parstring=rmblock(parstring,"##","##",true,false,false,false); // remove me from parstring
  return result;
}


int JcampDxClass::load(const STD_string& filename) {
  JcampDxBlock block;
  block.append(*this);
  return block.load(filename);
}


int JcampDxClass::write(const STD_string &filename) const {
  JcampDxClass* cc=create_copy();
  JcampDxBlock block;
  block.append(*cc);
  int retval=block.write(filename);
  delete cc;
  return retval;
}


STD_string JcampDxClass::get_jdx_prefix() const {
  STD_string result("##");
  if(isUserDefParameter()) result+="$";
  result+=get_label();
  result+="=";
  return result;
}

