c $Id: int_l2e3c.F 19696 2010-10-29 16:53:42Z d3y133 $
*
c:tex-% this is part of the API Standard Integral routines.
c:tex-\subsection{int\_l2e3c}
c:tex-this routine computes the 3 center 2 electron integrals
c:tex-with labels and ``zero'' integrals removed: 
c:tex-\begin{eqnarray*}
c:tex-({\mu}|{\nu}{\lambda}) = \int_{-\infty}^{\infty} g_{\mu}(X_{\mu},r_{1})\frac{1}{r_{12}}
c:tex-g_{\nu}(X_{\nu},r_{2})g_{\lambda}(X_{\lambda},r_{2})dr_{1}dr_{2}
c:tex-\end{eqnarray*}
c:tex-
c:tex-{\it Syntax:}
c:tex-\begin{verbatim}
      subroutine int_l2e3c(brain, ish, ketin, jsh, ksh,
     &       zerotol, canket, leri, eri, nint, ilab, jlab, klab,
     &       lscr, scr)
c:tex-\end{verbatim}
      implicit none
#include "bas.fh"
#include "errquit.fh"
#include "nwc_const.fh"
#include "basP.fh"
#include "basdeclsP.fh"
#include "geomP.fh"
#include "geobasmapP.fh"
#include "mafdecls.fh"
#include "bas_ibs_dec.fh"
#include "stdio.fh"
#include "util.fh"
c
c::external subroutines used
c errquit
c::functions
      integer int_nint_cart
      external int_nint_cart
      logical int_chk_sh
      external int_chk_sh
c::passed
c:tex-\begin{verbatim}
      integer brain ! [input] bra basis set handle
      integer ish   ! [input] shell/contraction index
      integer ketin ! [input] ket basis set handle
      integer jsh   ! [input] shell/contraction index
      integer ksh   ! [input] shell/contraction index
      integer lscr  ! [input] length of scratch array
      double precision scr(lscr) ! [scratch] array
      double precision zerotol   ! [input] zero threshold
      integer leri  ! [input] length of integral array
      integer  nint ! [output] number of integrals computed
      integer ilab(leri) ! [output] i bas fun labels array
      integer jlab(leri) ! [output] j bas fun labels array
      integer klab(leri) ! [output] k bas fun labels array
      double precision eri(leri) ! [output] 2e3c integrals
      logical canket ! [input] canonicalize ket bas. fun. label pairs
c:tex-\end{verbatim}
c::local
      logical shells_ok
      integer i,j,k,bra,ket,icount
      integer numint, newlscr
c
#include "bas_ibs_sfn.fh"
c
c check shells 
c
      shells_ok = int_chk_sh(brain,ish)
      shells_ok = shells_ok .and. int_chk_sh(ketin,jsh)
      shells_ok = shells_ok .and. int_chk_sh(ketin,ksh)
      if (.not.shells_ok)
     &       call errquit('int_l2e3c: invalid contraction/shell',0,
     &       BASIS_ERR)
c
c   check canonicalizations of input shells for canket
c      
      shells_ok = jsh.ge.ksh
      if (.not.shells_ok) then
        write(luout,*)'int_2e3c: shells not canonical on input '
        write(luout,*)'bra basis set handle:',brain
        write(luout,*)'ket basis set handle:',ketin
        write(luout,*)'                 ish:',ish
        write(luout,*)'                 jsh:',jsh
        write(luout,*)'                 ksh:',ksh
        call errquit('int_l2e3c: shells not in canonical order',0, 
     &     BASIS_ERR)
      endif
c
      bra = brain + BASIS_HANDLE_OFFSET
      ket = ketin + BASIS_HANDLE_OFFSET
c
c
c compute eri (instead of copy) in front of scr()
c
      numint = int_nint_cart(brain,ish,ketin,jsh,ketin,ksh,0,0)
      newlscr = lscr - numint
      call int_2e3c(brain,ish,ketin,jsh,ksh,
     &    newlscr,scr(numint+1),numint,scr)
c
      nint = 0
      icount = 0
      do 00100 i = (sf_ibs_cn2bfr(1,ish,bra)),
     &      (sf_ibs_cn2bfr(2,ish,bra))
        do 00200 j = (sf_ibs_cn2bfr(1,jsh,ket)),
     &        (sf_ibs_cn2bfr(2,jsh,ket))
          do 00300 k = (sf_ibs_cn2bfr(1,ksh,ket)),
     &          (sf_ibs_cn2bfr(2,ksh,ket))
            icount = icount + 1
            if (abs(scr(icount)).ge.zerotol) then
              if (canket)then
                if(j.ge.k) then
                  nint = nint + 1
                  eri(nint) = scr(icount)
                  ilab(nint) = i
                  jlab(nint) = j
                  klab(nint) = k
                endif
              else
                nint = nint + 1
                eri(nint) = scr(icount)
                ilab(nint) = i
                jlab(nint) = j
                klab(nint) = k
              endif
            endif
00300     continue
00200   continue
00100 continue
c
      end
