/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "prototypes.h"
#include "tcl.h"
#include "tk.h"

extern Tcl_Interp *interp;

#include "locked.xbm"
#include "unlocked.xbm"
#include "ucl.xbm"
#include "gray75.xbm"
#include "gray33.xbm"
#include "eraser.xbm"
#include "pen.xbm"
#include "digger.xbm"
#include "dashed.xbm"
#include "bullet0.xbm"
#include "bullet1.xbm"


void init_bitmaps()
{
    Tk_DefineBitmap(interp, Tk_GetUid("locked"), locked_bits, locked_width, locked_height);
    Tk_DefineBitmap(interp, Tk_GetUid("unlocked"), unlocked_bits, unlocked_width, unlocked_height);
    Tk_DefineBitmap(interp, Tk_GetUid("ucl"), ucl_bits, ucl_width, ucl_height);
    Tk_DefineBitmap(interp, Tk_GetUid("gray75"), gray75_bits, gray75_width, gray75_height);
    Tk_DefineBitmap(interp, Tk_GetUid("gray33"), gray33_bits, gray33_width, gray33_height);
    Tk_DefineBitmap(interp, Tk_GetUid("eraser"), eraser_bits, eraser_width, eraser_height);
    Tk_DefineBitmap(interp, Tk_GetUid("pen"), pen_bits, pen_width, pen_height);
    Tk_DefineBitmap(interp, Tk_GetUid("digger"), digger_bits, digger_width, digger_height);
    Tk_DefineBitmap(interp, Tk_GetUid("dashed"), dashed_bits, dashed_width, dashed_height);
    Tk_DefineBitmap(interp, Tk_GetUid("bullet0"), bullet0_bits, bullet0_width, bullet0_height);
    Tk_DefineBitmap(interp, Tk_GetUid("bullet1"), bullet1_bits, bullet1_width, bullet1_height);
}
