/* mount.h
   // Copyright (C) 1998 by Steve Borho <steve@borho.myip.org>
   // This software comes with ABSOLUTELY NO WARRANTY
   // This software is free software, and you are welcome to redistribute it
   // under certain conditions
   // See the README file for a more complete notice.
 */

#define BACKCOLOR "#282828"


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <signal.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>

#ifdef __linux__
#include <getopt.h>
#include <mntent.h>
#include <sys/vfs.h>
#endif

#ifdef __FreeBSD__
#include <sys/param.h>
#include <sys/mount.h>
#endif

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include <proplist.h>

typedef unsigned char bool;

#ifndef TRUE
#define FALSE 0
#define TRUE 1
#endif

#define BTN_NEXT         1
#define BTN_PREV         2
#define BTN_MOUNT        4

/* With repeat next/prev if you hold down mouse button */
#define REPEAT_TIMER     5

/* And double-click for open */
#define DBL_CLICK_TIMER  5

/* Amount of time between checking disk space, in half-seconds */
#define CHK_MNT_TIMER    240

#define MAX_MOUNT_POINTS 20
#define MAX_ICONS        9
#define NAME_LEN         11
#define MP_LEN           50

#define ICO_CD           0
#define ICO_FLOPPY       1
#define ICO_ZIP          2
#define ICO_HD           3
#define ICO_DOS          4
#define ICO_MAC          5
#define ICO_OTHER        6
#define ICO_USR1         7
#define ICO_USR2         8

#define CAPACITY_NONE    0
#define CAPACITY_PFULL   1
#define CAPACITY_PEMPTY  2
#define CAPACITY_MFULL   3
#define CAPACITY_MEMPTY  4

/* Default string length */
#define STR 256

typedef struct MPInfo
{
    char            name[NAME_LEN];     /* Name of volume     */
    char            mountStr[MP_LEN];   /* Mount point dir    */
    char            devStr[MP_LEN];     /* /dev filename      */
    int             icon;               /* Icon ID            */
    bool            isMounted;          /* Mounted flag       */
    bool            ignored;            /* Show mount point?  */
    bool            ejectFlag;          /* eject after umount */
    char            showCap;            /* Show capacity flag */
    int             currentCap;         /* Percent full       */
    double          totalSize;          /* Total cap of disk  */
    double          availSize;          /* non-root free blks */
    double          freeSize;           /* Free blocks on disk*/
    int             childPid;           /* pid of child       */
    int             childStatus;        /* status of child    */
    char            childStatusChar;    /* status of child as char to display */
    bool            performEject;
}
MPInfo;

typedef struct allInfo
{
    struct MPInfo  *mpi[MAX_MOUNT_POINTS];
    int             numMounts;
    Pixmap          icons[MAX_ICONS];
    bool            icoIsLoaded[MAX_ICONS];
    char            iconFileName[MAX_ICONS][STR];
    int             numIcons;
    int             curMount;
    int             btnState;           /* Button states             */
    int             btnTimer;           /* Button scroll timer       */
    int             dblTimer;           /* Double click timer        */
    bool            idleCycle;          /* cycle when idle           */
    bool            newbieMessages;     /* Show friendly error msgs  */
    bool            descriptChar;       /* Show descriptive chars    */
    bool            currentMountChanged;
    bool            errorOccured;
    bool            showErrorChars;
}
allInfo;

/*********************************************************************
    Global Variables
 ********************************************************************/
extern char     mountcmd[];
extern char     umountcmd[];
extern char     ejectcmd[];
extern char     opencmd[];
extern char     txtfont[];
extern char     txtcolor[];
extern char     capfont[];
extern char     capcolor[];
extern char     icondir[];
extern char     initialMnt[];

extern struct allInfo  *aiPtr;

/* Defaults. Altered by command line options. */
extern bool     ignoreNFS;
extern bool     userOnly;
extern char    *iconDefaultName[MAX_ICONS];

extern bool     sigHUP;
extern bool     firstTimeUser;
extern int      childRetStatus;

/*********************************************************************
    Function Prototypes
 ********************************************************************/
/* Standard dock-app stuff */
void            initXWin(int argc, char *argv[]);
void            freeXWin();
void            createWin(Window * win);
unsigned long   getColor(char *colorName, float dim);

/* Custom dock-app stuff */
void            scanArgs(int argc, char *argv[]);
void            checkMount(allInfo * ai, bool forced);
void            pressEvent(XButtonEvent *, allInfo *);
void            releaseEvent(XButtonEvent *, allInfo *);
void            repaint();
void            update(allInfo * ai);
void            drawBtns(int btns, allInfo *);
void            setIcon(int num, char *filename, allInfo * ai);
void            initializeAppIcon(void);

/* Mount point detection and properties stuff */
void            parseFstab(allInfo *);
bool            loadPropString(proplist_t, char *, char *, size_t);
void            readProperties(allInfo *);
bool            savePropString(proplist_t, char *, char *, size_t);
void            saveProperties(allInfo *);

/* Special stuff */
void            safeCopy(char *dest, char *src, int dest_len);
void            newSystem(char *command, MPInfo *mp);
void            internalEject(MPInfo * mp);
void            internalMount(MPInfo * mp);
void            internalUmount(MPInfo * mp);
void            callConfigApp(allInfo *ai);
void            showHelpPage(void);
void            handleReturnCode(MPInfo *mp);
void            noZombie(int);
void            sigHUPHandler(int sig);
void            shovelDeadChildren(void);
