# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: lifolbl.tcl,v 2.9 2000/12/31 23:14:19 jfontain Exp $}


# last-in-first-out label generally used at the bottom of an application window for messages display

class lifoLabel {
    variable header [mc Message:]
}

proc lifoLabel::lifoLabel {this parentPath args} composite {
    [new frame $parentPath -relief sunken -borderwidth $widget::option(button,borderwidth)] $args
} {
    variable header

    set path $widget::($this,path)
    composite::manage $this [new label $path -font {helvetica -12 bold} -text $header] header [new frame $path] separator\
        [new scrollingLabel $path -font {helvetica -12}] body
    # anchor header for proper behavior with multi-line messages
    pack $composite::($this,header,path) $composite::($this,separator,path) -side left -anchor nw
    pack $composite::($this,body,path) -fill x -expand 1
    set ($this,lifo) [new lifo]
    composite::complete $this
}

proc lifoLabel::~lifoLabel {this} {
    delete $($this,lifo)
}

proc lifoLabel::options {this} {
    variable header

    return [list\
        [list -borderwidth $widget::option(button,borderwidth) $widget::option(button,borderwidth)]\
        [list -font {helvetica -12} {helvetica -12}]\
        [list -header $header $header]\
        [list -headerfont {helvetica -12 bold} {helvetica -12 bold}]\
        [list -relief sunken sunken]\
        [list -spacing 0 0]\
    ]
}

foreach option {-borderwidth -relief} {
    proc lifoLabel::set$option {this value} "\$widget::(\$this,path) configure $option \$value"
}

proc lifoLabel::set-font {this value} {
    composite::configure $composite::($this,body) -font $value
}

proc lifoLabel::set-headerfont {this value} {
    $composite::($this,header,path) configure -font $value
}

proc lifoLabel::set-header {this value} {
    $composite::($this,header,path) configure -text $value
}

proc lifoLabel::set-spacing {this value} {
    $composite::($this,separator,path) configure -width $value
}

proc lifoLabel::push {this string} {                                                          ;# user procedure for pushing a string
    if {[string length [set current [composite::cget $composite::($this,body) -text]]]>0} {
        xifo::in $($this,lifo) $current                                                ;# store current string in stack if non empty
    }
    composite::configure $composite::($this,body) -text $string
}

proc lifoLabel::pop {this} {                                                                  ;# user procedure for popping a string
    set string {}
    catch {set string [lifo::out $($this,lifo)]}
    composite::configure $composite::($this,body) -text $string
    return $string
}

proc lifoLabel::flash {this string {seconds 1}} {                                            ;# user procedure for flashing a string
    after [expr {1000*$seconds}] lifoLabel::pop $this
    push $this $string
}
